/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.VOB;
import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;

public class SetAttributeCommand
extends OutputCleartoolCommand {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final boolean LINUX = OS_NAME == null ? false : OS_NAME.toLowerCase().startsWith("linux");
    public static final boolean WINDOWS = OS_NAME == null ? false : OS_NAME.toLowerCase().startsWith("windows");
    public static final boolean AIX = OS_NAME == null ? false : OS_NAME.toLowerCase().startsWith("aix");
    private String comment = null;
    private String attributeName = null;
    private String attributeValue = null;
    private String objectSelector = null;

    public SetAttributeCommand(String attributeName, String attributeValue, String branchName, VOB vob, String comment) {
        this.comment = comment;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.objectSelector = "brtype:" + branchName + "@" + vob.getTag();
    }

    public SetAttributeCommand(String attributeName, String attributeValue, String objectSelector) {
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.objectSelector = objectSelector;
    }

    @Override
    protected String[] getArguments() {
        String osAttributeValue = "\\\"" + this.attributeValue + "\\\"";
        if (LINUX || AIX) {
            osAttributeValue = "\"" + this.attributeValue + "\"";
        }
        if (this.comment != null) {
            return new String[]{"mkattr", "-replace", "-c", this.comment, this.attributeName, osAttributeValue, this.objectSelector};
        }
        return new String[]{"mkattr", "-replace", "-nc", this.attributeName, osAttributeValue, this.objectSelector};
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String output, final String error) {
        return new SetAttributeOutput(){

            @Override
            public boolean isSet() {
                return error == null || error.length() <= 0;
            }
        };
    }

    public static interface SetAttributeOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public boolean isSet();
    }
}

