/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.batch;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetQueryBuilder;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.client.batch.BatchDataSource;
import com.ibm.ram.client.status.RAMStatusMonitor;
import com.ibm.ram.common.data.Asset;
import com.ibm.ram.common.data.AssetInformation;
import com.ibm.ram.common.data.SearchQuery;
import com.ibm.ram.common.data.SearchResult;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.batch.Utilities;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class RAMDataSource
extends BatchDataSource {
    protected static final String ASSET_DELIM = "#";
    protected static final String ASSETS_KEY = "ASSETS";
    protected static final String QUERIES_KEY = "QUERIES";
    public static final String ID = "com.ibm.ram.client.batch.RAMDataSource";
    protected RAMSession fSourceSession;
    protected SourceAssetsContainer fContainer = new SourceAssetsContainer(this);
    protected SourceQueryContainer fQueryConatiner = new SourceQueryContainer(this);
    private static final Logger logger = Logger.getLogger((String)RAMDataSource.class.getName());

    public RAMSession getRAMSession() {
        return this.fSourceSession;
    }

    public void addSearchQuery(RAMAssetQueryBuilder search) {
        this.fQueryConatiner.addQuery(search);
    }

    public void addAssets(Asset[] assets, IProgressMonitor monitor) {
        monitor.beginTask(ClientMessages.getString((String)"RAMDataSource.5"), assets.length * 100);
        int i = 0;
        while (i < assets.length) {
            this.fContainer.addAsset(assets[i]);
            monitor.worked(100);
            ++i;
        }
    }

    public void removeAsset(Asset asset) {
        this.fContainer.removeAsset(asset);
    }

    public void removeQuery(RAMAssetQueryBuilder query) {
        this.fQueryConatiner.removeQuery(query);
    }

    @Override
    public Asset[] fetchAssets(RAMStatusMonitor monitor) {
        String message;
        SourceRAMQuery[] queries = this.fQueryConatiner.getQueries();
        SourceRAMAsset[] sourceAssets = this.fContainer.getAssets();
        ArrayList<Object> assets = new ArrayList<Object>();
        int totalWork = (queries.length + 1 + sourceAssets.length) * 100;
        monitor.beginTask(ClientMessages.getString((String)"RAMDataSource.7"), totalWork);
        RAMAssetQueryBuilder individualAssetQuery = null;
        int i = 0;
        while (!monitor.isCanceled() && i < sourceAssets.length) {
            try {
                if (sourceAssets[i].getRAMAsset() instanceof RAMAsset) {
                    assets.add(sourceAssets[i].getRAMAsset());
                    monitor.appendStatus((Object)sourceAssets[i].getRAMAsset(), 1, 17, MessageFormat.format(ClientMessages.getString((String)"BatchTarget_ADD_ASSET"), sourceAssets[i].getRAMAsset()), null);
                } else {
                    if (individualAssetQuery == null) {
                        individualAssetQuery = new RAMAssetQueryBuilder(this.fSourceSession);
                        individualAssetQuery.setMatchAnyField(true);
                    }
                    String GUID_QUERY_PART = individualAssetQuery.createQueryFieldText(individualAssetQuery.QUERY_FIELD_GUID, Utilities.escapeInGuid(sourceAssets[i].getRAMAsset().getGUID()));
                    String VERSION_QUERY_PART = individualAssetQuery.createQueryFieldText(individualAssetQuery.QUERY_FIELD_VERSION, sourceAssets[i].getRAMAsset().getVersion());
                    String QUERY = String.valueOf(GUID_QUERY_PART) + " && " + VERSION_QUERY_PART;
                    individualAssetQuery.addQueryTextField(QUERY);
                }
                monitor.worked(100);
            }
            catch (RAMRuntimeException e) {
                message = MessageFormat.format(ClientMessages.getString((String)"RAMDataSource.FAILED_TO_ADD_ASSET"), sourceAssets[i].getRAMAsset());
                monitor.appendStatus((Object)sourceAssets[i].getRAMAsset(), 4, 1017, message, (Throwable)e);
                logger.error((Object)message, (Throwable)e);
            }
            ++i;
        }
        if (individualAssetQuery == null) {
            monitor.worked(100);
        } else {
            SourceRAMQuery[] tmpQueries = queries;
            queries = new SourceRAMQuery[queries.length + 1];
            queries[0] = new SourceRAMQuery(individualAssetQuery, this.fQueryConatiner);
            System.arraycopy(tmpQueries, 0, queries, 1, tmpQueries.length);
        }
        i = 0;
        while (!monitor.isCanceled() && i < queries.length) {
            try {
                RAMAssetQueryBuilder search = queries[i].getRAMAssetQuery();
                monitor.subTask(MessageFormat.format(ClientMessages.getString((String)"RAMDataSource.FETCH_ASSETS_FROM_QUERY"), search.getQueryString()));
                search.setResultsStartIndex(0);
                SearchResult results = this.fSourceSession.getAssets((SearchQuery)search);
                int totalNumberOfAssets = results.getTotalResultsCount();
                int assetRunningCount = 0;
                AssetInformation[] queryAssets = results.getAssets();
                SubProgressMonitor addAssetsMonitor = new SubProgressMonitor((IProgressMonitor)monitor, 100);
                addAssetsMonitor.beginTask(ClientMessages.getString((String)"RAMDataSource.9"), totalNumberOfAssets * 100);
                while (!monitor.isCanceled() && assetRunningCount < totalNumberOfAssets) {
                    int j = 0;
                    while (!monitor.isCanceled() && j < queryAssets.length) {
                        assets.add(queryAssets[j]);
                        addAssetsMonitor.worked(100);
                        ++assetRunningCount;
                        monitor.appendStatus((Object)queryAssets[j], 1, 17, MessageFormat.format(ClientMessages.getString((String)"BatchTarget_ADD_ASSET"), queryAssets[j]), null);
                        ++j;
                    }
                    if (monitor.isCanceled() || assetRunningCount >= totalNumberOfAssets) continue;
                    try {
                        search.setResultsStartIndex(assetRunningCount);
                        results = this.fSourceSession.getAssets((SearchQuery)search);
                        queryAssets = results.getAssets();
                        if (queryAssets != null) {
                            if (queryAssets.length != 0) continue;
                        }
                    }
                    catch (Throwable e) {
                        String message2 = String.valueOf(ClientMessages.getString((String)"RAMDataSource.10")) + queries[i];
                        monitor.appendStatus((Object)queries[i], 4, 1017, message2, e);
                        logger.error((Object)message2, e);
                    }
                    break;
                }
            }
            catch (RAMRuntimeException e) {
                message = String.valueOf(ClientMessages.getString((String)"RAMDataSource.10")) + queries[i];
                monitor.appendStatus((Object)queries[i], 4, 1017, message, (Throwable)e);
                logger.error((Object)message, (Throwable)e);
            }
            ++i;
        }
        return assets.toArray(new Asset[assets.size()]);
    }

    public SourceAssetsContainer getAssets() {
        return this.fContainer;
    }

    public SourceQueryContainer getQueries() {
        return this.fQueryConatiner;
    }

    @Override
    public void initialize(String metadata) {
    }

    @Override
    public String save() {
        return "";
    }

    public String toString() {
        if (this.getRAMSession() != null) {
            return String.valueOf(this.getRAMSession().getRAMServerLoginid()) + "@" + this.getRAMSession().getRAMServerURL();
        }
        return super.toString();
    }

    @Override
    public String getTypeId() {
        return ID;
    }

    public class SourceAssetsContainer {
        private RAMDataSource fRAMDataSource;
        private Map fAssets = new HashMap();

        public SourceAssetsContainer(RAMDataSource dataSource) {
            this.fRAMDataSource = dataSource;
        }

        public int getAssetCount() {
            return this.fAssets.size();
        }

        public void addAsset(Asset asset) {
            String id = String.valueOf(asset.getGUID()) + "[" + asset.getVersion() + "]";
            this.fAssets.put(id, new SourceRAMAsset(asset, this));
        }

        public SourceRAMAsset[] getAssets() {
            Collection values = this.fAssets.values();
            return values.toArray(new SourceRAMAsset[values.size()]);
        }

        public void removeAsset(Asset asset) {
            String id = String.valueOf(asset.getGUID()) + "[" + asset.getVersion() + "]";
            this.fAssets.remove(id);
        }

        public RAMDataSource getRAMDataSource() {
            return this.fRAMDataSource;
        }

        public void setRAMDataSource(RAMDataSource dataSource) {
            this.fRAMDataSource = dataSource;
        }

        public void setAssets(Map assets) {
            this.fAssets = assets;
        }
    }

    public class SourceQueryContainer {
        private RAMDataSource fRAMDataSource;
        private List fQueries = new ArrayList();
        private SourceRAMQuery[] fQueryCache;

        public SourceQueryContainer(RAMDataSource ramDataSource) {
            this.fRAMDataSource = ramDataSource;
        }

        public void addQuery(RAMAssetQueryBuilder query) {
            this.fQueryCache = null;
            this.fQueries.add(new SourceRAMQuery(query, this));
        }

        public SourceRAMQuery[] getQueries() {
            if (this.fQueryCache == null) {
                this.fQueryCache = this.fQueries.toArray(new SourceRAMQuery[this.fQueries.size()]);
            }
            return this.fQueryCache;
        }

        public RAMDataSource getRAMDataSource() {
            return this.fRAMDataSource;
        }

        public void removeQuery(RAMAssetQueryBuilder query) {
            this.fQueryCache = null;
            this.fQueries.remove(new SourceRAMQuery(query, this));
        }

        public void setRAMDataSource(RAMDataSource dataSource) {
            this.fRAMDataSource = dataSource;
        }
    }

    public class SourceRAMAsset {
        private Asset fRAMAsset;
        private SourceAssetsContainer fSourceContainer;

        public SourceRAMAsset(Asset asset, SourceAssetsContainer container) {
            this.fRAMAsset = asset;
            this.fSourceContainer = container;
        }

        public Asset getRAMAsset() {
            return this.fRAMAsset;
        }

        public void setRAMAsset(Asset asset) {
            this.fRAMAsset = asset;
        }

        public SourceAssetsContainer getContainer() {
            return this.fSourceContainer;
        }

        public void setContainer(SourceAssetsContainer container) {
            this.fSourceContainer = container;
        }

        public String toString() {
            return this.fRAMAsset.toString();
        }
    }

    public class SourceRAMQuery {
        private RAMAssetQueryBuilder fRAMAssetQuery;
        private SourceQueryContainer fSourceQueryContainer;

        public SourceRAMQuery(RAMAssetQueryBuilder query, SourceQueryContainer container) {
            this.fRAMAssetQuery = query;
            this.fSourceQueryContainer = container;
        }

        public RAMAssetQueryBuilder getRAMAssetQuery() {
            return this.fRAMAssetQuery;
        }

        public void setRAMAssetQuery(RAMAssetQueryBuilder assetQuery) {
            this.fRAMAssetQuery = assetQuery;
        }

        public SourceQueryContainer getSourceQueryContainer() {
            return this.fSourceQueryContainer;
        }

        public void setSourceQueryContainer(SourceQueryContainer sourceQueryContainer) {
            this.fSourceQueryContainer = sourceQueryContainer;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SourceRAMQuery)) {
                return false;
            }
            return this.fRAMAssetQuery.equals(((SourceRAMQuery)o).getRAMAssetQuery());
        }

        public int hashCode() {
            return this.fRAMAssetQuery.hashCode();
        }

        public String toString() {
            return this.fRAMAssetQuery.toString();
        }
    }
}

