/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.udeploy.repo.integration;

import com.ibm.ram.cli.Logger;
import com.ibm.ram.cli.Ram;
import com.ibm.ram.client.RAMAssetQueryBuilder;
import com.ibm.ram.client.RAMAssetSearchResult;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.SearchQuery;
import com.ibm.ram.common.data.SearchResult;
import com.ibm.ram.internal.cli.command.ConfigCommand;
import com.ibm.ram.internal.cli.command.GetCommand;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;

public class RAMHelper {
    final String repo;
    final String user;
    final String password;
    final String guid;
    final String versionPattern;
    final String query;
    final String state;
    private Map<String, File> tempDirs = new HashMap<String, File>();
    private RAMSession ramSession;

    public RAMHelper(String repo, String user, String password, String guid, String versionPattern, String query, String state) throws IOException {
        if (repo.endsWith("/")) {
            repo = repo.substring(0, repo.length() - 1);
        }
        this.repo = repo;
        this.user = user;
        this.password = password;
        this.guid = guid;
        this.versionPattern = versionPattern;
        this.query = query;
        this.state = state;
    }

    public String getVersion(String revision) throws IOException {
        RAMAssetSearchResult[] assets;
        revision = revision == null || revision.trim().length() == 0 ? ".*" : revision.replace("*", ".*");
        Pattern regex = Pattern.compile(revision);
        SearchResult searchResult = this.search(this.guid, this.versionPattern, this.query, this.state, -1);
        if (searchResult != null && (assets = (RAMAssetSearchResult[])searchResult.getAssetSearchResults()) != null) {
            RAMAssetSearchResult[] rAMAssetSearchResultArray = assets;
            int n = assets.length;
            int n2 = 0;
            while (n2 < n) {
                RAMAssetSearchResult result = rAMAssetSearchResultArray[n2];
                AssetIdentification assetId = result.getAsset().getIdentification();
                Matcher matcher = regex.matcher(assetId.getVersion());
                if (matcher.matches()) {
                    return assetId.getVersion();
                }
                ++n2;
            }
        }
        return null;
    }

    public List<String> getLatestVersions(int count) throws IOException {
        RAMAssetSearchResult[] assets;
        ArrayList<String> versions = new ArrayList<String>();
        SearchResult searchResult = this.search(this.guid, this.versionPattern, this.query, this.state, count);
        if (searchResult != null && (assets = (RAMAssetSearchResult[])searchResult.getAssetSearchResults()) != null) {
            RAMAssetSearchResult[] rAMAssetSearchResultArray = assets;
            int n = assets.length;
            int n2 = 0;
            while (n2 < n) {
                RAMAssetSearchResult result = rAMAssetSearchResultArray[n2];
                AssetIdentification assetId = result.getAsset().getIdentification();
                versions.add(assetId.getVersion());
                ++n2;
            }
        }
        return versions;
    }

    SearchResult search(String id, String version, String queryString, String state, int count) {
        SearchResult searchResult;
        RAMAssetQueryBuilder queryBuilder = new RAMAssetQueryBuilder(this.getRAMSession());
        String queryId = null;
        if (id != null && id.length() > 0) {
            id = id.replaceAll(" ", "\\\\ ");
            queryId = new String(" id:(" + id + ") ");
        }
        String queryVersion = null;
        if (version != null && version.length() > 0) {
            queryVersion = new String(" version:(" + version + ") ");
        }
        String queryState = null;
        if (state != null && state.length() > 0) {
            queryState = new String(" state:(" + state + ") ");
        }
        if (queryString == null || !queryString.startsWith("ramSearch:(")) {
            StringBuilder queryStringBuilder = new StringBuilder();
            if (queryString != null) {
                queryStringBuilder.append(queryString);
            }
            if (queryId != null) {
                queryStringBuilder.append(queryId);
            }
            if (queryVersion != null) {
                queryStringBuilder.append(queryVersion);
            }
            if (queryState != null) {
                queryStringBuilder.append(queryState);
            }
            queryBuilder.addQueryTextField(queryStringBuilder.toString());
            queryBuilder.setSortAscending(false);
            queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_VERSION);
            if (count != -1) {
                queryBuilder.setMaxResults(count);
            }
            searchResult = this.getRAMSession().getAssets((SearchQuery)queryBuilder);
        } else {
            if (queryId != null || queryVersion != null) {
                StringBuilder sb = new StringBuilder("$txt,");
                if (queryId != null) {
                    sb.append(queryId);
                }
                if (queryVersion != null) {
                    sb.append(queryVersion);
                }
                StringBuilder queryStringBuilder = new StringBuilder(queryString);
                int insertIndex = queryString.lastIndexOf(")");
                if (insertIndex > -1) {
                    queryStringBuilder.insert(insertIndex, sb);
                } else {
                    queryStringBuilder.append((CharSequence)sb);
                }
                queryString = queryStringBuilder.toString();
            }
            SearchQuery searchQuery = new SearchQuery();
            searchQuery.setQueryString(queryString);
            searchQuery.setSortAscending(false);
            queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_VERSION);
            if (count != -1) {
                searchQuery.setMaxResults(count);
            }
            searchResult = this.getRAMSession().getAssets(searchQuery);
        }
        return searchResult;
    }

    private File getTempDir(String version) throws IOException {
        File result = this.tempDirs.get(version);
        if (result == null) {
            result = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
            IO.mkdirs((File)result);
            this.tempDirs.put(version, result);
        }
        return result;
    }

    public File downloadFiles(String version, boolean includeDependent) throws Exception {
        File tempDir = this.getTempDir(version);
        UDeployLogger logger = new UDeployLogger();
        String[] arguments = new String[]{"config", "-url", this.repo, "-u", this.user, "-p", this.password};
        Ram.execute(new ConfigCommand(arguments), logger);
        String[] getArgs = includeDependent ? new String[]{"get", this.guid, version, "-d", tempDir.getPath()} : new String[]{"get", "-n", this.guid, version, "-d", tempDir.getPath()};
        Ram.execute(new GetCommand(getArgs), logger);
        return tempDir;
    }

    private RAMSession getRAMSession() {
        if (this.ramSession == null) {
            this.ramSession = new RAMSession(this.repo, this.user, this.password);
        }
        return this.ramSession;
    }

    public void release() {
        if (this.ramSession != null) {
            this.ramSession.release();
        }
    }

    public String getState(String version) {
        RAMAssetSearchResult[] assets;
        SearchResult searchResult = this.search(this.guid, version, null, null, 1);
        if (searchResult != null && searchResult != null && (assets = (RAMAssetSearchResult[])searchResult.getAssetSearchResults()) != null && assets.length > 0) {
            return assets[0].getAsset().getStateName();
        }
        return null;
    }

    public String getWebURL() {
        return this.getRAMSession().getWebServerURL();
    }

    public class UDeployLogger
    implements Logger {
        @Override
        public void log(IStatus status) {
            String msg = status.getMessage();
            if (msg != null && msg.length() > 0) {
                if (status.isOK()) {
                    System.out.println(status.getMessage());
                } else {
                    throw new RuntimeException(status.getMessage());
                }
            }
        }
    }
}

