/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant;

import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.client.ant.tasks.RAMTask;
import com.ibm.ram.internal.client.ant.types.RAMDataType;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;

public class LoggingUtil {
    public static void errorExclusiveAttributes(ProjectComponent element, String attributeNames) {
        LoggingUtil.error(element, MessageFormat.format(ClientMessages.getString((String)"Ant.ExclusiveAttributes"), element.getProject().getElementName((Object)element), attributeNames));
    }

    public static void errorRequiredAttribute(ProjectComponent element, String attributeName) {
        LoggingUtil.error(element, MessageFormat.format(ClientMessages.getString((String)"Ant.MustSpecifyAttribute"), attributeName, element.getProject().getElementName((Object)element)));
    }

    public static void warnOnlyOneChildAllowed(ProjectComponent element, ProjectComponent childElement) {
        LoggingUtil.warn(element, MessageFormat.format(ClientMessages.getString((String)"Ant.OnlyOneChildAllowed"), element.getProject().getElementName((Object)childElement), element.getProject().getElementName((Object)element)));
    }

    public static void errorAtLeastOneChild(ProjectComponent element, ProjectComponent childElement) {
        LoggingUtil.error(element, MessageFormat.format(ClientMessages.getString((String)"Ant.OneChildMustBeSpecified"), element.getProject().getElementName((Object)childElement), element.getProject().getElementName((Object)element)));
    }

    public static void errorGettingObject(ProjectComponent element, String name) {
        LoggingUtil.error(element, MessageFormat.format(ClientMessages.getString((String)"Ant.ErrorGettingObject"), element.getProject().getElementName((Object)element), name));
    }

    public static void errorGettingObject(ProjectComponent element, String name, Throwable t) {
        LoggingUtil.error(element, MessageFormat.format(ClientMessages.getString((String)"Ant.ErrorGettingObject"), element.getProject().getElementName((Object)element), name), t);
    }

    public static void warnNoValueSpecified(ProjectComponent element) {
        LoggingUtil.warn(element, ClientMessages.getString((String)"Ant.NoValueSpecified"));
    }

    public static void error(ProjectComponent element, Throwable t) {
        LoggingUtil.error(element, null, t);
    }

    public static void error(Project project, Throwable t) {
        LoggingUtil.error(project, null, t);
    }

    public static void warn(ProjectComponent element, Throwable t) {
        LoggingUtil.warn(element, null, t);
    }

    public static void info(ProjectComponent element, Throwable t) {
        LoggingUtil.info(element, null, t);
    }

    public static void verbose(ProjectComponent element, Throwable t) {
        LoggingUtil.verbose(element, null, t);
    }

    public static void debug(ProjectComponent element, Throwable t) {
        LoggingUtil.debug(element, null, t);
    }

    public static void error(ProjectComponent element, String message) {
        LoggingUtil.error(element, message, null);
    }

    public static void error(Project project, String message) {
        LoggingUtil.error(project, message, null);
    }

    public static void warn(ProjectComponent element, String message) {
        LoggingUtil.warn(element, message, null);
    }

    public static void info(ProjectComponent element, String message) {
        LoggingUtil.info(element, message, null);
    }

    public static void verbose(ProjectComponent element, String message) {
        LoggingUtil.verbose(element, message, null);
    }

    public static void debug(ProjectComponent element, String message) {
        LoggingUtil.debug(element, message, null);
    }

    public static void error(ProjectComponent element, String message, Throwable t) {
        LoggingUtil.logMessage(element, message, 0, t);
    }

    public static void error(Project project, String message, Throwable t) {
        LoggingUtil.logMessage(project, message, 0, t);
    }

    public static void warn(ProjectComponent element, String message, Throwable t) {
        LoggingUtil.logMessage(element, message, 1, t);
    }

    public static void info(ProjectComponent element, String message, Throwable t) {
        LoggingUtil.logMessage(element, message, 2, t);
    }

    public static void verbose(ProjectComponent element, String message, Throwable t) {
        LoggingUtil.logMessage(element, message, 3, t);
    }

    public static void debug(ProjectComponent element, String message, Throwable t) {
        LoggingUtil.logMessage(element, message, 4, t);
    }

    private static boolean isFailOnError(Object element) {
        if (element instanceof RAMTask) {
            return ((RAMTask)((Object)element)).isFailOnError();
        }
        if (element instanceof RAMDataType) {
            return ((RAMDataType)((Object)element)).isFailOnError();
        }
        return true;
    }

    private static void logMessage(Object element, String message, int level, Throwable t) {
        StringBuilder sb = new StringBuilder();
        if (message != null) {
            sb.append(message);
        }
        if (t != null) {
            sb.append("\n");
            sb.append(UtilitiesCommon.getStacktrace((Throwable)t));
        }
        message = sb.toString();
        if (level == 0 && LoggingUtil.isFailOnError(element)) {
            if (element instanceof ProjectComponent) {
                throw new BuildException(message, t, ((ProjectComponent)element).getLocation());
            }
            throw new BuildException(message, t);
        }
        if (element instanceof ProjectComponent) {
            ((ProjectComponent)element).log(message, level);
        } else if (element instanceof Project) {
            ((Project)element).log(message, level);
        }
    }
}

