/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.tasks;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetValidation;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.tasks.RAMTask;
import com.ibm.ram.internal.client.ant.types.Asset;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SubmitTask
extends RAMTask {
    private String guid;
    private Asset asset;

    public void add(Asset asset) {
        if (this.asset != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)asset);
        } else {
            if (this.getSession() != null) {
                asset.setSession(this.getSession());
            }
            asset.setTask(this);
            this.asset = asset;
        }
    }

    @Override
    public void execute() throws BuildException {
        try {
            String guid;
            super.execute();
            if (this.getAsset() == null) {
                LoggingUtil.errorAtLeastOneChild((ProjectComponent)this, (ProjectComponent)new Asset());
            }
            LoggingUtil.verbose((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.SubmitTask.SubmittingAsset"), String.valueOf(this.asset.getName()) + " [" + this.asset.getNewVersion() + "]"));
            String version = this.getAsset().getNewVersion();
            if (version == null) {
                LoggingUtil.error((ProjectComponent)this.getAsset(), MessageFormat.format(ClientMessages.getString((String)"Ant.ReversionTask.MustSetNewVersion"), String.valueOf(this.asset.getName()) + " [" + version + "]"));
            }
            if ((guid = this.getAsset().getNewGuid()) != null) {
                this.getAsset().setAsset(this.getSession().createAsset(guid, version));
            } else {
                this.getAsset().setAsset(this.getSession().createAsset(version));
            }
            this.getAsset().commitModel();
            RAMAsset asset = this.getAsset().getAsset();
            RAMAssetValidation[] errors = asset.validate();
            if (errors != null && errors.length > 0) {
                StringBuffer buffer = new StringBuffer("\n");
                buffer.append(ClientMessages.getString((String)"Ant.ValidationErrorsExist"));
                buffer.append("\n");
                int i = 0;
                while (i < errors.length) {
                    buffer.append(errors[i].getMessage());
                    buffer.append("\n");
                    ++i;
                }
                LoggingUtil.error((ProjectComponent)this, buffer.toString());
            } else {
                this.getSession().queueAssetForPut(asset);
                this.getSession().put((IRAMSessionObject)asset, (IProgressMonitor)new NullProgressMonitor());
                if (this.getGuidProperty() != null && this.getGuidProperty().length() > 0) {
                    this.getProject().setProperty(this.getGuidProperty(), asset.getIdentification().getGUID());
                }
            }
        }
        catch (Exception e) {
            LoggingUtil.error((ProjectComponent)this, (Throwable)e);
        }
    }

    public Asset getAsset() {
        return this.asset;
    }

    @Override
    public List getChildren() {
        ArrayList<Asset> children = new ArrayList<Asset>();
        children.add(this.getAsset());
        return children;
    }

    public String getGuidProperty() {
        return this.guid;
    }

    public void setGuidProperty(String guid) {
        this.guid = guid;
    }
}

