/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetAttribute;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.AssetAttribute;
import com.ibm.ram.common.data.ResourceAttribute;
import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.internal.json.JsonUtil;
import java.util.Collections;
import java.util.Set;

public class RAMResourceAttribute
extends RAMAssetAttribute {
    private ResourceAttribute resourceAttr = new ResourceAttribute();

    public RAMResourceAttribute(RAMSession session, AssetAttribute internalCustomAttribute) {
        super(session, internalCustomAttribute);
        this.parseAttributeValue();
    }

    public RAMResourceAttribute(RAMAsset asset, ManifestAccessor.CustomAttribute internalCustomAttribute) {
        super(asset, internalCustomAttribute);
        this.parseAttributeValue();
    }

    public RAMResourceAttribute(RAMSession session, String name) {
        super(session, name);
        this.parseAttributeValue();
    }

    private void parseAttributeValue() {
        String[] values = super.getValues();
        if (values != null && values.length > 0) {
            this.resourceAttr = JsonUtil.getGson().fromJson(values[0], ResourceAttribute.class);
        }
    }

    public void addLink(ResourceAttribute.ResourceLink link) {
        if (this.resourceAttr == null) {
            this.resourceAttr = new ResourceAttribute();
            this.resourceAttr.setUserId(this.getSession().getUser().getUid());
        }
        this.resourceAttr.getLinks().add(link);
        this.setValues(new String[]{JsonUtil.getGson().toJson(this.resourceAttr)});
        this.setDirty(true);
    }

    public void removeLink(ResourceAttribute.ResourceLink link) {
        if (this.resourceAttr != null) {
            this.resourceAttr.getLinks().remove(link);
            if (this.resourceAttr.getLinks().isEmpty()) {
                this.setValues(null);
            } else {
                this.setValues(new String[]{JsonUtil.getGson().toJson(this.resourceAttr)});
            }
        } else {
            this.setValues(null);
        }
        this.setDirty(true);
    }

    public Set<ResourceAttribute.ResourceLink> getLinks() {
        return Collections.unmodifiableSet(this.resourceAttr.getLinks());
    }
}

