/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.internal.common.util.LifecycleUtilities;
import com.ibm.ram.internal.jaxb.Action;
import com.ibm.ram.internal.jaxb.Link;
import com.ibm.ram.internal.jaxb.State;
import com.ibm.ram.internal.jaxb.Workflow;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import java.util.ArrayList;
import java.util.List;

public class RAMState
extends com.ibm.ram.common.data.State {
    private RAMSession fSession;

    RAMState(RAMSession session, com.ibm.ram.common.data.State webServiceState) {
        this.fSession = session;
        this.setId(webServiceState.getId());
        this.setName(webServiceState.getName());
        this.setIdentifier(webServiceState.getName());
        this.setWorkflowId(JAXBLinksUtil.LEGACY_WORKFLOW_ID);
    }

    RAMState(RAMSession session, State jaxbState) {
        this.fSession = session;
        this.setId(jaxbState.getDbid());
        this.setName(jaxbState.getName());
        this.setIdentifier(jaxbState.getIdentifier());
        this.setWorkflowId(JAXBLinksUtil.getWorkflowIdentifier(jaxbState.getWorkflow()));
    }

    State getRESTState(RAMAsset asset) {
        Workflow workflow = asset.getWorkflow();
        State ret = null;
        if (workflow != null) {
            ret = LifecycleUtilities.getStateByName(workflow, this.getName());
        }
        return ret;
    }

    List<RAMAction> getAvailableActions(RAMAsset asset) {
        State restState = this.getRESTState(asset);
        ArrayList<RAMAction> actions = new ArrayList<RAMAction>();
        if (restState != null) {
            for (Link<Action> actionRef : restState.getActions()) {
                Action action = actionRef.getValue();
                if (action == null) {
                    action = LifecycleUtilities.getAction(asset.getWorkflow(), actionRef);
                    actions.add(new RAMAction(action));
                    continue;
                }
                actions.add(new RAMAction(action));
            }
        }
        return actions;
    }
}

