/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.common.util.Enumerator;

public class EMFEnumSet<E extends Enumerator>
extends AbstractSet<E>
implements Cloneable {
    private long bitmap;
    private final Class<E> cls;
    private final int min;
    private final int max;
    private final Method getValue;

    public static <T extends Enumerator> EMFEnumSet<T> noneOf(Class<T> cls) {
        return new EMFEnumSet<T>(cls);
    }

    public static <T extends Enumerator> EMFEnumSet<T> create(long bitmap, Class<T> cls) {
        return new EMFEnumSet<T>(bitmap, cls);
    }

    public static <T extends Enumerator> EMFEnumSet<T> allOf(Class<T> cls) {
        EMFEnumSet<T> es = new EMFEnumSet<T>(-1L, cls);
        return es;
    }

    public static <T extends Enumerator> EMFEnumSet<T> of(T t) {
        EMFEnumSet<?> s = EMFEnumSet.noneOf(t.getClass());
        s.add(t);
        return s;
    }

    public static <T extends Enumerator> EMFEnumSet<T> of(T t1, T t2) {
        EMFEnumSet<T> s = EMFEnumSet.of(t1);
        s.add(t2);
        return s;
    }

    public static <T extends Enumerator> EMFEnumSet<T> of(T t1, T t2, T t3) {
        EMFEnumSet<T> s = EMFEnumSet.of(t1, t2);
        s.add(t3);
        return s;
    }

    public static <T extends Enumerator> EMFEnumSet<T> of(T first, T ... rest) {
        EMFEnumSet<T> s = EMFEnumSet.of(first);
        Collections.addAll(s, rest);
        return s;
    }

    public static <T extends Enumerator> EMFEnumSet<T> copyOf(Collection<T> c) {
        if (c instanceof EMFEnumSet) {
            return ((EMFEnumSet)c).clone();
        }
        if (c.isEmpty()) {
            throw new IllegalArgumentException("Collection is empty and not an EMFEnumSet. Cannot determine type.");
        }
        Iterator<T> itr = c.iterator();
        EMFEnumSet<Enumerator> es = EMFEnumSet.of((Enumerator)itr.next());
        while (itr.hasNext()) {
            es.add((Enumerator)itr.next());
        }
        return es;
    }

    public static <T extends Enumerator> EMFEnumSet<T> copyOf(Collection<T> c, Class<T> type) {
        if (c.isEmpty()) {
            return EMFEnumSet.noneOf(type);
        }
        return EMFEnumSet.copyOf(c);
    }

    public static <T extends Enumerator> EMFEnumSet<T> complimentOf(EMFEnumSet<T> c) {
        Object r = c.clone();
        ((EMFEnumSet)r).bitmap = (((EMFEnumSet)r).bitmap ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> -(c.max - c.min + 1);
        return r;
    }

    public static <T extends Enumerator> long getBitmap(Collection<T> c) {
        if (c instanceof EMFEnumSet) {
            EMFEnumSet es = (EMFEnumSet)c;
            return es.getBitmap();
        }
        if (c.isEmpty()) {
            return 0L;
        }
        try {
            return EMFEnumSet.copyOf(c).getBitmap();
        }
        catch (ClassCastException classCastException) {
            return 0L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0L;
        }
    }

    private EMFEnumSet(Class<E> cls) {
        this(0L, cls);
    }

    public EMFEnumSet<E> clone() {
        try {
            return (EMFEnumSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private EMFEnumSet(long init, Class<E> cls) {
        this.bitmap = init;
        this.cls = cls;
        try {
            if (!AbstractEnumerator.class.isAssignableFrom(cls)) {
                throw new ClassCastException(cls + " is not an AbstractEnumerator.");
            }
            Field vf = cls.getField("VALUES");
            List values = (List)vf.get(null);
            int mmin = 0;
            int mmax = 0;
            for (Enumerator e : values) {
                int v = e.getValue();
                mmin = Math.min(mmin, v);
                mmax = Math.max(mmax, v);
            }
            if (mmax - mmin >= 64) {
                mmax = mmin + 63;
            }
            this.min = mmin;
            this.max = mmax;
            this.bitmap &= -1L >>> -(this.max - this.min + 1);
            this.getValue = cls.getMethod("get", Integer.TYPE);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Class " + cls + " is not valid for EMFNumSet", e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Class " + cls + " is not valid for EMFNumSet", e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Class " + cls + " is not valid for EMFNumSet", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Class " + cls + " is not valid for EMFNumSet", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + cls + " is not valid for EMFNumSet", e);
        }
    }

    public long getBitmap() {
        return this.bitmap;
    }

    public void setBitmap(long bitmap) {
        this.bitmap = bitmap & -1L >>> -(this.max - this.min + 1);
    }

    @Override
    public boolean add(E o) {
        int v = o.getValue();
        if (v < this.min || v > this.max) {
            return false;
        }
        long old = this.bitmap;
        this.bitmap |= 1L << v - this.min;
        return this.bitmap != old;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (!(c instanceof EMFEnumSet)) {
            return super.addAll(c);
        }
        EMFEnumSet es = (EMFEnumSet)c;
        if (es.cls != this.cls) {
            return false;
        }
        long old = this.bitmap;
        this.bitmap |= es.getBitmap();
        return this.bitmap != old;
    }

    @Override
    public void clear() {
        this.bitmap = 0L;
    }

    @Override
    public boolean contains(Object o) {
        if (o != null && this.cls == o.getClass()) {
            int v = ((Enumerator)o).getValue();
            return v <= this.max && (this.bitmap & 1L << v - this.min) != 0L;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (!(c instanceof EMFEnumSet)) {
            return super.containsAll(c);
        }
        EMFEnumSet es = (EMFEnumSet)c;
        if (es.cls != this.cls) {
            return super.containsAll(c);
        }
        return (this.bitmap & es.bitmap) == es.bitmap;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EMFEnumSet)) {
            return super.equals(o);
        }
        EMFEnumSet es = (EMFEnumSet)o;
        if (es.cls != this.cls) {
            return super.equals(o);
        }
        return this.bitmap == es.bitmap;
    }

    @Override
    public boolean isEmpty() {
        return this.bitmap == 0L;
    }

    @Override
    public Iterator<E> iterator() {
        return new EMFEnumIterator();
    }

    @Override
    public int size() {
        return Long.bitCount(this.bitmap);
    }

    @Override
    public boolean remove(Object o) {
        if (o != null && this.cls == o.getClass()) {
            int v = ((Enumerator)o).getValue();
            if (v < this.min || v > this.max) {
                return false;
            }
            long old = this.bitmap;
            this.bitmap &= 1L << v - this.min ^ 0xFFFFFFFFFFFFFFFFL;
            return this.bitmap != old;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (!(c instanceof EMFEnumSet)) {
            return super.removeAll(c);
        }
        EMFEnumSet es = (EMFEnumSet)c;
        if (es.cls != this.cls) {
            return false;
        }
        long old = this.bitmap;
        this.bitmap &= es.getBitmap() ^ 0xFFFFFFFFFFFFFFFFL;
        return this.bitmap != old;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (!(c instanceof EMFEnumSet)) {
            return super.retainAll(c);
        }
        EMFEnumSet es = (EMFEnumSet)c;
        if (es.cls != this.cls) {
            if (this.bitmap != 0L) {
                this.bitmap = 0L;
                return true;
            }
            return false;
        }
        long old = this.bitmap;
        this.bitmap &= es.getBitmap();
        return this.bitmap != old;
    }

    private class EMFEnumIterator
    implements Iterator<E> {
        private int nextV = -1;
        private int maxbit;
        private boolean gotNext;

        private void gotoNext() {
            if (this.nextV != -2) {
                while (++this.nextV <= this.maxbit) {
                    if ((EMFEnumSet.this.bitmap & 1L << this.nextV) == 0L) continue;
                    return;
                }
                this.nextV = -2;
            }
        }

        public EMFEnumIterator() {
            this.maxbit = EMFEnumSet.this.max - EMFEnumSet.this.min;
            this.gotNext = false;
            this.gotoNext();
        }

        @Override
        public boolean hasNext() {
            if (this.gotNext) {
                this.gotoNext();
            }
            this.gotNext = false;
            return this.nextV != -2;
        }

        @Override
        public E next() {
            if (this.nextV != -2) {
                this.gotNext = true;
                try {
                    return (Enumerator)EMFEnumSet.this.getValue.invoke(null, this.nextV + EMFEnumSet.this.min);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
                return null;
            }
            return null;
        }

        @Override
        public void remove() {
            if (this.gotNext) {
                EMFEnumSet eMFEnumSet = EMFEnumSet.this;
                eMFEnumSet.bitmap = eMFEnumSet.bitmap & (1L << this.nextV ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
    }
}

