/*
 * Decompiled with CFR 0.152.
 */
package org.oslc.asset.internal.query.ast;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.oslc.asset.internal.query.ast.Node;
import org.oslc.asset.internal.query.ast.OperatorKind;

public abstract class Term
extends Node {
    private String propertyName;
    private List<String> values = new ArrayList<String>(1);
    private OperatorKind kind;
    private Datatype datatype = null;

    protected Term(String name, OperatorKind kind, String value) {
        this.propertyName = name;
        this.kind = kind;
        this.addValue(value);
    }

    protected Term(String name, OperatorKind kind) {
        this.propertyName = name;
        this.kind = kind;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public List<String> getPropertyNameList() {
        ArrayList<String> response = new ArrayList<String>();
        if (this.propertyName != null) {
            String[] parts = this.propertyName.split("/");
            int i = 0;
            while (i < parts.length) {
                response.add(parts[i]);
                ++i;
            }
        }
        return response;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getValue() {
        if (this.datatype == null) {
            return this.values.get(0);
        }
        return String.format("%s^^xsd:%s", this.values.get(0), this.datatype.toString());
    }

    public List<String> getValues() {
        return this.values;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public void setValue(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            this.values.set(0, value);
        } else {
            this.values.set(0, String.format("\"%s\"", value));
        }
    }

    public void setValue(Integer value) {
        this.setDatatype(null);
        this.setValue(value.toString());
    }

    public void setValue(Boolean value) {
        this.setDatatype(null);
        this.setValue(value.toString());
    }

    public void setValue(URI value) {
        this.setDatatype(null);
        this.setValue(String.format("<%s>", value.toString()));
    }

    public OperatorKind getOperatorKind() {
        return this.kind;
    }

    public String getOperator() {
        switch (this.kind) {
            case Equal: {
                return "=";
            }
            case NotEqual: {
                return "!=";
            }
            case LessThan: {
                return "<";
            }
            case LessThanOrEqual: {
                return "<=";
            }
            case GreaterThan: {
                return ">";
            }
            case GreaterThanOrEqual: {
                return ">=";
            }
            case In: {
                return "in";
            }
        }
        return null;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public void setDatatype(Datatype datatype) {
        this.datatype = datatype;
    }

    public String toString() {
        return String.format("%s %s %s", this.propertyName, this.getOperator(), this.getValue());
    }

    public static enum Datatype {
        dateTime;

    }
}

