/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMPost;
import com.ibm.ram.client.RAMTopic;
import com.ibm.ram.common.data.Attachment;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.AbstractRAMClient;
import com.ibm.ram.internal.client.RAMServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;

public class RAMAttachment
extends Attachment {
    private RAMTopic fTopic;
    private RAMPost fPost;
    private Attachment fAttachment;

    RAMAttachment(RAMTopic topic, Attachment attachment) throws RAMRuntimeException {
        this.fTopic = topic;
        this.fAttachment = attachment;
    }

    RAMAttachment(RAMTopic topic) throws RAMRuntimeException {
        this.fTopic = topic;
        this.fAttachment = new Attachment();
        this.fAttachment.setTopicID(topic.getId());
    }

    RAMAttachment(RAMPost post, Attachment attachment) throws RAMRuntimeException {
        this.fPost = post;
        this.fAttachment = attachment;
    }

    RAMAttachment(RAMPost post) throws RAMRuntimeException {
        this.fPost = post;
        this.fAttachment = new Attachment();
        this.fAttachment.setPostID(post.getId());
    }

    @Override
    public String getDescription() {
        return this.fAttachment.getDescription();
    }

    @Override
    public long getId() {
        return this.fAttachment.getId();
    }

    @Override
    public String getName() {
        return this.fAttachment.getName();
    }

    @Override
    public long getPostID() {
        return this.fAttachment.getPostID();
    }

    @Override
    public int getTopicID() {
        return this.fAttachment.getTopicID();
    }

    public RAMPost getPost() {
        return this.fPost;
    }

    public RAMTopic getTopic() {
        return this.fTopic;
    }

    public InputStream downloadContents() {
        InputStream input = null;
        RAMAsset asset = null;
        if (this.fTopic != null) {
            asset = this.fTopic.getAsset();
        }
        if (this.fPost != null) {
            asset = this.fPost.getAsset();
        }
        if (asset != null) {
            AbstractRAMClient client = asset.getSession().getRAMClient();
            URL attachmentURL = null;
            try {
                String serverPath = String.valueOf(client.getWebServicesPath()) + "/RAMSecure";
                serverPath = String.valueOf(serverPath) + "/attachment/" + this.fAttachment.getId();
                attachmentURL = new URL(serverPath);
                input = client.getInputStream(attachmentURL);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (RAMServiceException e) {
                e.printStackTrace();
            }
        }
        return input;
    }
}

