/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.defaultprofile.util;

import com.ibm.ram.common.emf.Attribute;
import com.ibm.ram.common.emf.Attribute751Grouping;
import com.ibm.ram.common.emf.AttributeConstraint;
import com.ibm.ram.common.emf.AttributeGrouping;
import com.ibm.ram.common.emf.ConstraintGrouping;
import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.common.util.RAMURIConverter;
import com.ibm.ram.common.util.RAMURLDecoder;
import com.ibm.ram.common.util.RAMURLEncoder;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.defaultprofile.Asset;
import com.ibm.ram.defaultprofile.Classification;
import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.DescriptorGroup;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.Checksum;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.xml.sax.InputSource;

public class Utilities {
    private static final Logger LOGGER = Logger.getLogger(Utilities.class);
    public static final int STATE_DELETED_ID = 102;
    public static String LEGACY_WFID = JAXBLinksUtil.LEGACY_WORKFLOW_ID;
    public static final int ASSET_STATE_DRAFT = 1;
    public static final String STATE_DRAFT = "Draft";
    public static final String STATE_DRAFT_LEGACY_ID = String.valueOf(LEGACY_WFID) + '/' + "Draft";
    public static final int ASSET_STATE_PLANREVIEW = 2;
    public static final String STATE_PLAN_REVIEW = "Plan review";
    public static final String STATE_PLAN_REVIEW_LEGACY_ID = String.valueOf(LEGACY_WFID) + '/' + "Plan_review";
    public static final int ASSET_STATE_REVIEW = 3;
    public static final String STATE_REVIEW = "Review";
    public static final String STATE_REVIEW_LEGACY_ID = String.valueOf(LEGACY_WFID) + '/' + "Review";
    public static final int ASSET_STATE_EVALUATEREVIEW = 4;
    public static final String STATE_EVALUATE_REVIEW = "Evaluate review";
    public static final String STATE_EVALUATE_REVIEW_LEGACY_ID = String.valueOf(LEGACY_WFID) + '/' + "Evaluate_review";
    public static final int ASSET_STATE_APPROVED = 5;
    public static final String STATE_APPROVED = "Approved";
    public static final String STATE_APPROVED_LEGACY_ID = String.valueOf(LEGACY_WFID) + '/' + "Approved";
    public static final int ASSET_STATE_RETIRED = 6;
    public static final String STATE_RETIRED = "Retired";
    public static final String STATE_RETIRED_LEGACY_ID = String.valueOf(LEGACY_WFID) + '/' + "Retired";
    public static final int ASSET_STATE_ASIS = 7;
    public static final String STATE_ASIS = "As is";
    public static final String STATE_ASIS_LEGACY_ID = String.valueOf(LEGACY_WFID) + '/' + "As_is";
    public static final int ASSET_STATE_ARCHIVED = 8;
    public static final String STATE_ARCHIVED = "Archived";
    public static final String STATE_ARCHIVED_LEGACY_ID = String.valueOf(LEGACY_WFID) + '/' + "Archived";
    public static final int LIBRARY_STATE_LOADED = 9;
    public static final String STATE_LOADED = "Loaded";
    public static final String STATE_LOADED_LEGACY_ID = String.valueOf(LEGACY_WFID) + '/' + "Loaded";
    public static final int LIBRARY_STATE_UNLOADED = 10;
    public static final String STATE_UNLOADED = "Unloaded";
    public static final String STATE_UNLOADED_LEGACY_ID = String.valueOf(LEGACY_WFID) + '/' + "Unloaded";
    public static final int ASSET_STATE_PREDEFINED = 10;
    public static final String TAGS_DESCRIPTORGROUP_NAME = "Tags";
    public static final String PARM_SCHEMA_URI = "suri";
    public static final String PARM_GROUP_ID = "gid";
    public static final String PARM_ROLE_ID = "rid";
    public static final String PARM_USER_ID = "uid";
    public static final String PARM_USER_DBID = "userDBID";
    public static final String PARM_USER_GROUP_ID = "ugid";
    public static final String PARM_REVIEW_PROCESS_ID = "rpid";
    public static final String PARM_EXTENSION_ID = "extid";
    public static final String PARM_ASSET_GUID = "guid";
    public static final String PARM_LIBRARY_ID = "lid";
    public static final String PARM_TOPIC_ID = "tid";
    public static final String PARM_FORUM_ID = "fid";
    public static final String PARM_PAGE_ID = "pid";
    public static final String PARM_WIDGET_ID = "wid";
    public static final String PARM_DEFECT_TRACKING_REPO_ID = "dtid";
    public static final String PARM_DEFECT_QUERY_CONFIGURATION_ID = "qid";
    public static final String PARM_PROBLEMS_CONFIGURATION_ID = "pcid";
    public static final String PARM_POST_ID = "post";
    public static final String PARM_ASSET_TYPE_ID = "atid";
    public static final String PARM_TIME = "t";
    public static final String PARM_VERSION = "v";
    public static final String PARM_SUBMISSION = "submission";
    public static final String PARM_SUBMISSION_TRUE = "true";
    public static final String PARM_SEARCH_NODE = "n";
    public static final String PARM_SORT_DIRECTION = "d";
    public static final String PARM_SORT = "s";
    public static final String PARM_START_DATE = "sdt";
    public static final String PARM_END_DATE = "edt";
    public static final String PARM_LIST = "lst";
    public static final String PARM_TAB = "tab";
    public static final String PARM_ACTION = "action";
    public static final String PARM_LICENSE_FEATURE = "licfeature";
    public static final String ASSET_RELATIONSHIP_DEPENDS_ON_NAME = "dependency";
    public static final String ASSET_RELATIONSHIP_DEPENDED_BY_NAME = "dependent";
    public static final String ASSET_RELATIONSHIP_CONTAINS_NAME = "aggregation";
    public static final String ASSET_RELATIONSHIP_CONTAINER_NAME = "parent";
    public static final String ASSET_RELATIONSHIP_NEW_VERSION_NAME = "nextversion";
    public static final String ASSET_RELATIONSHIP_PREVIOUS_VERSION_NAME = "previousversion";
    public static final String ASSET_TYPE_SCHEMAS_PREFIX = "assetTypesSchema";
    public static final String ASSET_TYPE_CONTAINER_PATH_PREFIX = "classif/assetTypesSchema";
    public static final String ASSET_TYPE_SCHEMA_URI = "classif/assetTypesSchema.xmi";
    public static final String ASSET_TYPE_CONTAINER_PATH_PART = "classif/assetTypesSchema/";
    public static final String ASSET_TYPE_CONTAINER_PATH_FILE = "container.xmi";
    public static final int GLOBAL_ASSETTYPE_CONTAINER_DBID = 20;
    public static final String CUSTOM_EXTENSION_ASSET_TYPE_URI = "classif/assetTypesSchema.xmi#comibmramcustomextension";
    public static final int CUSTOM_EXTENSION_ASSET_TYPE_ID = 21;
    public static final String LIBRARY_ASSET_TYPE_URI = "classif/assetTypesSchema.xmi#comibmramlibrary";
    public static final int LIBRARY_ASSET_TYPE_ID = 22;
    public static final String CUSTOM_MAIL_ASSET_TYPE_URI = "classif/assetTypesSchema.xmi#comibmramcustomemail";
    public static final int CUSTOM_MAIL_ASSET_TYPE_ID = 23;
    public static final String OWNERS_ATTRIBUTE_URI = "classif/assetTypesSchema.xmi#com.ram.owners";
    public static final String COMMUNITY_ATTRIBUTE_URI = "classif/assetTypesSchema.xmi#com.ram.community";
    public static final String TYPE_ATTRIBUTE_URI = "classif/assetTypesSchema.xmi#com.ram.type";
    public static final String GUID_ATTRIBUTE_URI = "classif/assetTypesSchema.xmi#com.ram.guid";
    private static final Set<String> DEFINED_ATTRIBUTES = new HashSet<String>();

    static {
        DEFINED_ATTRIBUTES.add(OWNERS_ATTRIBUTE_URI);
        DEFINED_ATTRIBUTES.add(COMMUNITY_ATTRIBUTE_URI);
        DEFINED_ATTRIBUTES.add(TYPE_ATTRIBUTE_URI);
        DEFINED_ATTRIBUTES.add(GUID_ATTRIBUTE_URI);
    }

    public static boolean isDefinedAttribute(Attribute attribute) {
        return Utilities.isDefinedAttributeURI(attribute.getUriString());
    }

    public static boolean isDefinedAttributeURI(String uri) {
        return DEFINED_ATTRIBUTES.contains(uri);
    }

    private Utilities() {
    }

    public static boolean isReviewState(int stateId) {
        return stateId == 3 || stateId > 10;
    }

    public static boolean isSubmittedState(int stateId) {
        switch (stateId) {
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    public static int indexOfIgnoreCase(String searchIn, String searchForASCII, int startIndex) {
        int lastStart = searchIn.length() - searchForASCII.length();
        if (searchForASCII.length() == 0 || startIndex > lastStart) {
            return -1;
        }
        char[] upperCase = searchForASCII.toUpperCase().toCharArray();
        char[] lowerCase = searchForASCII.toLowerCase().toCharArray();
        int currentChar = startIndex;
        int prevStart = startIndex;
        int currentMatchChar = 0;
        while (true) {
            char charAt;
            if ((charAt = searchIn.charAt(currentChar)) != upperCase[currentMatchChar] && charAt != lowerCase[currentMatchChar]) {
                if ((currentChar = ++prevStart) > lastStart) {
                    return -1;
                }
                currentMatchChar = 0;
                continue;
            }
            if (currentMatchChar == 0) {
                prevStart = currentChar;
            }
            if (++currentMatchChar >= lowerCase.length) {
                return prevStart;
            }
            ++currentChar;
        }
    }

    public static String getAssetTypeURI(Asset asset) {
        Classification cl = asset.getClassification();
        if (cl != null) {
            EList descriptorGroups = cl.getDescriptorGroup();
            for (DescriptorGroup group : descriptorGroups) {
                List nodes;
                if (!"AssetType".equals(group.getName()) || (nodes = ((EcoreEList)group.getNodeDescriptor()).basicList()).isEmpty()) continue;
                return Utilities.getClassificationSchemaURIString(EcoreUtil.getURI((EObject)((EObject)nodes.get(0))), (EObject)asset);
            }
        }
        return null;
    }

    public static String setAssetTypeURI(Asset asset, String uriString) {
        ResourceSet rset;
        Resource res = asset.eResource();
        if (res != null && (rset = res.getResourceSet()) != null) {
            return Utilities.setAssetTypeURI(asset, uriString, rset);
        }
        throw new IllegalArgumentException("Asset not within a resource set connected to a server.");
    }

    public static String setAssetTypeURI(Asset asset, String uriString, ResourceSet rset) {
        Classification cl = asset.getClassification();
        DescriptorGroup assetTypeGroup = null;
        String oldAssetType = null;
        boolean existingAssetTypeDescriptor = false;
        if (cl != null) {
            EList descriptorGroups = cl.getDescriptorGroup();
            Iterator iter = descriptorGroups.iterator();
            while (iter.hasNext()) {
                DescriptorGroup dg = (DescriptorGroup)iter.next();
                if (!"AssetType".equals(dg.getName())) continue;
                List nodes = ((EcoreEList)dg.getNodeDescriptor()).basicList();
                if (!nodes.isEmpty()) {
                    oldAssetType = Utilities.getClassificationSchemaURIString(EcoreUtil.getURI((EObject)((EObject)nodes.get(0))), (EObject)asset);
                    existingAssetTypeDescriptor = true;
                }
                if (uriString == null) {
                    iter.remove();
                    return oldAssetType;
                }
                assetTypeGroup = dg;
                break;
            }
            if (uriString == null || uriString.trim().length() == 0) {
                return oldAssetType;
            }
        } else if (uriString != null) {
            cl = DefaultprofileFactory.eINSTANCE.createClassification();
            asset.setClassification(cl);
        } else {
            return null;
        }
        if (assetTypeGroup == null) {
            assetTypeGroup = DefaultprofileFactory.eINSTANCE.createDescriptorGroup();
            assetTypeGroup.setName("AssetType");
            cl.getDescriptorGroup().add((Object)assetTypeGroup);
        }
        InternalEObject newType = (InternalEObject)DefaultprofileFactory.eINSTANCE.createNodeDescriptor();
        newType.eSetProxyURI(Utilities.createClassificationSchemaURI(uriString, rset));
        if (existingAssetTypeDescriptor) {
            assetTypeGroup.getNodeDescriptor().set(0, (Object)newType);
        } else {
            assetTypeGroup.getNodeDescriptor().add(0, (Object)newType);
        }
        return oldAssetType;
    }

    public static EObject loadClassificationSchemaObjectFromURI(URI uri, EObject fromObject) {
        Resource res = fromObject.eResource();
        if (res != null && res.getResourceSet() != null) {
            try {
                return res.getResourceSet().getEObject(uri, true);
            }
            catch (RuntimeException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Error getting schema object", (Throwable)e);
                }
                return null;
            }
        }
        return null;
    }

    public static String createClassificationSchemaURIString(String uriString, ResourceSet rset) {
        URIConverter uriconv;
        if (uriString != null && rset != null && (uriconv = rset.getURIConverter()) instanceof RAMURIConverter) {
            return ((RAMURIConverter)uriconv).createClassificationSchemaURIString(uriString);
        }
        return uriString;
    }

    public static URI createClassificationSchemaURI(String uriString, EObject fromObject) {
        URI uri;
        ResourceSet rset;
        Resource res = fromObject.eResource();
        if (res != null && (rset = res.getResourceSet()) != null) {
            uriString = Utilities.createClassificationSchemaURIString(uriString, rset);
        }
        if ((uri = URI.createURI((String)uriString)).isRelative()) {
            throw new IllegalArgumentException("Could not convert to an absolute uri=\"" + uriString + '\"');
        }
        return uri;
    }

    public static URI createClassificationSchemaURI(String uriString, ResourceSet rset) {
        if ((uriString = Utilities.createClassificationSchemaURIString(uriString, rset)) != null) {
            URI uri = URI.createURI((String)uriString);
            if (uri.isRelative()) {
                throw new IllegalArgumentException("Could not convert to an absolute uri=\"" + uriString + '\"');
            }
            return uri;
        }
        return null;
    }

    public static String getClassificationSchemaURIString(URI uri, EObject fromObject) {
        Resource res = fromObject.eResource();
        if (res != null) {
            return Utilities.getClassificationSchemaURIString(uri, res.getResourceSet());
        }
        return uri.toString();
    }

    public static String getClassificationSchemaURIString(URI uri, ResourceSet rset) {
        URIConverter uriconv;
        if (uri != null && rset != null && (uriconv = rset.getURIConverter()) instanceof RAMURIConverter) {
            return ((RAMURIConverter)uriconv).getClassificationSchemaURIString(uri);
        }
        return uri != null ? uri.toString() : null;
    }

    public static String getClassificationSchemaURIString(String uriString, EObject fromObject) {
        Resource res = fromObject.eResource();
        if (res != null) {
            return Utilities.getClassificationSchemaURIString(uriString, res.getResourceSet());
        }
        return uriString;
    }

    public static String getClassificationSchemaURIString(String uriString, ResourceSet rset) {
        URIConverter uriconv;
        if (uriString != null && rset != null && (uriconv = rset.getURIConverter()) instanceof RAMURIConverter) {
            return Utilities.getClassificationSchemaURIString(uriString, (RAMURIConverter)uriconv);
        }
        return uriString;
    }

    public static String getClassificationSchemaURIString(String uriString, RAMURIConverter uriConverter) {
        return uriConverter.getClassificationSchemaURIString(uriString);
    }

    public static boolean objectsEqual(Object before, Object after) {
        return UtilitiesCommon.objectsEqual(before, after);
    }

    public static boolean isEmptyString(String teststring) {
        return UtilitiesCommon.isEmptyString(teststring);
    }

    public static boolean isEmptyStringTrimmed(String teststring) {
        return UtilitiesCommon.isEmptyStringTrimmed(teststring);
    }

    public static String normalizeString(String incoming) {
        int inLength = incoming.length();
        if (inLength == 0) {
            return incoming;
        }
        int start = -1;
        int startWhite = -1;
        char[] normalized = null;
        int normalNext = 0;
        int whiteSpace = 32;
        int i = 0;
        while (i < inLength) {
            char c = incoming.charAt(i);
            if (Character.isWhitespace(c)) {
                if (startWhite == -1) {
                    startWhite = i;
                }
                if (c == '\u3000') {
                    whiteSpace = c;
                }
            } else {
                if (start == -1) {
                    start = i;
                    startWhite = -1;
                    whiteSpace = 32;
                } else if (startWhite != -1) {
                    if (i > startWhite + 1 && normalized == null) {
                        normalized = new char[inLength - start];
                        normalNext = startWhite - start;
                        incoming.getChars(start, startWhite, normalized, 0);
                    }
                    if (normalized != null) {
                        normalized[normalNext++] = whiteSpace;
                    }
                    startWhite = -1;
                    whiteSpace = 32;
                }
                if (normalized != null) {
                    normalized[normalNext++] = c;
                }
            }
            ++i;
        }
        if (normalized == null) {
            if (start == -1) {
                return "";
            }
            if (startWhite == -1) {
                if (start == 0) {
                    return incoming;
                }
                return incoming.substring(start);
            }
            return incoming.substring(start, startWhite);
        }
        return new String(normalized, 0, normalNext);
    }

    public static String normalizeFilename(String incomingFilename) {
        String retVal = null;
        if (incomingFilename != null) {
            String normalizeFilename = incomingFilename;
            normalizeFilename = normalizeFilename.replace('\\', File.separatorChar);
            normalizeFilename = normalizeFilename.replace('/', File.separatorChar);
            File normalizeFile = new File(normalizeFilename);
            File file = new File(normalizeFile.getName());
            retVal = file.getName();
        }
        return retVal;
    }

    public static boolean eObjectsCollectionsEqual(Collection<? extends EObject> before, Collection<? extends EObject> after) {
        if (before.size() != after.size()) {
            return false;
        }
        if (before.isEmpty()) {
            return true;
        }
        if (before instanceof RandomAccess && after instanceof RandomAccess) {
            List beforeList = (List)before;
            List afterList = (List)after;
            int i = 0;
            int n = beforeList.size();
            while (i < n) {
                if (!EcoreUtil.equals((EObject)((EObject)beforeList.get(i)), (EObject)((EObject)afterList.get(i)))) {
                    return false;
                }
                ++i;
            }
        } else {
            Iterator<? extends EObject> beforeItr = before.iterator();
            Iterator<? extends EObject> afterItr = after.iterator();
            while (beforeItr.hasNext()) {
                if (EcoreUtil.equals((EObject)beforeItr.next(), (EObject)afterItr.next())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isQueryPartFound(String url) {
        return url.indexOf(63) > -1;
    }

    public static Map<String, String> createQueryMapFromUrl(String url) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (Utilities.isQueryPartFound(url)) {
            String s = url.substring(url.indexOf(63) + 1);
            StringTokenizer st = new StringTokenizer(s, "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.indexOf(61) == -1) continue;
                m.put(token.substring(0, token.indexOf(61)), token.substring(token.indexOf(61) + 1));
            }
        } else {
            String s = RAMURLDecoder.decode(url);
            m.put(PARM_ASSET_GUID, s.split("/")[6]);
            m.put(PARM_VERSION, s.split("/")[7]);
        }
        return m;
    }

    public static void createQueryPart(Map<String, ? extends Object> queryParms, StringBuilder urlBuffer) {
        if (queryParms.isEmpty()) {
            return;
        }
        boolean first = true;
        for (Map.Entry<String, ? extends Object> entry : queryParms.entrySet()) {
            Utilities.appendQueryParm(entry.getKey(), entry.getValue(), first, urlBuffer);
            first = false;
        }
    }

    public static void appendQueryParm(String parmId, long longParmValue, boolean firstParm, StringBuilder urlBuffer) {
        Utilities.appendQueryParm(parmId, String.valueOf(longParmValue), firstParm, urlBuffer);
    }

    public static void appendQueryParm(String parmId, Object parmValue, boolean firstParm, StringBuilder urlBuffer) {
        if (firstParm) {
            urlBuffer.append('?');
        } else {
            urlBuffer.append('&');
        }
        urlBuffer.append(parmId);
        urlBuffer.append("=");
        if (parmValue != null) {
            parmValue = RAMURLEncoder.encode(parmValue.toString());
            urlBuffer.append(parmValue.toString());
        }
    }

    public static void appendQueryParams(StringBuilder buffer, String ... params) {
        if (params.length == 0) {
            return;
        }
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("There must be an even number of params (e.g. name1, value1, name2, value2)");
        }
        Utilities.appendQueryParm(params[0], params[1], true, buffer);
        if (params.length > 2) {
            int i = 2;
            while (i < params.length) {
                Utilities.appendQueryParm(params[i], params[i + 1], false, buffer);
                i += 2;
            }
        }
    }

    public static void copyStreams(InputStream in, OutputStream output, byte[] buffer, boolean closeInput, boolean closeOutput, Checksum checksum) throws IOException {
        UtilitiesCommon.copyStreams(in, output, buffer, closeInput, closeOutput, checksum);
    }

    public static void copyStreams(InputStream in, OutputStream output, byte[] buffer, boolean closeInput, boolean closeOutput) throws IOException {
        UtilitiesCommon.copyStreams(in, output, buffer, closeInput, closeOutput);
    }

    public static void copyReader(Reader in, Writer output, char[] buffer, boolean closeInput, boolean closeOutput) throws IOException {
        UtilitiesCommon.copyReader(in, output, buffer, closeInput, closeOutput);
    }

    public static StringBuilder formAssetTypeContainerURI(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder(100);
        }
        sb.append(ASSET_TYPE_SCHEMA_URI);
        return sb;
    }

    public static StringBuilder formAssetTypeURI(String assetTypeID, StringBuilder sb) {
        sb = Utilities.formAssetTypeContainerURI(sb);
        sb.append('#');
        sb.append(assetTypeID);
        return sb;
    }

    public static StringBuilder formGlobalAttributeContainerURI(StringBuilder sb) {
        return Utilities.formAssetTypeContainerURI(sb);
    }

    public static StringBuilder formGlobalAttributeURI(String attributeID, StringBuilder sb) {
        return Utilities.formAssetTypeURI(attributeID, sb);
    }

    public static StringBuilder formScopedAttributeContainerURI(String assetTypeID, StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder(100);
        }
        sb.append(ASSET_TYPE_CONTAINER_PATH_PART);
        sb.append('/');
        sb.append(assetTypeID);
        sb.append('/');
        sb.append(ASSET_TYPE_CONTAINER_PATH_FILE);
        return sb;
    }

    public static StringBuilder formScopedAttributeURI(String attributeID, String assetTypeID, StringBuilder sb) {
        sb = Utilities.formScopedAttributeContainerURI(assetTypeID, sb);
        sb.append('#');
        sb.append(attributeID);
        return sb;
    }

    public static StringBuilder formScopedAttributeContainerURI(String assetTypeID, int communityID, StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder(100);
        }
        sb.append(ASSET_TYPE_CONTAINER_PATH_PART);
        sb.append('/');
        sb.append(assetTypeID);
        sb.append('/');
        sb.append(communityID);
        sb.append('/');
        sb.append(ASSET_TYPE_CONTAINER_PATH_FILE);
        return sb;
    }

    public static StringBuilder formScopedAttributeURI(String attributeID, String assetTypeID, int communityID, StringBuilder sb) {
        sb = Utilities.formScopedAttributeContainerURI(assetTypeID, communityID, sb);
        sb.append('#');
        sb.append(attributeID);
        return sb;
    }

    public static InputSource createEMFInputSource(XMLResource resource, Reader reader) {
        InputSource is = new InputSource(reader);
        if (resource.getURI() != null) {
            String resourceURI = resource.getURI().toString();
            is.setPublicId(resourceURI);
            is.setSystemId(resourceURI);
            is.setEncoding(resource.getEncoding());
        }
        return is;
    }

    public static <C extends ManifestAccessor.CustomAttribute> List<C> orderAttributes(List<? extends ConstraintGrouping> constraintGroupings, Collection<C> unorderedAttributes, ResourceSet rSet) {
        ArrayList<ManifestAccessor.CustomAttribute> orderedList = new ArrayList<ManifestAccessor.CustomAttribute>();
        for (ConstraintGrouping constraintGrouping : constraintGroupings) {
            String uri;
            if (constraintGrouping instanceof Attribute751Grouping) {
                for (AttributeConstraint ac : ((Attribute751Grouping)constraintGrouping).getConstraintsIterator(false)) {
                    uri = Utilities.createClassificationSchemaURI(ac.getAttributeName(), rSet).toString();
                    for (ManifestAccessor.CustomAttribute ca : unorderedAttributes) {
                        if (!uri.equals(ca.getURIString())) continue;
                        orderedList.add(ca);
                    }
                }
                continue;
            }
            if (!(constraintGrouping instanceof AttributeGrouping)) continue;
            for (AttributeConstraint ac : ((AttributeGrouping)constraintGrouping).getConstraints()) {
                uri = Utilities.createClassificationSchemaURI(ac.getAttributeName(), rSet).toString();
                for (ManifestAccessor.CustomAttribute ca : unorderedAttributes) {
                    if (!uri.equals(ca.getURIString())) continue;
                    orderedList.add(ca);
                }
            }
        }
        for (ManifestAccessor.CustomAttribute customAttribute : unorderedAttributes) {
            boolean added = false;
            for (ManifestAccessor.CustomAttribute oca : orderedList) {
                if (!customAttribute.getURIString().equals(oca.getURIString())) continue;
                added = true;
                break;
            }
            if (added) continue;
            orderedList.add(customAttribute);
        }
        return orderedList;
    }

    public static String encoded(String id) {
        return Utilities.encoded(id, true);
    }

    public static String encoded(String id, boolean lowercase) {
        return Utilities.encodePath(id, lowercase, null, null);
    }

    public static String encodePath(String id, boolean lowercase, String segmentDefault, String lastSegmentDefault) {
        boolean pathEncoding;
        if (id != null) {
            id = id.trim();
        }
        boolean bl = pathEncoding = segmentDefault != null;
        if (!pathEncoding && lastSegmentDefault == null && UtilitiesCommon.isEmptyString(id)) {
            return "";
        }
        int encodeSegNdx = -1;
        int inSegmentNdx = -1;
        int idlen = id.length();
        String emptySegment = null;
        StringBuilder sb = null;
        boolean trimLeadingUnderscores = true;
        int consequetiveUnderscoreCount = 0;
        int i = 0;
        while (i < idlen) {
            char c = id.charAt(i);
            switch (c) {
                case ' ': {
                    consequetiveUnderscoreCount = 0;
                    sb = Utilities.getSB(sb, id, i).append('_');
                    break;
                }
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    consequetiveUnderscoreCount = 0;
                    trimLeadingUnderscores = false;
                    if (sb == null) break;
                    sb.append(c);
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    consequetiveUnderscoreCount = 0;
                    trimLeadingUnderscores = false;
                    if (lowercase) {
                        sb = Utilities.getSB(sb, id, i).append(Character.toLowerCase(c));
                        break;
                    }
                    if (sb == null) break;
                    sb.append(c);
                    break;
                }
                case '/': {
                    trimLeadingUnderscores = false;
                    if (pathEncoding) {
                        if (i - inSegmentNdx > 1 && Utilities.getEncodeLength(sb, i) - encodeSegNdx <= 1) {
                            emptySegment = Utilities.getSegmentDefault(emptySegment, segmentDefault, "path", lowercase);
                            sb = Utilities.getSB(sb, id, i).append(emptySegment);
                        }
                        encodeSegNdx = Utilities.getEncodeLength(sb, i);
                        inSegmentNdx = i;
                        if (sb == null) break;
                        sb.append('/');
                        break;
                    }
                    sb = Utilities.getSB(sb, id, i);
                    break;
                }
                case '_': {
                    if (++consequetiveUnderscoreCount > 2) {
                        sb = Utilities.getSB(sb, id, i);
                        break;
                    }
                    if (!trimLeadingUnderscores) {
                        if (sb == null) break;
                        sb.append(c);
                        break;
                    }
                    sb = Utilities.getSB(sb, id, i);
                    break;
                }
                default: {
                    consequetiveUnderscoreCount = 0;
                    trimLeadingUnderscores = false;
                    sb = Utilities.getSB(sb, id, i);
                }
            }
            ++i;
        }
        if (lastSegmentDefault != null && (idlen == 0 || id.charAt(idlen - 1) != '/' && Utilities.getEncodeLength(sb, idlen) - encodeSegNdx <= 1)) {
            sb = Utilities.getSB(sb, id, idlen).append(Utilities.getSegmentDefault(null, lastSegmentDefault, "file", lowercase));
        }
        return sb == null ? id : sb.toString();
    }

    private static String getSegmentDefault(String segment, String initialValue, String defaultValue, boolean lowercase) {
        if (segment != null) {
            return segment;
        }
        segment = Utilities.encoded(initialValue, lowercase);
        if (segment.length() == 0) {
            return defaultValue;
        }
        return segment;
    }

    private static StringBuilder getSB(StringBuilder sb, String id, int len) {
        if (sb != null) {
            return sb;
        }
        if (len != id.length()) {
            sb = new StringBuilder(id.length());
            if (len > 0) {
                sb.append(id.substring(0, len));
            }
        } else {
            sb = new StringBuilder(id);
        }
        return sb;
    }

    private static int getEncodeLength(StringBuilder sb, int inNdx) {
        if (sb == null) {
            return inNdx;
        }
        return sb.length();
    }

    public static String makeUniqueID(String id, XMLResource res) {
        if (res.getEObject(id) == null) {
            return id;
        }
        int cnt = 1;
        StringBuilder sb = new StringBuilder(id);
        sb.append('.');
        int baseLen = sb.length();
        sb.append(cnt++);
        String newId = "";
        while (res.getEObject(newId = sb.toString()) != null) {
            sb.setLength(baseLen);
            sb.append(cnt++);
        }
        return newId;
    }

    public static String formStateWorkflowId(String workflowid, String stateIdWithinWorkflow) {
        if (LEGACY_WFID.equals(workflowid)) {
            stateIdWithinWorkflow = stateIdWithinWorkflow.replace(' ', '_');
        }
        return String.valueOf(workflowid) + '/' + stateIdWithinWorkflow;
    }

    public static String getQueryParm(String url, String key) {
        if (url.length() == 0 || key.length() == 0) {
            return null;
        }
        int qstart = url.indexOf(63) + 1;
        int keyndx;
        while ((keyndx = url.indexOf(key, qstart)) != -1) {
            int keyendndx = keyndx + key.length();
            if (keyndx > qstart && url.charAt(keyndx - 1) != '&') {
                qstart = keyendndx;
                continue;
            }
            if (keyendndx < url.length()) {
                if (url.charAt(keyendndx) == '=') {
                    int pend;
                    if ((pend = url.indexOf(38, ++keyendndx)) != -1) {
                        return url.substring(keyendndx, pend);
                    }
                    return url.substring(keyendndx);
                }
                if (url.charAt(keyendndx) == '&') {
                    return "";
                }
            } else {
                return "";
            }
            qstart = keyendndx;
        }
        return null;
    }
}

