/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.jaxb.util;

import java.util.ArrayList;
import java.util.List;

public class SelectivePropertiesParser {
    private static char PROP_DELIM = (char)44;
    private static char NS_DELIM = (char)58;
    private static char WILDCARD = (char)42;
    private static char START_NEST = (char)123;
    private static char END_NEST = (char)125;

    public static List<Property> parseSelectiveProperties(String selectiveProperties) {
        ArrayList<Property> props = new ArrayList<Property>();
        int index = 0;
        int propStartIndex = -1;
        int nameSpaceEnd = -1;
        while (index < selectiveProperties.length()) {
            char ithChar = selectiveProperties.charAt(index);
            if (PROP_DELIM == ithChar) {
                props.add(SelectivePropertiesParser.fillInNewProperty(selectiveProperties, propStartIndex, index, nameSpaceEnd));
                propStartIndex = -1;
                nameSpaceEnd = -1;
                ++index;
                continue;
            }
            if (START_NEST == ithChar) {
                NestedResource res = new NestedResource(SelectivePropertiesParser.fillInNewProperty(selectiveProperties, propStartIndex, index, nameSpaceEnd));
                propStartIndex = -1;
                nameSpaceEnd = -1;
                ++index;
                props.add(res);
                index = SelectivePropertiesParser.handleNestedProperties(selectiveProperties, res.getProperies(), index);
                if (selectiveProperties.length() <= index + 1 || selectiveProperties.charAt(index) != PROP_DELIM) continue;
                ++index;
                continue;
            }
            if (NS_DELIM == ithChar) {
                nameSpaceEnd = index++;
                continue;
            }
            if (propStartIndex == -1) {
                propStartIndex = index;
            }
            ++index;
        }
        if (propStartIndex != -1) {
            props.add(SelectivePropertiesParser.fillInNewProperty(selectiveProperties, propStartIndex, index, nameSpaceEnd));
        }
        return props;
    }

    private static int handleNestedProperties(String selectiveProperties, List<Property> props, int curIndex) {
        char jthChar;
        int curPropStartIndex = -1;
        int curNameSpaceEnd = -1;
        while ((jthChar = selectiveProperties.charAt(curIndex)) != END_NEST) {
            if (PROP_DELIM == jthChar) {
                props.add(SelectivePropertiesParser.fillInNewProperty(selectiveProperties, curPropStartIndex, curIndex, curNameSpaceEnd));
                curPropStartIndex = -1;
                curNameSpaceEnd = -1;
                ++curIndex;
                continue;
            }
            if (START_NEST == jthChar) {
                NestedResource res = new NestedResource(SelectivePropertiesParser.fillInNewProperty(selectiveProperties, curPropStartIndex, curIndex, curNameSpaceEnd));
                curPropStartIndex = -1;
                curNameSpaceEnd = -1;
                ++curIndex;
                props.add(res);
                curIndex = SelectivePropertiesParser.handleNestedProperties(selectiveProperties, res.getProperies(), curIndex);
                if (selectiveProperties.length() <= curIndex + 1 || selectiveProperties.charAt(curIndex) != PROP_DELIM) continue;
                ++curIndex;
                continue;
            }
            if (NS_DELIM == jthChar) {
                curNameSpaceEnd = curIndex++;
                continue;
            }
            if (curPropStartIndex == -1) {
                curPropStartIndex = curIndex;
            }
            ++curIndex;
        }
        if (curPropStartIndex != -1) {
            props.add(SelectivePropertiesParser.fillInNewProperty(selectiveProperties, curPropStartIndex, curIndex, curNameSpaceEnd));
        }
        return ++curIndex;
    }

    private static Property fillInNewProperty(String selectiveProperties, int propStartIndex, int propEndIndex, int nameSpaceEnd) {
        Property newProp = new Property();
        if (nameSpaceEnd != -1) {
            newProp.setNamespace(selectiveProperties.substring(propStartIndex, nameSpaceEnd));
            newProp.setName(selectiveProperties.substring(nameSpaceEnd + 1, propEndIndex));
        } else {
            newProp.setName(selectiveProperties.substring(propStartIndex, propEndIndex));
            if (newProp.getName().length() == 1 && newProp.getName().charAt(0) == WILDCARD) {
                return new Wildcard();
            }
        }
        newProp.setIdentifier(selectiveProperties.substring(propStartIndex, propEndIndex));
        return newProp;
    }

    public static void main(String[] args) {
        String test1 = "dc:title,noNamespace,ns2:name1,res3{*},ras:id{version,ns2:prop,ns2:prop1,nons,res2{ns:p1}},res3{*},ns3:name2";
        List<Property> props = SelectivePropertiesParser.parseSelectiveProperties(test1);
        for (Property prop : props) {
            System.out.println("Prop -> " + prop);
        }
    }

    public static class NestedResource
    extends Property {
        List<Property> fProperies;

        public NestedResource() {
        }

        public NestedResource(Property prop) {
            this.setIdentifier(prop.getIdentifier());
            this.setName(prop.getName());
            this.setNamespace(prop.getNamespace());
        }

        public List<Property> getProperies() {
            if (this.fProperies == null) {
                this.fProperies = new ArrayList<Property>();
            }
            return this.fProperies;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer(String.valueOf(this.getIdentifier()) + "{");
            for (Property prop : this.getProperies()) {
                sb.append(prop + " ");
            }
            sb.append("}");
            return sb.toString();
        }
    }

    public static class Property {
        protected String fIdentifier;
        protected String fName;
        protected String fNamespace;

        public String getIdentifier() {
            return this.fIdentifier;
        }

        public void setIdentifier(String identifier) {
            this.fIdentifier = identifier;
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            this.fName = name;
        }

        public String getNamespace() {
            return this.fNamespace;
        }

        public void setNamespace(String namespace) {
            this.fNamespace = namespace;
        }

        public String toString() {
            return String.valueOf(this.getIdentifier()) + "[ns=" + this.getNamespace() + ", name=" + this.getName() + "]";
        }
    }

    public static class Wildcard
    extends Property {
        @Override
        public String getIdentifier() {
            return String.valueOf(WILDCARD);
        }

        @Override
        public String getName() {
            return String.valueOf(WILDCARD);
        }

        @Override
        public String toString() {
            return "Wildcard(*)";
        }
    }
}

