/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.ibm.ram.common.util.AttributeConstants;
import com.ibm.ram.internal.jaxb.AssetID;
import com.ibm.ram.internal.jaxb.AttributeValue;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import com.ibm.ram.internal.json.JsonUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.oslc.asset.internal.Artifact;
import org.oslc.asset.internal.Asset;
import org.oslc.asset.internal.Relation;
import org.oslc.asset.internal.ResourceRef;
import org.oslc.asset.internal.Tag;
import org.oslc.asset.internal.v2.OSLCDecoder;

public class OSLCJsonDecoder {
    public Object decode(InputStream is, String baseUrl, Class clazz) {
        JsonElement raw = JsonUtil.parseJson(is);
        if (Artifact.class == clazz) {
            return this.decodeArtifact(raw, baseUrl);
        }
        if (Asset.class == clazz) {
            return this.decodeAsset(raw, baseUrl);
        }
        return null;
    }

    protected Artifact decodeArtifact(JsonElement json, String baseUrl) throws JsonParseException {
        if (!json.isJsonObject()) {
            return null;
        }
        JsonObject rawArtifact = json.getAsJsonObject();
        Artifact artifact = new Artifact();
        artifact.setBase(baseUrl);
        if (rawArtifact.has("oslc_asset:content")) {
            artifact.setContent(this.getResourceRef(baseUrl, rawArtifact.getAsJsonObject("oslc_asset:content")));
        }
        if (rawArtifact.has("dcterms:title")) {
            artifact.setTitle(rawArtifact.get("dcterms:title").getAsString());
        }
        if (rawArtifact.has("oslc:label")) {
            artifact.setSubject(rawArtifact.get("oslc:label").getAsString());
        }
        if (rawArtifact.has("dcterms:format")) {
            artifact.setMimeType(rawArtifact.get("dcterms:format").getAsString());
        }
        if (rawArtifact.has("oslc_asset:size")) {
            artifact.setSize(rawArtifact.get("oslc_asset:size").getAsLong());
        }
        if (rawArtifact.has("dcterms:modified")) {
            artifact.setModified(OSLCDecoder.decode(rawArtifact.get("dcterms:modified").getAsString()));
        }
        return artifact;
    }

    protected Asset decodeAsset(JsonElement json, String baseUrl) throws JsonParseException {
        JsonObject rawType;
        int i;
        if (!json.isJsonObject()) {
            return null;
        }
        JsonObject rawJson = json.getAsJsonObject();
        rawJson.remove("prefixes");
        Asset asset = new Asset();
        asset.setBase(baseUrl);
        if (rawJson.has("rdf:about")) {
            asset.setAbout(this.getRelativeLocation(baseUrl, rawJson.get("rdf:about").getAsString()));
            rawJson.remove("rdf:about");
        }
        if (rawJson.has("dcterms:title")) {
            asset.setTitle(rawJson.get("dcterms:title").getAsString());
            rawJson.remove("dcterms:title");
        }
        if (rawJson.has("dcterms:description")) {
            asset.setDescription(rawJson.get("dcterms:description").getAsString());
            rawJson.remove("dcterms:description");
        }
        if (rawJson.has("dcterms:abstract")) {
            asset.setSubject(rawJson.get("dcterms:abstract").getAsString());
            rawJson.remove("dcterms:abstract");
        }
        if (rawJson.has("dcterms:contributor")) {
            JsonArray contributors = rawJson.getAsJsonArray("dcterms:contributor");
            i = 0;
            while (i < contributors.size()) {
                asset.getContributors().add(this.getResourceRef(baseUrl, contributors.get(i).getAsJsonObject()));
                ++i;
            }
            rawJson.remove("dcterms:contributor");
        }
        if (rawJson.has("ram_asset:community")) {
            asset.setRAMCommunity(this.getResourceRef(baseUrl, rawJson.getAsJsonObject("ram_asset:community")));
            rawJson.remove("ram_asset:community");
        }
        if (rawJson.has("oslc:instanceShape")) {
            rawType = rawJson.getAsJsonObject("oslc:instanceShape");
            asset.setType(this.getResourceRef(baseUrl, rawType));
        } else if (rawJson.has("dcterms:type")) {
            rawType = rawJson.getAsJsonObject("dcterms:type");
            asset.setType(this.getResourceRef(baseUrl, rawType));
        }
        rawJson.remove("oslc:instanceShape");
        rawJson.remove("dcterms:type");
        if (rawJson.has("ram_asset:revisionCount")) {
            asset.setEtag(rawJson.get("ram_asset:revisionCount").getAsString());
            rawJson.remove("ram_asset:revisionCount");
        }
        if (rawJson.has("dcterms:modified")) {
            asset.setModified(OSLCDecoder.decode(rawJson.get("dcterms:modified").getAsString()));
            rawJson.remove("dcterms:modified");
        }
        if (rawJson.has("oslc_asset:guid") || rawJson.has("oslc_asset:version")) {
            AssetID id = new AssetID();
            if (rawJson.has("oslc_asset:guid")) {
                id.setGUID(rawJson.get("oslc_asset:guid").getAsString());
                rawJson.remove("oslc_asset:guid");
            }
            if (rawJson.has("oslc_asset:version")) {
                id.setVersion(rawJson.get("oslc_asset:version").getAsString());
                rawJson.remove("oslc_asset:version");
            }
            asset.setId(id);
        }
        if (rawJson.has("oslc_asset:state")) {
            asset.setState(this.getResourceRef(baseUrl, rawJson.getAsJsonObject("oslc_asset:state")));
            rawJson.remove("oslc_asset:state");
        }
        if (rawJson.has("oslc_asset:categorization")) {
            JsonArray categorization = rawJson.getAsJsonArray("oslc_asset:categorization");
            i = 0;
            while (i < categorization.size()) {
                asset.getRAMCategories().add(this.getResourceRef(baseUrl, categorization.get(i).getAsJsonObject()));
                ++i;
            }
            rawJson.remove("oslc_asset:categorization");
        }
        if (rawJson.has("oslc_asset:tag")) {
            JsonArray tags = rawJson.getAsJsonArray("oslc_asset:tag");
            i = 0;
            while (i < tags.size()) {
                JsonObject rawTag = tags.get(i).getAsJsonObject();
                asset.getTagsList().add(new Tag(rawTag.get("value").getAsString(), rawTag.get("oslc:readOnly").getAsBoolean()));
                ++i;
            }
            rawJson.remove("ram_asset:tag");
        }
        if (rawJson.has("dcterms:relation")) {
            JsonArray relations = rawJson.getAsJsonArray("dcterms:relation");
            i = 0;
            while (i < relations.size()) {
                JsonObject rawRelation = relations.get(i).getAsJsonObject();
                Relation relation = new Relation();
                relation.setResource(this.getRelativeLocation(baseUrl, rawRelation.get("rdf:resource").getAsString()));
                relation.setType(this.getResourceRef(baseUrl, rawRelation.getAsJsonObject("oslc_asset:relationshipType")));
                asset.getRelationships().add(relation);
                ++i;
            }
            rawJson.remove("dcterms:relation");
        }
        if (rawJson.has("oslc_asset:artifact")) {
            JsonArray artifacts = rawJson.getAsJsonArray("oslc_asset:artifact");
            i = 0;
            while (i < artifacts.size()) {
                asset.getArtifacts().add(this.decodeArtifact(artifacts.get(i), baseUrl));
                ++i;
            }
        }
        Set<Map.Entry<String, JsonElement>> jsonFields = rawJson.entrySet();
        for (Map.Entry<String, JsonElement> field : jsonFields) {
            String[] parts = field.getKey().split(":");
            if (parts.length < 2) continue;
            String nsPrefix = parts[0];
            String attribute = parts[1];
            if ("ram_asset_custom_properties".equals(nsPrefix)) {
                if (!attribute.startsWith("_")) continue;
                String calculatedID = null;
                String attributeID = attribute.substring(1);
                int sep1 = attributeID.indexOf("___");
                int sep2 = sep1 > -1 ? attributeID.indexOf("___", sep1 + 3) : -1;
                boolean communityAssetTypeAttribute = false;
                boolean assetTypeAttribute = false;
                boolean globalAttribute = false;
                if (sep1 > -1 && sep2 > -1) {
                    communityAssetTypeAttribute = true;
                }
                if (!communityAssetTypeAttribute && sep1 > -1) {
                    assetTypeAttribute = true;
                }
                if (!communityAssetTypeAttribute && !assetTypeAttribute) {
                    globalAttribute = true;
                }
                if (communityAssetTypeAttribute) {
                    calculatedID = "classif/assetTypesSchema/" + attributeID.substring(sep1 + 3, sep2) + "/" + attributeID.substring(0, sep1) + "/container.xmi#" + attributeID.substring(sep2 + 3);
                }
                if (assetTypeAttribute) {
                    calculatedID = "classif/assetTypesSchema/" + attributeID.substring(0, sep1) + "/container.xmi#" + attributeID.substring(sep1 + 3);
                }
                if (globalAttribute) {
                    calculatedID = "classif/assetTypesSchema.xmi#" + attributeID;
                }
                if (calculatedID == null) continue;
                AttributeValue av = new AttributeValue();
                av.setAttribute(JAXBLinksUtil.getLink(calculatedID));
                String value = rawJson.get(field.getKey()).getAsString();
                if (value == null || value.contains("http")) {
                    if (value != null) {
                        value = JAXBLinksUtil.getUserIdentifier(value.substring(value.indexOf(JAXBLinksUtil.USERS_PATH)));
                    } else {
                        JsonObject url = rawJson.getAsJsonObject(field.getKey());
                        value = url.get("rdf:resource").getAsString();
                        value = "<a href=\"" + value + "\">" + value + "</a>";
                    }
                    av.getValues().add(value);
                } else {
                    Date date = OSLCDecoder.decode(value);
                    if (date == null) {
                        av.getValues().add(value);
                    } else {
                        av.getValues().add(AttributeConstants.DATE_FORMAT.format(date));
                    }
                }
                asset.getRAMAttributeValues().add(av);
                continue;
            }
            if (!attribute.startsWith("ca.")) continue;
            attribute = attribute.replace("ca.", "");
            JsonObject rawAttribute = rawJson.getAsJsonObject(field.getKey());
            AttributeValue av = new AttributeValue();
            av.setAttribute(JAXBLinksUtil.getLink(attribute));
            av.getValues().add(rawAttribute.get("value").getAsString());
            asset.getRAMAttributeValues().add(av);
        }
        return asset;
    }

    private ResourceRef getResourceRef(String baseUrl, JsonObject object) {
        return JAXBLinksUtil.getResourceRef(this.getRelativeLocation(baseUrl, object.get("rdf:resource").getAsString()), null);
    }

    private String getRelativeLocation(String baseUrl, String fullUrl) {
        return fullUrl.substring(baseUrl.length());
    }
}

