/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm;

import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.Description;
import com.ibm.ram.defaultprofile.Reference;
import com.ibm.ram.defaultprofile.ReferenceKind;
import com.ibm.ram.internal.common.bundles.CommonMessages;
import com.ibm.ram.internal.scm.Utilities;
import com.ibm.ram.scm.SCMException;
import java.io.IOException;
import java.util.Properties;

public abstract class SCMReference {
    private boolean isFolder = true;
    private String artifactFileRelativePath = null;
    protected static final String KEY_IS_FOLDER = "IS_FOLDER";
    public static final String KEY_ARTIFACT_FILE_RELATIVE_PATH = "ARTIFACT_FILE_RELATIVE_PATH";

    public SCMReference(boolean isFolder, String artifactFileRelativePath) {
        this.setIsFolder(isFolder);
        this.setArtifactFileRelativePath(artifactFileRelativePath);
    }

    public Reference createReference() throws SCMException {
        Reference ref = DefaultprofileFactory.eINSTANCE.createReference();
        ref.setReferenceKind(this.getReferenceKind());
        try {
            String serializedCoreProperties = Utilities.serializeProperties(this.getCoreProperties());
            ref.setValue(serializedCoreProperties);
        }
        catch (IOException e) {
            throw new SCMException(CommonMessages.getString("SCMReference_UnableCreateReference"), e);
        }
        try {
            Description description = DefaultprofileFactory.eINSTANCE.createDescription();
            String serializedDescriptiveProperties = Utilities.serializeProperties(this.getDescriptiveProperties());
            description.setValue(serializedDescriptiveProperties);
            ref.setDescription(description);
        }
        catch (IOException e) {
            throw new SCMException(CommonMessages.getString("SCMReference_UnableCreateReference"), e);
        }
        return ref;
    }

    protected abstract ReferenceKind getReferenceKind();

    public Properties getCoreProperties() {
        Properties properties = new Properties();
        properties.put(KEY_IS_FOLDER, Boolean.toString(this.isFolder()));
        properties.put(KEY_ARTIFACT_FILE_RELATIVE_PATH, this.getArtifactFileRelativePath());
        return properties;
    }

    public Properties getDescriptiveProperties() {
        Properties properties = new Properties();
        properties.put(KEY_ARTIFACT_FILE_RELATIVE_PATH, this.getArtifactFileRelativePath());
        return properties;
    }

    public Properties getDisplayProperties() {
        Properties properties = new Properties();
        if (this.getArtifactFileRelativePath() != null) {
            properties.put(CommonMessages.getString("SCMReference_ContainerRelativePath"), this.getArtifactFileRelativePath());
        }
        return properties;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public void setIsFolder(boolean isFolder) {
        this.isFolder = isFolder;
    }

    public String getArtifactFileRelativePath() {
        return this.artifactFileRelativePath;
    }

    public void setArtifactFileRelativePath(String artifactFileRelativePath) {
        this.artifactFileRelativePath = artifactFileRelativePath;
    }
}

