/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.command;

import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.internal.cli.bundles.Messages;
import com.ibm.ram.internal.cli.command.Command;
import com.ibm.ram.internal.cli.command.SearchCommand;
import com.ibm.ram.internal.cli.commandline.CommandLine;
import com.ibm.ram.internal.cli.commandline.Option;
import com.ibm.ram.internal.client.AbstractRAMClient;
import com.ibm.ram.internal.client.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MountCommand
extends Command {
    public static final String NAME = "mount";
    public static final String OPTION_SERVER = "-s";
    public static final String OPTION_DIRECTORY = "-d";
    private String hostName;
    private String mountPoint;

    public MountCommand(String[] args) {
        super(args);
    }

    @Override
    public IStatus execute() {
        Status status = this.getRAMSession();
        if (!status.isOK()) {
            return status;
        }
        AssetIdentification assetId = SearchCommand.getAssetIdentification(this.ramSession, this.packageId, this.packageVersion, this.queryString);
        if (assetId == null) {
            String message = this.packageVersion != null && !this.packageVersion.isEmpty() ? MessageFormat.format(Messages.getString("GetCommand.3"), this.packageId, this.packageVersion) : MessageFormat.format(Messages.getString("GetCommand.9"), this.packageId);
            status = new Status(4, this.getClass().getName(), message);
        }
        String token = null;
        if (status.isOK() && (token = this.getToken()) == null) {
            status = new Status(4, this.getClass().getName(), Messages.getString("MountCommand.3"));
        }
        if (status.isOK()) {
            String errorMessage;
            block11: {
                ArrayList<String> command = new ArrayList<String>();
                command.add(NAME);
                if (this.redHat6orLater()) {
                    command.add("-t");
                    command.add("nfs");
                    command.add("-o");
                    command.add("nfsvers=2");
                }
                command.add(String.valueOf(this.hostName) + ":" + token + "/asset/" + assetId.getGUID() + "/" + assetId.getVersion());
                command.add(this.mountPoint);
                System.out.println(this.getListAsString(command));
                ProcessBuilder mount = new ProcessBuilder(command);
                errorMessage = null;
                try {
                    Process process = mount.start();
                    if (process.waitFor() != 0) {
                        errorMessage = StringUtils.getStreamAsString((InputStream)process.getErrorStream());
                    }
                }
                catch (IOException e) {
                    if (e.getLocalizedMessage() != null) {
                        errorMessage = e.getLocalizedMessage();
                    }
                }
                catch (InterruptedException e) {
                    if (e.getLocalizedMessage() == null) break block11;
                    errorMessage = e.getLocalizedMessage();
                }
            }
            if (errorMessage != null) {
                status = new Status(4, this.getClass().getName(), errorMessage);
            }
        }
        this.ramSession.release();
        return status;
    }

    @Override
    public IStatus validate() {
        CommandLine commandLine = new CommandLine(this.cmdArgs);
        commandLine.addOption(new Option(OPTION_DIRECTORY, true));
        commandLine.addOption(new Option("-config", true));
        commandLine.addOption(new Option(OPTION_SERVER, true));
        commandLine.addOption(new Option("-q", true));
        IStatus status = super.validate(commandLine);
        if (!status.isOK()) {
            return status;
        }
        if (this.packageId == null || this.packageId.isEmpty()) {
            return new Status(4, this.getClass().getName(), Messages.getString("CommandLine.6"));
        }
        this.hostName = commandLine.getOption(OPTION_SERVER).getValue();
        if (this.hostName == null) {
            return new Status(4, this.getClass().getName(), Messages.getString("MountCommand.1"));
        }
        this.mountPoint = commandLine.getOption(OPTION_DIRECTORY).getValue();
        if (this.mountPoint == null) {
            return new Status(4, this.getClass().getName(), Messages.getString("MountCommand.2"));
        }
        this.queryString = commandLine.getOption("-q").getValue();
        this.createConfiguration(commandLine.getOption("-config").getValue());
        return this.config.validate();
    }

    private String getToken() {
        String token = null;
        String urlString = String.valueOf(this.ramSession.getWebServicesURL()) + "/accessToken";
        try {
            URL url = new URL(urlString);
            AbstractRAMClient.Response response = this.ramSession.getURL(url, true, 120000);
            if (200 == response.code) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(response.is));
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
                rd.close();
                int startIndex = sb.toString().indexOf("<token>");
                int endIndex = sb.toString().indexOf("</token>");
                if (startIndex > -1 && endIndex > startIndex) {
                    token = sb.substring(startIndex + 7, endIndex);
                }
            }
            if (response.is != null) {
                response.is.close();
            }
        }
        catch (Exception exception) {}
        return token;
    }

    private boolean redHat6orLater() {
        boolean redHat6orLater;
        block16: {
            boolean isLinux;
            redHat6orLater = false;
            String os = System.getProperty("os.name").toLowerCase();
            boolean bl = isLinux = os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") > 0;
            if (isLinux) {
                BufferedReader br = null;
                try {
                    try {
                        String sCurrentLine;
                        br = new BufferedReader(new FileReader("/etc/redhat-release"));
                        while ((sCurrentLine = br.readLine()) != null) {
                            if (!(sCurrentLine = sCurrentLine.toLowerCase()).contains("red hat") || !sCurrentLine.contains("release")) continue;
                            redHat6orLater = !(sCurrentLine.contains("release 1") || sCurrentLine.contains("release 2") || sCurrentLine.contains("release 3") || sCurrentLine.contains("release 4") || sCurrentLine.contains("release 5"));
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (br != null) {
                                br.close();
                            }
                            break block16;
                        }
                        catch (IOException iOException2) {}
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return redHat6orLater;
    }

    private String getListAsString(List<String> command) {
        StringBuilder sb = new StringBuilder();
        for (String part : command) {
            sb.append(String.valueOf(part) + " ");
        }
        return sb.toString();
    }
}

