/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.commandline;

import com.ibm.ram.internal.cli.bundles.Messages;
import com.ibm.ram.internal.cli.commandline.Option;
import com.ibm.ram.internal.cli.commandline.ParseException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandLine {
    private Map<String, Option> options = new HashMap<String, Option>();
    private List<String> values = new ArrayList<String>();
    private String[] args;
    private static String DASH = "-";

    public CommandLine(String[] args) {
        this.args = args;
    }

    public void addOption(Option anOption) {
        if (anOption != null) {
            this.options.put(anOption.getName(), anOption);
        }
    }

    public void addOptions(Collection<Option> options) {
        if (options != null && !options.isEmpty()) {
            for (Option anOption : options) {
                this.addOption(anOption);
            }
        }
    }

    public Option getOption(String optionName) {
        return this.options.get(optionName);
    }

    public List<Option> getOptions() {
        return new ArrayList<Option>(this.options.values());
    }

    public List<String> getValues() {
        return this.values;
    }

    public void parse() throws ParseException {
        int currentArg = 1;
        int numArgs = this.args.length;
        while (currentArg < numArgs) {
            String anArg = this.args[currentArg];
            if (anArg.startsWith(DASH)) {
                Option theOption = this.options.get(anArg);
                if (theOption != null) {
                    if (theOption.requiresValue()) {
                        if (++currentArg >= numArgs) {
                            String message = MessageFormat.format(Messages.getString("CommandLine.2"), theOption.getName());
                            throw new ParseException(message);
                        }
                        anArg = this.args[currentArg];
                        if (anArg.startsWith(DASH)) {
                            String message = MessageFormat.format(Messages.getString("CommandLine.1"), theOption.getName());
                            throw new ParseException(message);
                        }
                        if (theOption.supportsMultipleValues()) {
                            while (!anArg.startsWith(DASH) && currentArg < numArgs) {
                                theOption.addValue(anArg);
                                if (++currentArg >= numArgs) continue;
                                anArg = this.args[currentArg];
                            }
                            if (anArg.startsWith(DASH)) {
                                --currentArg;
                            }
                        } else {
                            theOption.setValue(anArg);
                        }
                        theOption.set(true);
                    } else {
                        theOption.set(true);
                    }
                } else {
                    int j = 1;
                    while (j < anArg.length()) {
                        String anOption = String.valueOf(DASH) + anArg.charAt(j);
                        theOption = this.options.get(anOption);
                        if (theOption != null) {
                            if (theOption.requiresValue()) {
                                String message = MessageFormat.format(Messages.getString("CommandLine.2"), theOption.getName());
                                throw new ParseException(message);
                            }
                        } else {
                            String message = MessageFormat.format(Messages.getString("CommandLine.3"), anOption);
                            throw new ParseException(message);
                        }
                        theOption.set(true);
                        ++j;
                    }
                }
            } else {
                this.values.add(anArg);
            }
            ++currentArg;
        }
        for (Option anOption : this.options.values()) {
            if (!anOption.isRequired() || anOption.isSet()) continue;
            String message = MessageFormat.format(Messages.getString("CommandLine.4"), anOption.getName());
            throw new ParseException(message);
        }
    }
}

