/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.rampackage;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.ibm.ram.internal.cli.bundles.Messages;
import com.ibm.ram.internal.cli.configuration.BuildEnvironment;
import com.ibm.ram.internal.cli.rampackage.Dependency;
import com.ibm.ram.internal.cli.rampackage.Person;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DescriptorParser {
    public static final String ID = "id";
    public static final String GROUP_ID = "groupId";
    public static final String ARTIFACT_ID = "artifactId";
    public static final String VERSION = "version";
    public static final String DESCRIPTION = "description";
    public static final String KEYWORDS = "keywords";
    public static final String AUTHOR = "author";
    public static final String OWNERS = "owners";
    public static final String CONTRIBUTORS = "contributors";
    public static final String CONTRIBUTOR = "contributor";
    public static final String COMMUNITY = "community";
    public static final String TYPE = "type";
    public static final String DEPENDENCIES = "dependencies";
    public static final String PACKAGES = "packages";
    public static final String QUERY = "query";
    public static final String PROJECT = "project";
    private String id = null;
    private String version = null;
    private String groupId = null;
    private String description = null;
    private List<String> keywords = null;
    private Person author = null;
    private List<Person> owners = null;
    private String community = null;
    private String type = null;
    private List<Dependency> dependencies = null;
    private List<Dependency> packages = null;
    private String descriptorName;
    private JsonObject rawJson = null;
    private Document doc = null;

    public DescriptorParser(String descriptorName) {
        this.descriptorName = descriptorName;
    }

    public IStatus parse() {
        IStatus status;
        if (this.descriptorName.endsWith(".json")) {
            status = this.readJson(this.descriptorName);
        } else if (this.descriptorName.endsWith(".xml") || this.descriptorName.endsWith(".pom")) {
            status = this.readXML(this.descriptorName);
        } else {
            String message = MessageFormat.format(Messages.getString("PackageDescriptor.3"), this.descriptorName);
            status = new Status(4, this.getClass().getName(), message);
        }
        return status;
    }

    private IStatus readJson(String fileName) {
        String message;
        Status status = new Status(0, this.getClass().getName(), null);
        FileReader reader = null;
        JsonElement json = null;
        try {
            reader = new FileReader(fileName);
            JsonParser parser = new JsonParser();
            json = parser.parse((Reader)reader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String message2 = MessageFormat.format(Messages.getString("PackageDescriptor.1"), fileName);
            status = new Status(4, this.getClass().getName(), message2);
        }
        catch (JsonParseException jpe) {
            message = MessageFormat.format(Messages.getString("PackageDescriptor.2"), fileName);
            Throwable t = jpe.getCause();
            if (t != null && t.getLocalizedMessage() != null) {
                message = String.valueOf(message) + "\n" + t.getLocalizedMessage();
            }
            status = new Status(4, this.getClass().getName(), message);
        }
        catch (Exception e) {
            message = MessageFormat.format(Messages.getString("PackageDescriptor.2"), fileName);
            if (e.getLocalizedMessage() != null) {
                message = String.valueOf(message) + "\n" + e.getLocalizedMessage();
            }
            e.printStackTrace();
            status = new Status(4, this.getClass().getName(), message);
        }
        if (reader != null) {
            try {
                ((Reader)reader).close();
            }
            catch (Exception exception) {}
        }
        if (!status.isOK()) {
            return status;
        }
        try {
            if (json != null && json.isJsonObject()) {
                this.rawJson = json.getAsJsonObject();
            }
        }
        catch (Exception e) {
            message = MessageFormat.format(Messages.getString("PackageDescriptor.2"), fileName);
            if (e.getLocalizedMessage() != null) {
                message = String.valueOf(message) + "\n" + e.getLocalizedMessage();
            }
            status = new Status(4, this.getClass().getName(), message);
        }
        return status;
    }

    private IStatus readXML(String fileName) {
        Status status = new Status(0, this.getClass().getName(), null);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.parse(fileName);
            this.doc.getDocumentElement().normalize();
        }
        catch (FileNotFoundException fileNotFoundException) {
            String message = MessageFormat.format(Messages.getString("PackageDescriptor.1"), fileName);
            status = new Status(4, this.getClass().getName(), message);
        }
        catch (Exception e) {
            String message = MessageFormat.format(Messages.getString("PackageDescriptor.2"), fileName);
            if (e.getLocalizedMessage() != null) {
                message = String.valueOf(message) + "\n" + e.getLocalizedMessage();
            }
            status = new Status(4, this.getClass().getName(), message);
        }
        return status;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.rawJson != null ? this.getMemberAsString(this.rawJson, ID) : this.getMemberAsString(this.doc, ARTIFACT_ID);
        }
        return this.id;
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = this.rawJson != null ? DescriptorParser.resolveVersion(this.getMemberAsString(this.rawJson, VERSION)) : DescriptorParser.resolveVersion(this.getMemberAsString(this.doc, VERSION));
        }
        return this.version;
    }

    public String getGroupId() {
        if (this.groupId == null && this.doc != null) {
            this.groupId = this.getMemberAsString(this.doc, GROUP_ID);
        }
        return this.groupId;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.rawJson != null ? this.getMemberAsString(this.rawJson, DESCRIPTION) : this.getMemberAsString(this.doc, DESCRIPTION);
        }
        return this.description;
    }

    public List<String> getKeywords() {
        if (this.keywords == null) {
            this.keywords = this.rawJson != null ? this.getMemberAsStringArray(this.rawJson, KEYWORDS) : new ArrayList<String>();
        }
        return this.keywords;
    }

    public Person getAuthor() {
        if (this.author == null) {
            this.author = this.rawJson != null ? this.getMemberAsPerson(this.rawJson, AUTHOR) : null;
        }
        return this.author;
    }

    public List<Person> getOwners() {
        if (this.owners == null) {
            this.owners = this.rawJson != null ? this.getMemberAsPersonArray(this.rawJson, OWNERS) : this.getContributorsAsPersonArray(this.doc);
        }
        return this.owners;
    }

    public String getCommunity() {
        if (this.community == null) {
            this.community = this.rawJson != null ? this.getMemberAsString(this.rawJson, COMMUNITY) : null;
        }
        return this.community;
    }

    public String getType() {
        if (this.type == null) {
            this.type = this.rawJson != null ? this.getMemberAsString(this.rawJson, TYPE) : null;
        }
        return this.type;
    }

    public List<Dependency> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = this.rawJson != null ? this.getMemberAsDependencyArray(this.rawJson, DEPENDENCIES) : new ArrayList<Dependency>();
        }
        return this.dependencies;
    }

    public List<Dependency> getPackages() {
        if (this.packages == null && this.rawJson != null) {
            this.packages = this.getMemberAsDependencyArray(this.rawJson, PACKAGES);
        }
        return this.packages;
    }

    private String getMemberAsString(JsonObject jsonObject, String memberName) {
        String member = null;
        if (jsonObject.has(memberName)) {
            member = jsonObject.get(memberName).getAsString();
            jsonObject.remove(memberName);
        }
        return member;
    }

    private ArrayList<String> getMemberAsStringArray(JsonObject jsonObject, String memberName) {
        JsonElement jsonElement;
        ArrayList<String> members = new ArrayList<String>();
        if (jsonObject.has(memberName) && (jsonElement = jsonObject.get(memberName)).isJsonArray()) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            for (JsonElement element : jsonArray) {
                if (!element.isJsonPrimitive()) continue;
                members.add(element.getAsString());
            }
        }
        return members;
    }

    private Person getMemberAsPerson(JsonPrimitive jsonPrimitive) {
        String email = null;
        String url = null;
        StringBuffer details = new StringBuffer(jsonPrimitive.getAsString());
        int startDelimiter = details.indexOf("<");
        int endDelimiter = details.indexOf(">");
        if (startDelimiter > -1 && endDelimiter > -1) {
            email = details.substring(startDelimiter + 1, endDelimiter);
            details = details.delete(startDelimiter, endDelimiter + 1);
        }
        startDelimiter = details.indexOf("(");
        endDelimiter = details.indexOf(")");
        if (startDelimiter > -1 && endDelimiter > -1) {
            url = details.substring(startDelimiter + 1, endDelimiter);
            details = details.delete(startDelimiter, endDelimiter + 1);
        }
        String name = details.toString().trim();
        return new Person(name, email, url);
    }

    private Person getMemberAsPerson(JsonObject jsonObject) {
        String name = this.getMemberAsString(jsonObject, "name");
        String email = this.getMemberAsString(jsonObject, "email");
        String url = this.getMemberAsString(jsonObject, "url");
        return new Person(name, email, url);
    }

    private Person getMemberAsPerson(JsonObject jsonObject, String memberName) {
        Person aPerson = null;
        if (jsonObject.has(memberName)) {
            JsonElement jsonElement = jsonObject.get(memberName);
            if (jsonElement.isJsonPrimitive()) {
                aPerson = this.getMemberAsPerson((JsonPrimitive)jsonElement);
            } else if (jsonElement.isJsonObject()) {
                aPerson = this.getMemberAsPerson((JsonObject)jsonElement);
            }
        }
        return aPerson;
    }

    private ArrayList<Person> getMemberAsPersonArray(JsonObject jsonObject, String memberName) {
        JsonElement jsonElement;
        ArrayList<Person> members = new ArrayList<Person>();
        if (jsonObject.has(memberName) && (jsonElement = jsonObject.get(memberName)).isJsonArray()) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            for (JsonElement element : jsonArray) {
                if (element.isJsonPrimitive()) {
                    members.add(this.getMemberAsPerson((JsonPrimitive)element));
                    continue;
                }
                if (!element.isJsonObject()) continue;
                members.add(this.getMemberAsPerson((JsonObject)element));
            }
        }
        return members;
    }

    private List<Dependency> getMemberAsDependencyArray(JsonObject jsonObject, String memberName) {
        JsonElement jsonElement;
        ArrayList<Dependency> members = new ArrayList<Dependency>();
        if (jsonObject.has(memberName) && (jsonElement = jsonObject.get(memberName)).isJsonArray()) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            for (JsonElement element : jsonArray) {
                if (!element.isJsonObject()) continue;
                Dependency aDependency = new Dependency();
                JsonObject o = (JsonObject)element;
                for (Map.Entry entry : o.entrySet()) {
                    String key = ((String)entry.getKey()).trim();
                    String value = ((JsonElement)entry.getValue()).getAsString().trim();
                    if (ID.equalsIgnoreCase(key)) {
                        aDependency.setId(value);
                        continue;
                    }
                    if (VERSION.equalsIgnoreCase(key)) {
                        aDependency.setVersion(DescriptorParser.resolveVersion(value));
                        continue;
                    }
                    if (!QUERY.equalsIgnoreCase(key)) continue;
                    aDependency.setQueryString(value);
                }
                members.add(aDependency);
            }
        }
        return members;
    }

    private String getMemberAsString(Document doc, String tagName) {
        return this.getMemberAsString(doc, tagName, PROJECT);
    }

    private String getMemberAsString(Document doc, String tagName, String parentTagName) {
        String value = null;
        NodeList nodeList = doc.getElementsByTagName(tagName);
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength() && value == null) {
                Element anElement = (Element)nodeList.item(i);
                if (anElement.getParentNode().getNodeName().equalsIgnoreCase(parentTagName)) {
                    value = anElement.getTextContent();
                }
                ++i;
            }
        }
        return value;
    }

    private List<Person> getContributorsAsPersonArray(Document doc) {
        ArrayList<Person> contributors = new ArrayList<Person>();
        NodeList nodeList = doc.getElementsByTagName(CONTRIBUTOR);
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Node aNode = nodeList.item(i);
                if (aNode.getNodeType() == 1) {
                    Element element = (Element)aNode;
                    String contributorName = null;
                    String contributorEmail = null;
                    String contributorURL = null;
                    Node item = element.getElementsByTagName("name").item(0);
                    if (item != null) {
                        contributorName = item.getTextContent();
                    }
                    if ((item = element.getElementsByTagName("email").item(0)) != null) {
                        contributorEmail = item.getTextContent();
                    }
                    if ((item = element.getElementsByTagName("url").item(0)) != null) {
                        contributorURL = item.getTextContent();
                    }
                    contributors.add(new Person(contributorName, contributorEmail, contributorURL));
                }
                ++i;
            }
        }
        return contributors;
    }

    public static String resolveVersion(String aVersion) {
        int snapshotIndex;
        if (aVersion != null && (snapshotIndex = aVersion.toLowerCase().indexOf("snapshot")) > -1) {
            aVersion = String.valueOf(aVersion.substring(0, snapshotIndex)) + BuildEnvironment.getInstance().getSnapshotID();
        }
        return aVersion;
    }
}

