/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.command;

import com.ibm.ram.client.RAMPassword;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.cli.bundles.Messages;
import com.ibm.ram.internal.cli.commandline.CommandLine;
import com.ibm.ram.internal.cli.commandline.ParseException;
import com.ibm.ram.internal.cli.configuration.Configuration;
import com.ibm.ram.internal.client.AbstractRAMClient;
import com.ibm.ram.internal.client.RAMRichSession;
import com.ibm.ram.internal.client.RAMServiceException;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class Command {
    protected String[] cmdArgs;
    public static final String OPTION_CONFIG = "-config";
    public static final String OPTION_QUERY = "-q";
    public static final String ASTERISK = "*";
    protected Configuration config;
    protected String packageId;
    protected String packageVersion;
    protected String queryString;
    protected RAMCommandSession ramSession = null;

    public Command(String[] cmdArgs) {
        this.cmdArgs = cmdArgs;
    }

    public Status getRAMSession(String url, String user, String password) {
        Status status = null;
        if (this.ramSession == null) {
            try {
                this.ramSession = new RAMCommandSession(url, user, new RAMPassword(password), null);
            }
            catch (RAMRuntimeException rAMRuntimeException) {
                String message = MessageFormat.format(Messages.getString("Command.1"), url);
                status = new Status(4, this.getClass().getName(), message);
            }
        }
        if (status == null) {
            status = new Status(0, this.getClass().getName(), null);
        }
        return status;
    }

    public Status getRAMSession() {
        return this.getRAMSession(this.config.getUrl(), this.config.getUser(), this.config.getPassword());
    }

    public void releaseRAMSession() {
        if (this.ramSession != null) {
            this.ramSession.release();
            this.ramSession = null;
        }
    }

    public void createConfiguration(String configurationFileName) {
        this.config = configurationFileName == null ? new Configuration() : new Configuration(configurationFileName);
    }

    public IStatus validate(CommandLine commandLine) {
        try {
            commandLine.parse();
        }
        catch (ParseException pe) {
            return new Status(4, this.getClass().getName(), pe.getMessage());
        }
        List<String> values = commandLine.getValues();
        if (values.size() > 2) {
            String message = MessageFormat.format(Messages.getString("CommandLine.5"), values.get(2));
            return new Status(4, this.getClass().getName(), message);
        }
        this.packageId = null;
        if (!values.isEmpty()) {
            this.packageId = values.get(0).trim();
        }
        this.packageVersion = null;
        if (values.size() > 1) {
            this.packageVersion = values.get(1).trim();
        }
        return new Status(0, this.getClass().getName(), null);
    }

    public abstract IStatus validate();

    public abstract IStatus execute();

    protected static class RAMCommandSession
    extends RAMRichSession {
        public RAMCommandSession(String ramLocation, String userName, RAMPassword password, String onBehalfOfUserId) throws RAMRuntimeException {
            super(ramLocation, userName, password, onBehalfOfUserId);
        }

        protected AbstractRAMClient.Response getURL(URL url, boolean followRedirects, int timeout) throws IOException, RAMServiceException {
            return super.getURL(url, followRedirects, timeout);
        }
    }
}

