/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.commandline;

import java.util.ArrayList;
import java.util.List;

public class Option {
    private String name = null;
    private List<String> values = null;
    private String value = null;
    private boolean requiresValue = false;
    private boolean supportsMultipleValues = false;
    private boolean required = false;
    private boolean set = false;

    public Option(String name) {
        this(name, false, false, false);
    }

    public Option(String name, boolean requiresValue) {
        this(name, requiresValue, false, false);
    }

    public Option(String name, boolean requiresValue, boolean supportsMultipleValues) {
        this(name, requiresValue, supportsMultipleValues, false);
    }

    public Option(String name, boolean requiresValue, boolean supportsMultipleValues, boolean required) {
        this.name = name;
        this.requiresValue = requiresValue;
        this.supportsMultipleValues = supportsMultipleValues;
        this.required = required;
        if (supportsMultipleValues) {
            this.values = new ArrayList<String>();
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSet() {
        return this.set;
    }

    public void set(boolean isSet) {
        this.set = isSet;
    }

    public String getName() {
        return this.name;
    }

    public boolean requiresValue() {
        return this.requiresValue;
    }

    public boolean supportsMultipleValues() {
        return this.supportsMultipleValues;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void addValue(String aValue) {
        this.values.add(aValue);
    }

    public void setValue(String aValue) {
        this.value = aValue;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("name: " + this.name + "\n");
        if (this.values == null) {
            s.append("values:  null\n");
        } else {
            s.append("values:\n");
            for (String aValue : this.values) {
                s.append(" " + aValue);
            }
            if (!this.values.isEmpty()) {
                s.append("\n");
            }
        }
        s.append("requiresValue: " + this.requiresValue + "\n");
        s.append("supportsMultipleValues: " + this.supportsMultipleValues + "\n");
        s.append("required: " + this.required + "\n");
        s.append("set: " + this.set + "\n");
        return s.toString();
    }
}

