/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.configuration;

import com.ibm.ram.internal.cli.bundles.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class Configuration {
    public static final String URL = "url";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String COMMUNITY = "community";
    public static final String RAM_CONFIGURATION_NAME = "ramconfig.properties";
    public static final String RAM_CONFIGURATION_DIRECTORY = String.valueOf(File.separatorChar) + ".ram";
    private String configFileName;
    private Properties properties = new Properties();

    public Configuration() {
        this.configFileName = Configuration.getDefaultFileName(RAM_CONFIGURATION_NAME);
        this.read();
    }

    public Configuration(String configFileName) {
        this.configFileName = configFileName;
        this.read();
    }

    public void read() {
        block14: {
            InputStream is = null;
            try {
                try {
                    File configFile = new File(this.configFileName);
                    if (configFile.isFile() && configFile.exists() && configFile.canRead()) {
                        is = new FileInputStream(configFile);
                    }
                    if (is != null) {
                        this.properties.load(is);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (is == null) break block14;
                    try {
                        is.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public IStatus write() {
        Status status;
        block13: {
            File configFile = new File(this.configFileName);
            OutputStream os = null;
            try {
                try {
                    File parentFile = configFile.getParentFile();
                    if (parentFile != null) {
                        parentFile.mkdirs();
                    }
                    os = new FileOutputStream(configFile);
                    this.properties.store(os, null);
                    String message = MessageFormat.format(Messages.getString("Configuration.2"), configFile.getAbsolutePath());
                    status = new Status(0, this.getClass().getName(), message);
                }
                catch (Exception e) {
                    Status[] allStatus = new Status[2];
                    String message = MessageFormat.format(Messages.getString("Configuration.1"), configFile.getAbsolutePath());
                    allStatus[0] = new Status(4, this.getClass().getName(), message);
                    allStatus[1] = new Status(4, this.getClass().getName(), e.getLocalizedMessage());
                    status = new MultiStatus(this.getClass().getName(), 4, (IStatus[])allStatus, message, e.getCause());
                    if (os == null) break block13;
                    try {
                        os.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return status;
    }

    public Status validate() {
        Status status;
        String message;
        Status errorStatus = null;
        if (this.properties.isEmpty()) {
            errorStatus = new Status(4, this.getClass().getName(), Messages.getString("Configuration.3"));
        } else {
            StringBuffer missingProperty = new StringBuffer();
            if (!this.properties.containsKey(URL)) {
                missingProperty.append(URL);
            }
            if (!this.properties.containsKey(USER)) {
                missingProperty.append(" user");
            }
            if (!this.properties.containsKey(PASSWORD)) {
                missingProperty.append(" password");
            }
            if (missingProperty.length() > 0) {
                message = MessageFormat.format(Messages.getString("Configuration.4"), missingProperty.toString());
                errorStatus = new Status(4, this.getClass().getName(), message);
            }
        }
        if (errorStatus != null) {
            status = new MultiStatus(this.getClass().getName(), 4, null, null);
            message = MessageFormat.format(Messages.getString("Configuration.5"), this.configFileName);
            ((MultiStatus)status).add((IStatus)new Status(0, this.getClass().getName(), message));
            ((MultiStatus)status).add((IStatus)errorStatus);
        } else {
            status = new Status(0, this.getClass().getName(), "");
        }
        return status;
    }

    public String getUrl() {
        return this.properties.getProperty(URL);
    }

    public String getUser() {
        return this.properties.getProperty(USER);
    }

    public String getPassword() {
        return this.properties.getProperty(PASSWORD);
    }

    public String getCommunity() {
        return this.properties.getProperty(COMMUNITY);
    }

    public void setUrl(String url) {
        this.properties.setProperty(URL, url);
    }

    public void setUser(String user) {
        this.properties.setProperty(USER, user);
    }

    public void setPassword(String password) {
        this.properties.setProperty(PASSWORD, password);
    }

    public void setCommunity(String community) {
        this.properties.setProperty(COMMUNITY, community);
    }

    public static String getDefaultFileName(String fileName) {
        return String.valueOf(System.getProperty("user.home")) + RAM_CONFIGURATION_DIRECTORY + File.separator + fileName;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public String toString() {
        return "url=" + this.getUrl() + "\nuser=" + this.getUser() + "\ncommunity=" + this.getCommunity();
    }
}

