/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.tasks;

import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.tasks.RAMTask;
import com.ibm.ram.internal.client.ant.types.Asset;
import com.ibm.ram.internal.client.ant.types.Search;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class DeleteTask
extends RAMTask {
    private List searches = new ArrayList();
    private List assets = new ArrayList();

    public void add(Search search) {
        if (this.getSession() != null) {
            search.setSession(this.getSession());
        }
        search.setTask(this);
        this.searches.add(search);
    }

    public void add(Asset asset) {
        if (this.getSession() != null) {
            asset.setSession(this.getSession());
        }
        asset.setTask(this);
        this.assets.add(asset);
    }

    @Override
    public void execute() throws BuildException {
        try {
            super.execute();
            for (Search search : this.searches) {
                RAMAsset[] assets = search.getAssets();
                int i = 0;
                while (i < assets.length) {
                    assets[i].setAction(RAMAction.DELETE);
                    this.getSession().queueAssetForPut(assets[i]);
                    ++i;
                }
            }
            for (Asset antAsset : this.assets) {
                RAMAsset asset = antAsset.getAsset();
                if (asset == null) {
                    LoggingUtil.error((ProjectComponent)this, "Asset not found: " + antAsset.getName() + " [" + antAsset.getVersion() + "]");
                }
                asset.setAction(RAMAction.DELETE);
                this.getSession().queueAssetForPut(asset);
            }
            try {
                this.getSession().putAssets((IProgressMonitor)new NullProgressMonitor());
            }
            catch (RAMRuntimeException e) {
                LoggingUtil.error((ProjectComponent)this, (Throwable)e);
            }
            catch (IOException e) {
                LoggingUtil.error((ProjectComponent)this, (Throwable)e);
            }
        }
        catch (Exception e) {
            LoggingUtil.error((ProjectComponent)this, (Throwable)e);
        }
    }

    @Override
    public List getChildren() {
        ArrayList children = new ArrayList();
        children.addAll(this.searches);
        children.addAll(this.assets);
        return children;
    }
}

