/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.types;

import com.ibm.ram.client.LocalFileArtifact;
import com.ibm.ram.client.RAMArtifact;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMFolderArtifact;
import com.ibm.ram.client.RAMURLArtifact;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.types.Asset;
import com.ibm.ram.internal.client.ant.types.RAMDataType;
import com.ibm.ram.internal.client.ant.types.Reference;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.ProjectComponent;

public class Artifact
extends RAMDataType {
    private String name;
    private String path;
    private String label;
    private String url;
    private String assetId;
    private File file;
    private Reference reference;
    private RAMAsset asset;
    private com.ibm.ram.common.data.Artifact artifact;

    public void add(Reference reference) {
        if (this.reference != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)reference);
        } else {
            reference.setParent(this);
            this.reference = reference;
        }
    }

    protected void addArtifact(com.ibm.ram.common.data.Artifact artifact, String path) {
        com.ibm.ram.common.data.Artifact childFolder;
        RAMFolderArtifact folder = (RAMFolderArtifact)this.getAsset().getArtifactsRoot();
        if (path != null && path.length() > 0 && (childFolder = folder.getChild(path)) != null && childFolder instanceof RAMFolderArtifact) {
            folder = (RAMFolderArtifact)childFolder;
        }
        folder.addArtifact(this.getArtifact());
        if (this.label != null) {
            this.getArtifact().setLabel(this.label);
        }
    }

    @Override
    public void commitModel() {
        try {
            if (this.reference != null) {
                this.reference.setArtifact(this.getArtifact());
                this.reference.commitModel();
            }
            if (this.getArtifact() != null) {
                RAMFolderArtifact root = (RAMFolderArtifact)this.getAsset().getArtifactsRoot();
                String path = this.getPath();
                if (path != null && path.length() > 0) {
                    root.addArtifact(path, this.getArtifact());
                } else {
                    root.addArtifact(this.getArtifact());
                }
                if (this.label != null) {
                    this.getArtifact().setLabel(this.label);
                }
            }
        }
        catch (RAMRuntimeException e) {
            LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ErrorAddingArtifact"), String.valueOf(this.getPath()) + this.getName()), (Throwable)e);
        }
    }

    @Override
    public List getChildren() {
        if (this.reference != null) {
            ArrayList<Reference> result = new ArrayList<Reference>();
            result.add(this.reference);
            return result;
        }
        return null;
    }

    protected RAMArtifact createFileArtifact() {
        if (!this.file.exists()) {
            LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.FileDoesNotExist"), this.file.getAbsolutePath()));
            return null;
        }
        LocalFileArtifact local = new LocalFileArtifact(this.file);
        if (this.name != null) {
            local.setName(this.name);
        }
        return local;
    }

    protected RAMURLArtifact createUrlArtifact() {
        RAMURLArtifact a = new RAMURLArtifact(this.url);
        if (this.name == null) {
            a.setName(this.url);
        } else {
            a.setName(this.name);
        }
        return a;
    }

    protected Artifact getRef() {
        return (Artifact)((Object)this.getCheckedRef(Artifact.class, Artifact.class.getName()));
    }

    public String getLabel() {
        if (this.isReference()) {
            return this.getRef().getLabel();
        }
        if (this.label != null) {
            return this.label;
        }
        if (this.getArtifact() instanceof RAMArtifact) {
            return ((RAMArtifact)this.getArtifact()).getLabel();
        }
        return null;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url.replace('\\', '/').trim();
    }

    @Override
    public Object getModel() {
        return this.getArtifact();
    }

    public com.ibm.ram.common.data.Artifact getArtifact() {
        if (this.isReference()) {
            return this.getRef().getArtifact();
        }
        if (this.artifact != null) {
            return this.artifact;
        }
        if (this.file != null && this.url != null) {
            LoggingUtil.errorExclusiveAttributes((ProjectComponent)this, "file, url");
        }
        if (this.file != null) {
            this.artifact = this.createFileArtifact();
            return this.artifact;
        }
        if (this.url != null) {
            this.artifact = this.createUrlArtifact();
            return this.artifact;
        }
        if (this.name != null && this.getAsset() != null) {
            if (this.path == null) {
                this.path = "";
            }
            if (this.path.length() > 0 && !this.path.endsWith("/")) {
                this.path = String.valueOf(this.path) + "/";
            }
            if (this.path.startsWith("/")) {
                this.path = this.path.substring(1);
            }
            RAMFolderArtifact root = (RAMFolderArtifact)this.getAsset().getArtifactsRoot();
            this.artifact = root.getChild(String.valueOf(this.path) + this.name);
        }
        return this.artifact;
    }

    public String getName() {
        if (this.isReference()) {
            return this.getRef().getName();
        }
        if (this.name != null) {
            return this.name;
        }
        return this.getArtifact().getName();
    }

    public void setName(String name) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.name = name.replace('\\', '/').trim();
    }

    public String getPath() {
        String name;
        if (this.isReference()) {
            return this.getRef().getPath();
        }
        if (this.path != null) {
            return this.path;
        }
        String path = this.getArtifact().getPath();
        if (path.endsWith(name = this.getName())) {
            path = path.substring(0, path.length() - name.length());
        }
        return path;
    }

    public void setPath(String path) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.path = path;
    }

    public void setAsset(String assetId) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.assetId = assetId;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setAsset(RAMAsset asset) {
        this.asset = asset;
    }

    public RAMAsset getAsset() {
        Object ref;
        if (this.isReference()) {
            return this.getRef().getAsset();
        }
        if (this.asset != null) {
            return this.asset;
        }
        if (this.getParent() != null && this.getParent() instanceof Asset) {
            this.asset = ((Asset)this.getParent()).getAsset();
        } else if (this.assetId != null && (ref = this.getProject().getReference(this.assetId)) != null && ref instanceof Asset) {
            this.asset = ((Asset)((Object)ref)).getAsset();
        }
        return this.asset;
    }
}

