/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.types;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMCategory;
import com.ibm.ram.client.RAMCategorySchema;
import com.ibm.ram.common.data.Category;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.types.Asset;
import com.ibm.ram.internal.client.ant.types.RAMDataType;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;
import java.util.List;
import org.apache.tools.ant.ProjectComponent;

public class Categories
extends RAMDataType {
    private String categoryString;
    private RAMAsset asset;

    public void addText(String text) {
        this.categoryString = this.getProject().replaceProperties(text);
    }

    @Override
    public void commitModel() {
        if (this.categoryString == null || this.categoryString.length() == 0) {
            LoggingUtil.warnNoValueSpecified((ProjectComponent)this);
            return;
        }
        String[] categories = this.categoryString.split(";");
        int i = 0;
        while (i < categories.length) {
            int index = categories[i].indexOf(47);
            if (index == -1) {
                LoggingUtil.info((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.InvalidCategoryList"), categories[i], "categorySchema1Name/category1Name/subcategory1Name/..."));
            } else {
                String schemaString = categories[i].substring(0, index);
                RAMCategorySchema schema = (RAMCategorySchema)this.getAsset().getAvailableCategorySchema(schemaString);
                String catString = categories[i].substring(index + 1);
                if ((index = catString.indexOf(47)) == -1) {
                    LoggingUtil.info((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.InvalidCategoryList"), categories[i], "categorySchema1Name/category1Name/subcategory1Name/..."));
                } else {
                    String categoryString = catString.substring(0, index);
                    RAMCategory category = (RAMCategory)schema.getCategory(categoryString);
                    String subcatsString = catString.substring(index + 1);
                    this.getAsset().categorize((Category)category, subcatsString);
                }
            }
            ++i;
        }
    }

    public RAMAsset getAsset() {
        if (this.isReference()) {
            return this.getRef().getAsset();
        }
        if (this.asset != null) {
            return this.asset;
        }
        if (this.getParent() != null && this.getParent() instanceof Asset) {
            this.asset = ((Asset)this.getParent()).getAsset();
        }
        return this.asset;
    }

    @Override
    public Object getModel() {
        return null;
    }

    @Override
    public List getChildren() {
        return null;
    }

    protected Categories getRef() {
        return (Categories)((Object)this.getCheckedRef(Categories.class, Categories.class.getName()));
    }

    public void setAsset(RAMAsset asset) {
        this.asset = asset;
    }
}

