/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;

public enum LongSerializationPolicy {
    DEFAULT(new DefaultStrategy()),
    STRING(new StringStrategy());

    private final Strategy strategy;

    private LongSerializationPolicy(Strategy strategy) {
        this.strategy = strategy;
    }

    public JsonElement serialize(Long value) {
        return this.strategy.serialize(value);
    }

    private static class DefaultStrategy
    implements Strategy {
        private DefaultStrategy() {
        }

        @Override
        public JsonElement serialize(Long value) {
            return new JsonPrimitive(value);
        }
    }

    private static interface Strategy {
        public JsonElement serialize(Long var1);
    }

    private static class StringStrategy
    implements Strategy {
        private StringStrategy() {
        }

        @Override
        public JsonElement serialize(Long value) {
            return new JsonPrimitive(String.valueOf(value));
        }
    }
}

