/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.LocalFileArtifact;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMFolderArtifact;
import com.ibm.ram.common.data.Artifact;
import com.ibm.ram.common.util.RAMmessageException;
import java.io.File;
import org.eclipse.emf.common.util.EList;

public class LocalFolderArtifact
extends RAMFolderArtifact {
    protected File fLocalFolder;

    public LocalFolderArtifact(File file) {
        this(file, "", file.getName());
    }

    LocalFolderArtifact(File file, String path, String name) {
        super(path, name);
        this.fLocalFolder = file;
        this.assertValidFolder(file);
    }

    LocalFolderArtifact(File file, boolean x) {
        super("", file.getName());
    }

    private void assertValidFolder(File file) {
        if (!file.exists() || !file.isDirectory()) {
            throw new RAMmessageException("Must be a valid folder: " + file.toString());
        }
    }

    LocalFolderArtifact(File file, RAMAsset asset, String path, com.ibm.ram.defaultprofile.Artifact internalArtifact) {
        super(asset, path, internalArtifact);
        this.fLocalFolder = file;
        this.assertValidFolder(file);
    }

    @Override
    public Artifact[] getChildren() {
        if (!super.hasChildren()) {
            this.processNativeChildren();
        }
        return super.getChildren();
    }

    void processNativeChildren() {
        File[] nativeChildren = this.getFolder().listFiles();
        int i = 0;
        while (i < nativeChildren.length) {
            String path;
            EList artifacts;
            if (nativeChildren[i].isDirectory()) {
                LocalFolderArtifact localFolderArtifact = null;
                if (this.getAsset() != null && (this.getInternalSolution() != null || this.getInternalArtifact() != null)) {
                    artifacts = this.getInternalSolution() != null ? this.getInternalSolution().getArtifact() : this.getInternalArtifact().getArtifact();
                    for (com.ibm.ram.defaultprofile.Artifact childArtifact : artifacts) {
                        if (!childArtifact.getName().equals(nativeChildren[i].getName())) continue;
                        path = childArtifact.computePathInSolution("/");
                        localFolderArtifact = new LocalFolderArtifact(nativeChildren[i], this.getAsset(), path, childArtifact);
                        break;
                    }
                }
                if (localFolderArtifact == null) {
                    localFolderArtifact = new LocalFolderArtifact(nativeChildren[i]);
                }
                this.addArtifact(localFolderArtifact);
            } else {
                LocalFileArtifact localFileArtifact = null;
                if (this.getAsset() != null && (this.getInternalSolution() != null || this.getInternalArtifact() != null)) {
                    artifacts = this.getInternalSolution() != null ? this.getInternalSolution().getArtifact() : this.getInternalArtifact().getArtifact();
                    for (com.ibm.ram.defaultprofile.Artifact childArtifact : artifacts) {
                        if (!childArtifact.getName().equals(nativeChildren[i].getName())) continue;
                        path = childArtifact.computePathInSolution("/");
                        localFileArtifact = new LocalFileArtifact(nativeChildren[i], this.getAsset(), path, childArtifact);
                        break;
                    }
                }
                if (localFileArtifact == null) {
                    localFileArtifact = new LocalFileArtifact(nativeChildren[i]);
                }
                this.addArtifact(localFileArtifact);
            }
            ++i;
        }
    }

    @Override
    public boolean hasChildren() {
        boolean ret = false;
        if (super.hasChildren()) {
            ret = true;
        } else if (this.getFolder() != null && this.getFolder().isDirectory() && this.getFolder().listFiles() != null && this.getFolder().listFiles().length > 0) {
            ret = true;
        }
        return ret;
    }

    public File getFolder() {
        return this.fLocalFolder;
    }
}

