/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetFeedback;
import com.ibm.ram.client.RAMAssetRating;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.common.data.AssetFeedback;
import com.ibm.ram.common.data.AssetInformation;
import com.ibm.ram.common.data.AssetRating;
import com.ibm.ram.common.data.AssetRatings;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import org.apache.log4j.Logger;

public class RAMAssetRatings
extends AssetRatings {
    private static final Logger logger = Logger.getLogger(RAMAssetRatings.class);
    private RAMAsset fAsset;
    private AssetRatings fAssetRatings;

    RAMAssetRatings(RAMAsset asset, AssetRatings ratings) throws RAMRuntimeException {
        this.fAsset = asset;
        this.fAssetRatings = ratings != null ? ratings : new AssetRatings();
    }

    RAMAssetRatings(RAMAsset asset) throws RAMRuntimeException {
        this.fAsset = asset;
        this.fAssetRatings = new AssetRatings();
    }

    public void rateAsset(int rating, String comment, boolean asAnonymous) {
        RAMAssetFeedback feedback = null;
        RAMUser user = this.fAsset.getSession().getUser();
        AssetFeedback[] feedbacks = this.getFeedback();
        int i = 0;
        while (i < feedbacks.length) {
            if (feedbacks[i] != null && feedbacks[i].getUser() != null && feedbacks[i].getUser().getUid() == user.getUid()) {
                feedback = (RAMAssetFeedback)feedbacks[i];
                break;
            }
            ++i;
        }
        if (feedback == null) {
            feedback = new RAMAssetFeedback(this.fAsset);
            AssetFeedback[] tmp = feedbacks;
            feedbacks = new AssetFeedback[tmp.length + 1];
            System.arraycopy(tmp, 0, feedbacks, 0, tmp.length);
            feedbacks[tmp.length] = feedback;
        }
        feedback.setRating(rating);
        feedback.setComment(comment);
        feedback.setAnonymous(asAnonymous);
        feedback.setTimestamp(System.currentTimeMillis());
        feedback.setUser(user);
        this.setFeedback(feedbacks);
    }

    @Override
    public AssetFeedback[] getFeedback() {
        if (super.getFeedback() == null) {
            if (this.fAssetRatings.getFeedback() == null) {
                this.fAssetRatings.setFeedback(new AssetFeedback[0]);
                super.setFeedback(new RAMAssetFeedback[0]);
            } else {
                super.setFeedback(new RAMAssetFeedback[this.fAssetRatings.getFeedback().length]);
                int i = 0;
                while (i < this.fAssetRatings.getFeedback().length) {
                    super.getFeedback()[i] = new RAMAssetFeedback(this.fAsset, this.fAssetRatings.getFeedback()[i]);
                    ++i;
                }
            }
        }
        return super.getFeedback();
    }

    @Override
    public AssetRating getRating() {
        if (super.getRating() == null) {
            super.setRating(new RAMAssetRating(this.fAsset, this.fAssetRatings.getRating()));
        }
        return super.getRating();
    }

    public AssetInformation getAsset() {
        return this.fAsset;
    }

    @Override
    public void setFeedback(AssetFeedback[] feedback) {
        AssetFeedback[] internalFeedbacks = new AssetFeedback[feedback.length];
        AssetFeedback[] feedbacks = new RAMAssetFeedback[feedback.length];
        int i = 0;
        while (i < feedback.length) {
            if (feedback[i] instanceof RAMAssetFeedback) {
                RAMAssetFeedback curFeedback = (RAMAssetFeedback)feedback[i];
                internalFeedbacks[i] = curFeedback.getInternalFeedback();
                if (this.fAsset.equals(curFeedback.getAsset())) {
                    feedbacks[i] = (RAMAssetFeedback)feedback[i];
                } else {
                    feedbacks[i] = new RAMAssetFeedback(this.fAsset, internalFeedbacks[i]);
                    ((RAMAssetFeedback)feedbacks[i]).setDirty(true);
                }
            } else {
                internalFeedbacks[i] = feedback[i];
                feedbacks[i] = new RAMAssetFeedback(this.fAsset, feedback[i]);
                ((RAMAssetFeedback)feedbacks[i]).setDirty(true);
            }
            ++i;
        }
        this.fAssetRatings.setFeedback(internalFeedbacks);
        super.setFeedback(feedbacks);
        this.fAsset.setRatingDirty(true);
    }

    @Override
    public void setRating(AssetRating rating) {
        throw new RAMRuntimeException("Rating is computed by the server");
    }

    public void removeRating() {
        RAMAssetFeedback feedback = null;
        RAMUser user = this.fAsset.getSession().getUser();
        AssetFeedback[] feedbacks = this.getFeedback();
        int i = 0;
        while (i < feedbacks.length) {
            if (feedbacks[i] != null && feedbacks[i].getUser() != null && feedbacks[i].getUser().getUid() == user.getUid()) {
                feedback = (RAMAssetFeedback)feedbacks[i];
                break;
            }
            ++i;
        }
        if (feedback != null) {
            feedback.setDelete(Boolean.TRUE);
            feedback.setDirty(Boolean.TRUE);
        } else {
            logger.warn((Object)("Feedback from user " + user.getName() + " on asset " + this.fAsset.getName() + "[" + this.fAsset.getVersion() + "]" + " does not exist. "));
        }
        this.setFeedback(feedbacks);
    }
}

