/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMAssetAttribute;
import com.ibm.ram.client.RAMAttributeConstraint;
import com.ibm.ram.client.RAMCommunity;
import com.ibm.ram.client.RAMCommunityAssetType;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.AssetType;
import com.ibm.ram.common.data.CommunityAssetType;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.emf.AssetTypeConfiguration;
import com.ibm.ram.common.emf.Attribute751Grouping;
import com.ibm.ram.common.emf.AttributeConstraint;
import com.ibm.ram.common.emf.AttributeGrouping;
import com.ibm.ram.common.emf.ConstraintGrouping;
import com.ibm.ram.common.emf.EMFFactory;
import com.ibm.ram.defaultprofile.util.Utilities;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.common.data.AssetTypeCommunityRelationshipSO;
import com.ibm.ram.internal.common.data.AssetTypeSO;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class RAMAssetType
extends AssetType
implements IRAMSessionObject {
    private static String ASSET_TYPE_HASH_KEY = "ASSET_TYPE:";
    private static final Logger logger = Logger.getLogger((String)RAMAssetType.class.getName());
    private AssetTypeSO fAssetType;
    private RAMSession fSession;
    private RAMAction fAction;
    private boolean fDirty = false;
    private boolean fConfigModified = false;
    private volatile RAMCommunityAssetType[] fCommunityAssetTypes;
    private volatile RAMAttributeConstraint[] fAttributeConstraints;
    private List<ConstraintGrouping> fConstraintGroupings;
    private AssetTypeConfiguration fAssetTypeConfig;

    RAMAssetType(RAMSession session, AssetTypeSO webServiceAssetType) {
        this.fSession = session;
        this.fAssetType = webServiceAssetType;
        this.fAction = RAMAction.UPDATE;
    }

    RAMAssetType(RAMSession session, String name) {
        this.fSession = session;
        this.fAssetType = new AssetTypeSO();
        this.fAssetType.setId(-1);
        this.fAssetType.setName(name);
        this.fAction = RAMAction.CREATE;
        this.setDirty(true);
    }

    void assetTypeCommited() throws RAMRuntimeException {
        this.fAction = RAMAction.UPDATE;
        RAMCommunityAssetType[] communityAssetTypes = (RAMCommunityAssetType[])this.getCommunityAssetTypes();
        int i = 0;
        while (i < communityAssetTypes.length) {
            communityAssetTypes[i].setAction(RAMAction.UPDATE);
            ++i;
        }
        this.setDirty(false);
    }

    List<ConstraintGrouping> getConstatintGroupings() {
        if (this.fConstraintGroupings == null) {
            this.loadConstraints();
        }
        return this.fConstraintGroupings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadConstraints() {
        String config = this.getConfiguration();
        if (config != null) {
            ResourceSet rset = this.getSession().getResourceSet();
            URI configURI = URI.createURI((String)("config:/config/" + this.fAssetType.getId()));
            XMIResource res = (XMIResource)rset.getResource(configURI, false);
            try {
                if (res == null) {
                    res = (XMIResource)rset.createResource(configURI);
                    try {
                        res.load(Utilities.createEMFInputSource((XMLResource)res, new StringReader(config)), null);
                    }
                    catch (Exception ieee) {
                        logger.error((Object)ieee.getLocalizedMessage(), (Throwable)ieee);
                    }
                }
                if (this.getSession().compareServicesVersion(RAMSession.RAM_7_1_1_0_SERVICES_VERSION) < 0) {
                    EList contents = res.getContents();
                    this.fConstraintGroupings = new ArrayList<ConstraintGrouping>(contents.size());
                    for (EObject eObject : contents) {
                        this.fConstraintGroupings.add((ConstraintGrouping)eObject);
                    }
                    this.fAssetTypeConfig = null;
                } else {
                    this.fAssetTypeConfig = (AssetTypeConfiguration)res.getContents().get(0);
                    this.fConstraintGroupings = new ArrayList<ConstraintGrouping>((Collection<ConstraintGrouping>)this.fAssetTypeConfig.getConstraints());
                }
                if (this.getSession().compareServicesVersion(RAMSession.RAM_7_5_1_0_SERVICES_VERSION) >= 0) return;
                ListIterator<ConstraintGrouping> gItr = this.fConstraintGroupings.listIterator();
                while (gItr.hasNext()) {
                    ConstraintGrouping next = gItr.next();
                    if (!(next instanceof AttributeGrouping)) continue;
                    if ((next = EMFFactory.eINSTANCE.migrateAttributeGrouping((AttributeGrouping)next)) != null) {
                        gItr.set(next);
                        continue;
                    }
                    gItr.remove();
                }
                return;
            }
            finally {
                if (res != null && res.getResourceSet() != null) {
                    res.getResourceSet().getResources().remove((Object)res);
                    res = null;
                }
            }
        }
        this.fConstraintGroupings = new ArrayList<ConstraintGrouping>(0);
    }

    private String serializeConstraints() {
        String ret;
        block18: {
            ret = null;
            if (this.fConstraintGroupings != null && this.fConstraintGroupings.size() > 0) {
                List<ConstraintGrouping> cg = this.fConstraintGroupings;
                ResourceSet rset = this.getSession().getResourceSet();
                URI configURI = URI.createURI((String)("config:/config/" + this.fAssetType.getId()));
                XMIResource res = (XMIResource)rset.createResource(configURI);
                try {
                    EList contents = res.getContents();
                    if (this.getSession().compareServicesVersion(RAMSession.RAM_7_1_1_0_SERVICES_VERSION) < 0) {
                        contents.clear();
                        for (ConstraintGrouping grouping : cg) {
                            if (grouping instanceof Attribute751Grouping) {
                                AttributeGrouping o = EMFFactory.eINSTANCE.regressAttributeGrouping((Attribute751Grouping)grouping);
                                if (o == null) continue;
                                contents.add(o);
                                continue;
                            }
                            contents.add(grouping);
                        }
                    } else {
                        if (this.fAssetTypeConfig == null) {
                            this.fAssetTypeConfig = EMFFactory.eINSTANCE.createAssetTypeConfiguration();
                        } else {
                            this.fAssetTypeConfig.getConstraints().clear();
                        }
                        EList constraints = this.fAssetTypeConfig.getConstraints();
                        if (this.getSession().compareServicesVersion(RAMSession.RAM_7_5_1_0_SERVICES_VERSION) >= 0) {
                            constraints.addAll(cg);
                        } else {
                            for (ConstraintGrouping grouping : cg) {
                                if (grouping instanceof Attribute751Grouping) {
                                    AttributeGrouping o = EMFFactory.eINSTANCE.regressAttributeGrouping((Attribute751Grouping)grouping);
                                    if (o == null) continue;
                                    constraints.add(o);
                                    continue;
                                }
                                constraints.add(grouping);
                            }
                        }
                        contents.clear();
                        if (!this.fAssetTypeConfig.isClean()) {
                            contents.add(this.fAssetTypeConfig);
                        }
                    }
                    if (res.getContents().isEmpty()) break block18;
                    try {
                        StringWriter sw = new StringWriter(1000);
                        res.save((Writer)sw, null);
                        ret = sw.toString();
                    }
                    catch (IOException e) {
                        throw new RAMRuntimeException(ClientMessages.getString("RAMAssetType.1"), e);
                    }
                }
                finally {
                    if (res != null) {
                        res.getResourceSet().getResources().remove((Object)res);
                    }
                }
            }
        }
        return ret;
    }

    public RAMAttributeConstraint createAttributeConstraint(RAMAssetAttribute attribute, boolean required) {
        long start = 0L;
        if (logger.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        RAMAttributeConstraint ret = new RAMAttributeConstraint(this, attribute, required);
        List<ConstraintGrouping> groupings = this.getConstatintGroupings();
        boolean found = false;
        boolean internalExist = false;
        for (ConstraintGrouping grouping : groupings) {
            if (!(grouping instanceof Attribute751Grouping)) continue;
            int idx = 0;
            while (idx < ((Attribute751Grouping)grouping).getColumn1().size()) {
                Object obj = ((Attribute751Grouping)grouping).getColumn1().get(idx);
                if (obj instanceof AttributeConstraint) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("AttributeConstraint object found at index: " + idx + " replacing existing AttributeConstraint."));
                    }
                    if (((AttributeConstraint)obj).getAttributeName().equals(ret.getInternalAttributeConstraint().getAttributeName())) {
                        ((Attribute751Grouping)grouping).getColumn1().set(idx, obj);
                        found = true;
                        break;
                    }
                }
                ++idx;
            }
            if (!found) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Existing AttributeConstraint not found. Adding new AttributeConstraint.");
                }
                ((Attribute751Grouping)grouping).getColumn1().add((Object)ret.getInternalAttributeConstraint());
            }
            internalExist = true;
            break;
        }
        if (!internalExist) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Attribute751Grouping not found. Creating new Attribute751Grouping.");
            }
            Attribute751Grouping attGrouping = EMFFactory.eINSTANCE.createDefaultAttribute751Grouping();
            attGrouping.getColumn1().add((Object)ret.getInternalAttributeConstraint());
            this.fConstraintGroupings.add(attGrouping);
        }
        RAMAttributeConstraint[] attributes = this.getAttributeConstraints();
        if (found) {
            int idx = 0;
            while (idx < attributes.length) {
                if (attributes[idx].getInternalAttributeConstraint().getAttributeName().equals(ret.getInternalAttributeConstraint().getAttributeName())) {
                    attributes[idx] = ret;
                    break;
                }
                ++idx;
            }
        } else {
            attributes[attributes.length - 1] = ret;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("function took: " + (System.currentTimeMillis() - start) + " to finish create constraints"));
            logger.debug((Object)"Finish attribute constraint adding, set modifcation flag.");
        }
        this.fConfigModified = true;
        this.setDirty(true);
        return ret;
    }

    public RAMAttributeConstraint[] getAttributeConstraints() {
        if (this.fAttributeConstraints == null) {
            List<ConstraintGrouping> groupings = this.getConstatintGroupings();
            ArrayList<RAMAttributeConstraint> ramAttributeConstraints = new ArrayList<RAMAttributeConstraint>();
            for (ConstraintGrouping grouping : groupings) {
                if (!(grouping instanceof Attribute751Grouping)) continue;
                for (AttributeConstraint ac : ((Attribute751Grouping)grouping).getConstraintsIterator(false)) {
                    ramAttributeConstraints.add(new RAMAttributeConstraint(this, ac));
                }
            }
            RAMAttributeConstraint[] tmpArray = ramAttributeConstraints.toArray(new RAMAttributeConstraint[ramAttributeConstraints.size()]);
            this.fAttributeConstraints = tmpArray;
        }
        return this.fAttributeConstraints;
    }

    @Override
    public String getDescription() throws RAMRuntimeException {
        return this.fAssetType.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.fAssetType.setDescription(description);
        this.setDirty(true);
    }

    @Override
    public int getId() throws RAMRuntimeException {
        return this.fAssetType.getId();
    }

    @Override
    public void setId(int id) {
        this.fAssetType.setId(id);
        this.setDirty(true);
    }

    @Override
    public String getName() throws RAMRuntimeException {
        return this.fAssetType.getName();
    }

    @Override
    public void setName(String name) {
        this.fAssetType.setName(name);
        this.setDirty(true);
    }

    @Override
    public String getURI() throws RAMRuntimeException {
        if (this.fAssetType == null) {
            return null;
        }
        return this.fAssetType.getURI();
    }

    AssetTypeSO getInternalAssetType() throws RAMRuntimeException {
        return this.fAssetType;
    }

    RAMSession getSession() {
        return this.fSession;
    }

    void setDirty(boolean dirtyFlag) {
        this.fDirty = dirtyFlag;
        if (dirtyFlag) {
            this.getSession().cache(this);
        } else {
            this.getSession().uncache(this);
        }
    }

    @Override
    public boolean isDirty() {
        return this.fDirty;
    }

    String getSessionKey() {
        String ret = this.getId() == -1 ? String.valueOf(ASSET_TYPE_HASH_KEY) + this.getId() : String.valueOf(ASSET_TYPE_HASH_KEY) + this.getName();
        return ret;
    }

    public String toString() {
        if (this.fAssetType != null) {
            return this.fAssetType.getName();
        }
        return super.toString();
    }

    public boolean isPrivate() {
        return this.fAssetType.isPrivate();
    }

    public boolean isRestricted() {
        return this.fAssetType.isRestricted();
    }

    public void setPrivate(boolean isPrivate) {
        this.fAssetType.setPrivate(isPrivate);
        this.setDirty(true);
    }

    public void setRestricted(boolean restricted) {
        this.fAssetType.setRestricted(restricted);
        this.setDirty(true);
    }

    @Override
    public void setURI(String uri) {
        this.fAssetType.setURI(uri);
        this.setDirty(true);
    }

    public void setConfiguration(String configuration) {
        this.fAssetType.setConfiguration(configuration);
        this.fConstraintGroupings = null;
        this.fAttributeConstraints = null;
        this.setDirty(true);
    }

    public String getConfiguration() {
        if (this.fConfigModified) {
            String config = this.serializeConstraints();
            this.fAssetType.setConfiguration(config);
            this.fConfigModified = false;
        }
        return this.fAssetType.getConfiguration();
    }

    public CommunityAssetType[] getCommunityAssetTypes() {
        if (this.fCommunityAssetTypes == null) {
            ArrayList<RAMCommunityAssetType> tmpAssetTypes = new ArrayList<RAMCommunityAssetType>();
            AssetTypeCommunityRelationshipSO[] rawCommunityAssetTypes = this.getInternalAssetType().getCommunityRelationships();
            if (rawCommunityAssetTypes != null) {
                AssetTypeCommunityRelationshipSO[] assetTypeCommunityRelationshipSOArray = rawCommunityAssetTypes;
                int n = rawCommunityAssetTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    AssetTypeCommunityRelationshipSO ramCommunityAssetType = assetTypeCommunityRelationshipSOArray[n2];
                    RAMCommunityAssetType tmp = new RAMCommunityAssetType(this.getSession(), ramCommunityAssetType);
                    if (tmp.getCommunity() != null) {
                        tmpAssetTypes.add(tmp);
                    }
                    ++n2;
                }
            }
            RAMCommunityAssetType[] tmpArray = tmpAssetTypes.toArray(new RAMCommunityAssetType[tmpAssetTypes.size()]);
            this.fCommunityAssetTypes = tmpArray;
        }
        return this.fCommunityAssetTypes;
    }

    AssetTypeCommunityRelationshipSO[] getCommunityAssetTypeSOs() {
        CommunityAssetType[] assetTypes = this.getCommunityAssetTypes();
        AssetTypeCommunityRelationshipSO[] tmp = new AssetTypeCommunityRelationshipSO[assetTypes.length];
        int i = 0;
        while (i < assetTypes.length) {
            tmp[i] = new AssetTypeCommunityRelationshipSO();
            tmp[i].setCommunity(assetTypes[i].getCommunity());
            tmp[i].setConfiguration(assetTypes[i].getConfiguration());
            tmp[i].setDescription(assetTypes[i].getDescription());
            tmp[i].setLocal(assetTypes[i].isLocal());
            tmp[i].setMasterAssetType(this);
            tmp[i].setCommunityID(assetTypes[i].getCommunity().getId());
            tmp[i].setAssetTypeID(this.getId());
            ++i;
        }
        return tmp;
    }

    public CommunityAssetType getCommunityAssetType(CommunityInformation community) {
        RAMCommunity ramCommunity = null;
        RAMCommunityAssetType communityAssetType = null;
        ramCommunity = !(community instanceof RAMCommunity) || ((RAMCommunity)community).getSession() != this.getSession() ? this.getSession().getCommunity(community.getName()) : (RAMCommunity)community;
        if (ramCommunity == null) {
            String message = MessageFormat.format(ClientMessages.getString("RAMAssetType.COMMUNITY_NOT_FOUND"), community);
            throw new RAMRuntimeException(message, true);
        }
        RAMCommunityAssetType[] communityAssetTypes = (RAMCommunityAssetType[])this.getCommunityAssetTypes();
        int i = 0;
        while (i < communityAssetTypes.length) {
            if (ramCommunity.getId() == communityAssetTypes[i].getCommunity().getId()) {
                communityAssetType = communityAssetTypes[i];
                break;
            }
            ++i;
        }
        return communityAssetType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommunityAssetType createCommunityAssetType(CommunityInformation community) {
        RAMCommunityAssetType[] communityAssetTypes;
        RAMCommunity ramCommunity = null;
        RAMCommunityAssetType communityAssetType = null;
        if (!(community instanceof RAMCommunity) || ((RAMCommunity)community).getSession() != this.getSession()) {
            community = this.getSession().getCommunity(community.getName());
        } else {
            ramCommunity = (RAMCommunity)community;
        }
        if (community == null) {
            String message = MessageFormat.format(ClientMessages.getString("RAMAssetType.COMMUNITY_NOT_FOUND"), community);
            throw new RAMRuntimeException(message, true);
        }
        RAMCommunityAssetType[] rAMCommunityAssetTypeArray = communityAssetTypes = (RAMCommunityAssetType[])this.getCommunityAssetTypes();
        synchronized (communityAssetTypes) {
            int i = 0;
            while (i < communityAssetTypes.length) {
                if (ramCommunity.getId() == communityAssetTypes[i].getCommunity().getId()) {
                    communityAssetType = communityAssetTypes[i];
                    break;
                }
                ++i;
            }
            if (communityAssetType == null) {
                communityAssetType = new RAMCommunityAssetType(this, ramCommunity);
                RAMCommunityAssetType[] tmpAssetTypes = new RAMCommunityAssetType[communityAssetTypes.length + 1];
                int i2 = 0;
                while (i2 < communityAssetTypes.length) {
                    tmpAssetTypes[i2] = communityAssetTypes[i2];
                    ++i2;
                }
                tmpAssetTypes[communityAssetTypes.length] = communityAssetType;
                this.fCommunityAssetTypes = tmpAssetTypes;
            }
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return communityAssetType;
        }
    }

    @Override
    public RAMAction getAction() {
        return this.fAction;
    }

    public void setAction(RAMAction action) {
        if (action != RAMAction.CREATE && action != RAMAction.UPDATE && action != RAMAction.DELETE) {
            String message = MessageFormat.format(ClientMessages.getString("ACTION_NOT_ACCEPTABLE"), action.getName(), this.getClass().getName());
            throw new RAMRuntimeException(message, true);
        }
        this.fAction = action;
        if (action == RAMAction.DELETE) {
            this.setDirty(true);
        }
    }
}

