/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.data;

import com.ibm.ram.common.data.RelationshipRange;
import com.ibm.ram.common.util.UtilitiesCommon;

public class RelationshipInfo {
    private RelationshipRange range;
    private int id;
    private int stateId;
    private boolean source;
    private boolean reverseRange;
    private int toAssetId;
    public static final RelationshipInfo EMPTY_INFO = new RelationshipInfo();

    public static RelationshipInfo getInfoWithoutId(RelationshipInfo info) {
        if (info == null) {
            return EMPTY_INFO;
        }
        if (info.getId() == 0 && info.getStateId() == 0 && info.getToAssetId() == 0) {
            return info;
        }
        return new RelationshipInfo(0, 0, 0, info.range, info.source, info.reverseRange);
    }

    public RelationshipInfo() {
        this(0, 0, 0, null, false, false);
    }

    public RelationshipInfo(int id, RelationshipRange range, boolean source, boolean reverseRange) {
        this(id, 0, 0, range, source, reverseRange);
    }

    public RelationshipInfo(int id, int stateid, int toid, RelationshipRange range, boolean source, boolean reverseRange) {
        this.id = id;
        this.stateId = stateid;
        this.toAssetId = toid;
        this.range = range;
        this.source = source || reverseRange;
        this.reverseRange = reverseRange;
    }

    public int hashCode() {
        return ((((this.id * 31 + Boolean.valueOf(this.source).hashCode()) * 31 + this.stateId) * 31 + this.toAssetId) * 31 + Boolean.valueOf(this.reverseRange).hashCode()) * 31 + (this.range != null ? this.range.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof RelationshipInfo)) {
            return false;
        }
        RelationshipInfo ri = (RelationshipInfo)obj;
        return this.id == ri.getId() && this.stateId == ri.getStateId() && this.toAssetId == ri.getToAssetId() && this.isSource() == ri.isSource() && this.isReverseRange() == ri.isReverseRange() && UtilitiesCommon.objectsEqual(this.range, ri.getRange());
    }

    public String toString() {
        return "RelationshipInfo{id:" + this.id + ", stateid:" + this.stateId + ", to asset id: " + this.toAssetId + ", source:" + this.source + ", reverseRange:" + this.reverseRange + ", rangeInfo:" + this.range + '}';
    }

    public RelationshipRange getRange() {
        return this.range;
    }

    public int getId() {
        return this.id;
    }

    public boolean isSource() {
        return this.source;
    }

    public boolean isReverseRange() {
        return this.reverseRange;
    }

    public int getStateId() {
        return this.stateId;
    }

    public int getToAssetId() {
        return this.toAssetId;
    }

    public void setRange(RelationshipRange range) {
        this.range = range;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setStateId(int stateId) {
        this.stateId = stateId;
    }

    public void setSource(boolean source) {
        this.source = source;
    }

    public void setReverseRange(boolean reverseRange) {
        this.reverseRange = reverseRange;
    }

    public void setToAssetId(int toid) {
        this.toAssetId = toid;
    }
}

