/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.emf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class SubscriptionType
extends AbstractEnumerator {
    public static final int SEARCH = 0;
    public static final int ASSET = 1;
    public static final int FORUM = 2;
    public static final int TOPIC = 3;
    public static final SubscriptionType SEARCH_LITERAL = new SubscriptionType(0, "Search", "Search");
    public static final SubscriptionType ASSET_LITERAL = new SubscriptionType(1, "Asset", "Asset");
    public static final SubscriptionType FORUM_LITERAL = new SubscriptionType(2, "Forum", "Forum");
    public static final SubscriptionType TOPIC_LITERAL = new SubscriptionType(3, "Topic", "Topic");
    private static final SubscriptionType[] VALUES_ARRAY = new SubscriptionType[]{SEARCH_LITERAL, ASSET_LITERAL, FORUM_LITERAL, TOPIC_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static SubscriptionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SubscriptionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SubscriptionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SubscriptionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SubscriptionType get(int value) {
        switch (value) {
            case 0: {
                return SEARCH_LITERAL;
            }
            case 1: {
                return ASSET_LITERAL;
            }
            case 2: {
                return FORUM_LITERAL;
            }
            case 3: {
                return TOPIC_LITERAL;
            }
        }
        return null;
    }

    private SubscriptionType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

