/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.defaultprofile.Artifact;
import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.Description;
import com.ibm.ram.internal.common.util.SerializationHelper;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class ArtifactCacheUtil {
    private static final Logger LOGGER = Logger.getLogger(ArtifactCacheUtil.class);
    public static final String DESCRIPTION_USER_KEY = "CACHE_OWNER";
    public static final String DESCRIPTION_CREDENTIAL_KEY = "CACHE_CREDS";
    public static final String DESCRIPTION_CACHE_DOWNLOADABLE = "CACHE_DOWNLOADABLE";
    public static final String DESCRIPTION_FILE_KEY = "CACHE_FILE";
    public static final String DESCRIPTION_URL_NAME_KEY = "CACHE_URL_NAME";
    public static final String DESCRIPTION_URL_REF_KEY = "CACHE_URL_REF";
    public static final String DESCRIPTION_ARTIFACT_TYPE = "CACHE_ARTIFACT_TYPE";

    public static Description createCachedArtifactDescription(String userId, String credential, File cacheFile, boolean isDownloadable) {
        String serializedMap;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(DESCRIPTION_ARTIFACT_TYPE, "url_cache");
        map.put(DESCRIPTION_USER_KEY, userId);
        map.put(DESCRIPTION_CREDENTIAL_KEY, credential);
        map.put(DESCRIPTION_CACHE_DOWNLOADABLE, isDownloadable);
        if (cacheFile != null) {
            map.put(DESCRIPTION_FILE_KEY, cacheFile.getName());
        } else {
            map.put(DESCRIPTION_FILE_KEY, null);
        }
        try {
            serializedMap = new SerializationHelper(map).serialize();
        }
        catch (Exception exception) {
            serializedMap = "";
        }
        Description desc = DefaultprofileFactory.eINSTANCE.createDescription();
        desc.setValue(serializedMap);
        return desc;
    }

    public static Description createArtifactCacheDescription(String cacheURLName, String cacheURLRef) {
        String serializedMap;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DESCRIPTION_ARTIFACT_TYPE, "com.ibm.ram.url.cache");
        map.put(DESCRIPTION_URL_NAME_KEY, cacheURLName);
        map.put(DESCRIPTION_URL_REF_KEY, cacheURLRef);
        try {
            serializedMap = new SerializationHelper(map).serialize();
        }
        catch (Exception exception) {
            serializedMap = "";
        }
        Description desc = DefaultprofileFactory.eINSTANCE.createDescription();
        desc.setValue(serializedMap);
        return desc;
    }

    public static <K, V> Map<K, V> deserialize(Description description) {
        if (description != null && SerializationHelper.isValidXMLToDecode(description.getValue())) {
            try {
                return (Map)new SerializationHelper(description.getValue()).deserialize();
            }
            catch (ParserConfigurationException e) {
                LOGGER.error((Object)"Error deserializing artifact description: ", (Throwable)e);
            }
            catch (SAXException e) {
                LOGGER.error((Object)"Error deserializing artifact description: ", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error deserializing artifact description: ", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error deserializing artifact description: ", (Throwable)e);
            }
        }
        return Collections.emptyMap();
    }

    public static String getCacheFileName(String urlName, int cacheNum) {
        if (cacheNum > 0) {
            return "_cache" + cacheNum + "_" + urlName;
        }
        return "_cache_" + urlName;
    }

    public static String getCacheNameForURLArtifact(Artifact urlCacheArtifact) {
        if (!ManifestAccessor.isURLCacheArtifact(urlCacheArtifact)) {
            throw new IllegalArgumentException("Artifact must be of type url cache.");
        }
        Map urlDescMap = ArtifactCacheUtil.deserialize(urlCacheArtifact.getDescription());
        String cacheFileName = (String)urlDescMap.get(DESCRIPTION_FILE_KEY);
        return cacheFileName;
    }

    public static String getCacheUserForURLArtifact(Artifact urlCacheArtifact) {
        if (!ManifestAccessor.isURLCacheArtifact(urlCacheArtifact)) {
            throw new IllegalArgumentException("Artifact must be of type url cache.");
        }
        Map urlDescMap = ArtifactCacheUtil.deserialize(urlCacheArtifact.getDescription());
        String cacheUserName = (String)urlDescMap.get(DESCRIPTION_USER_KEY);
        return cacheUserName;
    }

    public static String getCacheCredentialForURLArtifact(Artifact urlCacheArtifact) {
        if (!ManifestAccessor.isURLCacheArtifact(urlCacheArtifact)) {
            throw new IllegalArgumentException("Artifact must be of type url cache.");
        }
        Map urlDescMap = ArtifactCacheUtil.deserialize(urlCacheArtifact.getDescription());
        String cacheCredentialName = (String)urlDescMap.get(DESCRIPTION_CREDENTIAL_KEY);
        return cacheCredentialName;
    }

    public static boolean getCacheDownloadableForURLArtifact(Artifact urlCacheArtifact) {
        if (!ManifestAccessor.isURLCacheArtifact(urlCacheArtifact)) {
            throw new IllegalArgumentException("Artifact must be of type url cache.");
        }
        Map urlDescMap = ArtifactCacheUtil.deserialize(urlCacheArtifact.getDescription());
        if (urlDescMap.containsKey(DESCRIPTION_CACHE_DOWNLOADABLE)) {
            return (Boolean)urlDescMap.get(DESCRIPTION_CACHE_DOWNLOADABLE);
        }
        return false;
    }

    public static String getArtifactTypeFromDescription(Artifact artifact) {
        Map artifactDescMap = ArtifactCacheUtil.deserialize(artifact.getDescription());
        String type = (String)artifactDescMap.get(DESCRIPTION_ARTIFACT_TYPE);
        return type;
    }

    public static String getURLNameForCacheArtifact(Artifact cacheArtifact) {
        if (!ManifestAccessor.isFileCacheArtifact(cacheArtifact)) {
            throw new IllegalArgumentException("Artifact must be of type file cache.");
        }
        Map cacheDescMap = ArtifactCacheUtil.deserialize(cacheArtifact.getDescription());
        String url = (String)cacheDescMap.get(DESCRIPTION_URL_NAME_KEY);
        return url;
    }

    public static String getURLReferenceForCacheArtifact(Artifact cacheArtifact) {
        if (!ManifestAccessor.isFileCacheArtifact(cacheArtifact)) {
            throw new IllegalArgumentException("Artifact must be of type file cache.");
        }
        Map cacheDescMap = ArtifactCacheUtil.deserialize(cacheArtifact.getDescription());
        String url = (String)cacheDescMap.get(DESCRIPTION_URL_REF_KEY);
        return url;
    }
}

