/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import com.ibm.ram.defaultprofile.util.Utilities;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MavenUtil {
    public static final String MAVEN_SEVERLET = "/maven2";
    public static final String GROUP_ID_ATTRIBUTE = "Group.Id";
    public static final String GROUP_ID_ATTRIBUTE_ID = Utilities.formGlobalAttributeURI("Group.Id".toLowerCase(), null).toString();
    public static final String DIGEST_FOLDER = ".com.ibm.ram.data/.maven/";
    public static final String DEPENDANCY_RELATION_NAME = "dependency";
    public static final String DEPENDS_ON_RELATION_NAME = "depends on";

    private MavenUtil() {
    }

    public static String checkSum(InputStream is, String type) throws Exception {
        MessageDigest md = MessageDigest.getInstance(type);
        StringBuilder builder = new StringBuilder();
        try {
            byte[] data;
            byte[] bytes = new byte[1024];
            int read = 0;
            while ((read = is.read(bytes)) != -1) {
                md.update(bytes, 0, read);
            }
            byte[] byArray = data = md.digest();
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                Byte b = byArray[n2];
                builder.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
                ++n2;
            }
        }
        finally {
            is.close();
        }
        return builder.toString();
    }

    public static String checkSum(byte[] bytes, String type) throws NoSuchAlgorithmException {
        byte[] data;
        MessageDigest md = MessageDigest.getInstance(type);
        StringBuilder builder = new StringBuilder();
        md.update(bytes);
        byte[] byArray = data = md.digest();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Byte b = byArray[n2];
            builder.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            ++n2;
        }
        return builder.toString();
    }

    public static String mavenAssetQuery(String groupId, String artifactId, String version) {
        return "name:(" + artifactId + ") version:(" + version + ") attribute:('" + GROUP_ID_ATTRIBUTE + "'='" + groupId + "')";
    }

    public static class CheckSumInputStream
    extends FilterInputStream {
        private final MessageDigest[] digesters;

        public CheckSumInputStream(InputStream in, String ... checkSumType) throws NoSuchAlgorithmException {
            super(in);
            this.digesters = new MessageDigest[checkSumType.length];
            int i = 0;
            while (i < checkSumType.length) {
                this.digesters[i] = MessageDigest.getInstance(checkSumType[i]);
                ++i;
            }
        }

        @Override
        public int read() throws IOException {
            int c = super.read();
            if (c != -1) {
                MessageDigest[] messageDigestArray = this.digesters;
                int n = this.digesters.length;
                int n2 = 0;
                while (n2 < n) {
                    MessageDigest digest = messageDigestArray[n2];
                    digest.update((byte)c);
                    ++n2;
                }
            }
            return c;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = super.read(b, off, len);
            if (read > 0) {
                MessageDigest[] messageDigestArray = this.digesters;
                int n = this.digesters.length;
                int n2 = 0;
                while (n2 < n) {
                    MessageDigest digest = messageDigestArray[n2];
                    digest.update(b, off, read);
                    ++n2;
                }
            }
            return read;
        }

        public String[] getDigests() {
            String[] digests = new String[this.digesters.length];
            int i = 0;
            while (i < this.digesters.length) {
                MessageDigest digest = this.digesters[i];
                byte[] d = digest.digest();
                StringBuilder sb = new StringBuilder(d.length * 2);
                byte[] byArray = d;
                int n = d.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
                    ++n2;
                }
                digests[i] = sb.toString();
                ++i;
            }
            return digests;
        }
    }
}

