/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.fix;

import com.ibm.ram.fix.FileAccess;
import com.ibm.ram.fix.Fixes;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class EmptyFileAccess
extends FileAccess {
    private static final byte[] EMPTY = new byte[0];

    public EmptyFileAccess(byte[] copybuffer, File workDir) {
        super(copybuffer, workDir);
    }

    public EmptyFileAccess(FileAccess parentFA, String path) {
        super(parentFA, path);
    }

    @Override
    public void addContents(String name, String contents) {
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected void doFinish() {
    }

    @Override
    public void extractTo(String name, ZipEntry ze, ZipFile zip) {
    }

    @Override
    public FileAccess.FileType getFileType(String name) {
        return FileAccess.FileType.notExist;
    }

    @Override
    public List<String> getFiles(FileAccess.NameFilter filter, boolean nest) {
        return Collections.emptyList();
    }

    @Override
    public String getFullname(String name) {
        return name;
    }

    @Override
    public InputStream getIS(String file) {
        return new ByteArrayInputStream(EMPTY);
    }

    @Override
    public FileAccess getNested(String name) throws IOException {
        throw new FileNotFoundException(name);
    }

    @Override
    public OutputStream getOS(String file) throws IOException, Fixes.FileIsDirectory {
        throw new FileNotFoundException(file);
    }

    @Override
    public boolean touch(String file) {
        return false;
    }

    @Override
    public InputStream getNestedIS(String file) {
        return new ByteArrayInputStream(EMPTY);
    }

    @Override
    public File extract(String file) throws IOException {
        return File.createTempFile(file, null, this.getWorkDir());
    }
}

