/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.util;

import com.ibm.ram.client.LocalFileArtifact;
import com.ibm.ram.client.RAMArtifact;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMFolderArtifact;
import com.ibm.ram.common.data.Asset;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.util.ArtifactAccessor;
import com.ibm.ram.common.util.InputStreamInformation;
import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.defaultprofile.Artifact;
import com.ibm.ram.internal.client.AbstractRAMClient;
import java.io.InputStream;

public class ClientArtifactAccessor
implements ArtifactAccessor {
    AbstractRAMClient fClient;
    String assetID;
    String assetVersion;
    private RAMAsset asset;

    public ClientArtifactAccessor(Asset asset, AbstractRAMClient client) {
        this(asset.getGUID(), asset.getVersion(), client);
    }

    public ClientArtifactAccessor(String assetID, String assetVersion, AbstractRAMClient client) {
        this.fClient = client;
        this.assetID = assetID;
        this.assetVersion = assetVersion;
        this.asset = null;
    }

    public ClientArtifactAccessor(RAMAsset asset) {
        this(asset.getGUID(), asset.getVersion(), asset);
    }

    public ClientArtifactAccessor(String assetID, String assetVersion, RAMAsset asset) {
        this.assetID = assetID;
        this.assetVersion = assetVersion;
        this.asset = asset;
    }

    @Override
    public InputStream getArtifactContent(Artifact artifact) {
        InputStreamInformation isinfo = this.getArtifactContentInformation(artifact);
        return isinfo != null ? isinfo.getIs() : null;
    }

    @Override
    public InputStreamInformation getArtifactContentInformation(Artifact artifact) {
        if (this.asset != null) {
            return this.getContentFromSession(artifact);
        }
        return this.getContentFromClient(artifact);
    }

    private InputStreamInformation getContentFromSession(Artifact artifact) throws RAMRuntimeException {
        RAMArtifact ramArtifact;
        block9: {
            String path;
            block8: {
                block7: {
                    if (artifact != null && !ManifestAccessor.isFolder(artifact)) break block7;
                    return null;
                }
                path = "";
                path = artifact.computePathInSolution("/");
                if (this.asset != null) break block8;
                return null;
            }
            RAMFolderArtifact root = (RAMFolderArtifact)this.asset.getArtifactsRoot();
            ramArtifact = (RAMArtifact)root.getChild(path);
            if (ramArtifact != null) break block9;
            return null;
        }
        try {
            if (ramArtifact instanceof LocalFileArtifact) {
                return ((LocalFileArtifact)ramArtifact).getContents(false);
            }
            return ramArtifact.downloadContentInformation();
        }
        catch (RAMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    private InputStreamInformation getContentFromClient(Artifact artifact) throws RAMRuntimeException {
        block4: {
            try {
                if (artifact != null && !ManifestAccessor.isFolder(artifact)) break block4;
                return null;
            }
            catch (Exception e) {
                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
            }
        }
        String path = "";
        path = artifact.computePathInSolution("/");
        AbstractRAMClient.Response response = this.fClient.downloadArtifact(path, this.assetID, this.assetVersion, false);
        if (response.code == 200) {
            boolean exactSize = response.headers != null && response.headers.containsKey("Content-Length");
            return new InputStreamInformation(response.is, exactSize ? Long.valueOf(response.headers.get("Content-Length")) : 0L, exactSize, artifact.getName(), 0L, null, null);
        }
        throw new RAMRuntimeException(String.valueOf(Integer.toString(response.code)) + ": " + this.fClient.getStatusText(response.code));
    }
}

