/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.bundles;

import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.common.bundles.AbstractMessages;
import com.ibm.ram.internal.common.util.ParallelWriterReader;
import com.ibm.ram.internal.common.util.SerializationHelper;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class StoredMessage
implements Serializable {
    private static final long serialVersionUID = -6586130065187540953L;
    private static final Logger logger = Logger.getLogger(StoredMessage.class);
    private String bundleName;
    private List<Message> messages = new ArrayList<Message>(1);
    public static final String STORED_MESSAGE_TAGNAME = "messages";
    private static final String MESSAGE_TAGNAME = "message";
    private static final String VARIABLE_TAGNAME = "variable";
    private static final String DATE_TAGNAME = "date";
    private static final String CLASS_NAME_ATTR = "class";
    private static final String NLS_KEY_ATTR = "key";
    private static final String DEFAULT_VALUE = "default";
    private static final String DATE_ATTR = "date";
    private String indent = "2";
    private static final String LEADING_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String LEADING_MESSAGES = "<messages";
    public static final int PUSHBACK_SIZE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".length() + "<messages".length() + 100;

    public StoredMessage(Class<? extends AbstractMessages> messageClass) {
        this.bundleName = messageClass.getName();
    }

    public StoredMessage() {
    }

    public static SerializationHelper.DeSerializationHandler<StoredMessage> getDefaultHandler() {
        return new SerializationHelper.DeSerializationHandler<StoredMessage>(){
            private Stack<Object> objects = new Stack();
            private Stack<StoredMessage> sms = new Stack();

            @Override
            public StoredMessage getResult() {
                return this.sms.peek();
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                this.setRetrievingCharacters(false, true);
                if (StoredMessage.STORED_MESSAGE_TAGNAME.equals(qName)) {
                    StoredMessage currentSM = new StoredMessage();
                    String bundle = attributes.getValue(StoredMessage.CLASS_NAME_ATTR);
                    if (!UtilitiesCommon.isEmptyString(bundle)) {
                        currentSM.bundleName = bundle;
                    }
                    this.sms.push(currentSM);
                    this.objects.push(currentSM);
                } else if (StoredMessage.MESSAGE_TAGNAME.equals(qName)) {
                    String key = attributes.getValue(StoredMessage.NLS_KEY_ATTR);
                    String bundle = attributes.getValue(StoredMessage.CLASS_NAME_ATTR);
                    String defValue = attributes.getValue(StoredMessage.DEFAULT_VALUE);
                    StoredMessage storedMessage = this.sms.peek();
                    storedMessage.getClass();
                    this.objects.push(storedMessage.new Message(key, null, bundle, defValue));
                } else if (StoredMessage.VARIABLE_TAGNAME.equals(qName)) {
                    this.objects.push(StoredMessage.VARIABLE_TAGNAME);
                    this.setRetrievingCharacters(true, true);
                } else if ("date".equals(qName)) {
                    Long tsl;
                    String time = attributes.getValue("date");
                    if (UtilitiesCommon.isEmptyString(time)) {
                        time = "0";
                    }
                    try {
                        tsl = Long.parseLong(time);
                    }
                    catch (NumberFormatException numberFormatException) {
                        tsl = 0L;
                    }
                    this.objects.push(new Timestamp(tsl));
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (StoredMessage.STORED_MESSAGE_TAGNAME.equals(qName)) {
                    if (this.sms.size() == 1) {
                        SerializationHelper.DeserializationHandlerWrapper wrapper = this.getWrapper();
                        wrapper.popNestedHandler();
                        wrapper.endElement(uri, localName, qName);
                    } else {
                        this.sms.pop();
                    }
                } else if (StoredMessage.MESSAGE_TAGNAME.equals(qName)) {
                    Message msg = (Message)this.objects.pop();
                    Object next = this.objects.peek();
                    if (next == StoredMessage.VARIABLE_TAGNAME) {
                        this.objects.push(msg);
                    } else if (next instanceof StoredMessage) {
                        ((StoredMessage)next).addMessage(msg);
                    }
                } else if (StoredMessage.VARIABLE_TAGNAME.equals(qName)) {
                    Object value = this.objects.pop();
                    if (value == StoredMessage.VARIABLE_TAGNAME) {
                        value = this.getCharactersContent(true);
                        this.setRetrievingCharacters(false, true);
                    } else {
                        this.objects.pop();
                    }
                    Message msg = (Message)this.objects.peek();
                    msg.addValue(value);
                } else {
                    "date".equals(qName);
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                this.charactersHandler(ch, start, length);
            }
        };
    }

    public Message addMessage(String key, Object ... values) {
        return this.addMessage(null, key, values);
    }

    public Message addMessage(Class<? extends AbstractMessages> messageClass, String key, Object ... values) {
        return this.addMessage(new Message(messageClass, key, null, values));
    }

    public Message addMessageString(String msg) {
        return this.addMessage(new Message(null, msg));
    }

    public Message addMessage(Message message) {
        this.messages.add(message);
        return message;
    }

    public StoredMessage addStoredMessage(StoredMessage storedMessage) {
        this.messages.addAll(storedMessage.getMessages());
        return this;
    }

    public String toString() {
        try {
            StringWriter w = new StringWriter();
            this.serialize(w);
            return w.toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {}
        return null;
    }

    public void setIndent(Integer indent) {
        this.indent = indent == null ? null : (indent == -1 ? "2" : indent.toString());
    }

    public ParallelWriterReader.WriterRunnable getSerializeRunnable() {
        return new ParallelWriterReader.WriterRunnable(){

            @Override
            public void run(Writer writer) throws IOException {
                try {
                    StoredMessage.this.serialize(writer);
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                }
                catch (TransformerException transformerException) {}
            }

            @Override
            public String getThreadName() {
                return "Serializing stored message";
            }
        };
    }

    public void serialize(Writer writer) throws TransformerConfigurationException, TransformerException {
        Transformer transformer = null;
        try {
            transformer = SerializationHelper.getTransformer(this.indent);
            transformer.transform(new SAXSource(new SerializationHelper.SerializeXMLReader<StoredMessage>(new MessageXMLEncoder()), new MessageSource()), new StreamResult(writer));
        }
        catch (Throwable throwable) {
            SerializationHelper.returnTransformer(transformer);
            try {
                writer.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        SerializationHelper.returnTransformer(transformer);
        try {
            writer.close();
        }
        catch (IOException iOException) {}
    }

    public void serialize(XMLReader outerXMLReader) throws SAXException {
        new MessageXMLEncoder(outerXMLReader).encode(this);
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public static boolean isStoredMessage(String s) {
        if (s != null && s.startsWith(LEADING_XML) && s.length() > LEADING_XML.length()) {
            int endNdx = Math.min(s.length(), PUSHBACK_SIZE);
            int ndx = LEADING_XML.length();
            while (ndx < endNdx) {
                if (!Character.isWhitespace(s.charAt(ndx))) {
                    if (!s.regionMatches(ndx, LEADING_MESSAGES, 0, LEADING_MESSAGES.length()) || (ndx += LEADING_MESSAGES.length()) + 2 > endNdx || !Character.isWhitespace(s.charAt(ndx)) && s.charAt(ndx) != '>' && !s.regionMatches(ndx, "/>", 0, "/>".length())) break;
                    return true;
                }
                ++ndx;
            }
        }
        return false;
    }

    public static boolean isStoredMessage(PushbackReader pbr) throws IOException {
        char[] buffer = new char[PUSHBACK_SIZE];
        int read = pbr.read(buffer);
        try {
            boolean bl = read != -1 ? StoredMessage.isStoredMessage(new String(buffer, 0, read)) : false;
            return bl;
        }
        finally {
            if (read != -1) {
                pbr.unread(buffer, 0, read);
            }
        }
    }

    public boolean replaceNLSKey(String originalKey, String newKey) {
        for (Message message : this.messages) {
            this.replaceNLSKey(message, originalKey, newKey);
        }
        return true;
    }

    private void replaceNLSKey(Message m, String originalKey, String newKey) {
        if (m.getNlsKey().equals(originalKey)) {
            m.setNlsKey(newKey);
        }
        List<Object> values = m.getValues();
        for (Object v : values) {
            if (!(v instanceof Message)) continue;
            this.replaceNLSKey((Message)v, originalKey, newKey);
        }
    }

    public static StoredMessage createFromSerializedStoredMessage(String databaseString) {
        Exception t = null;
        if (UtilitiesCommon.isEmptyString(databaseString)) {
            return new StoredMessage();
        }
        if (StoredMessage.isStoredMessage(databaseString)) {
            try {
                return StoredMessage.createFromSerializedStoredMessage(new StringReader(databaseString));
            }
            catch (ParserConfigurationException e) {
                t = e;
            }
            catch (SAXException e) {
                t = e;
            }
            catch (IOException e) {
                t = e;
            }
        }
        StoredMessage.handleCreateError(databaseString, t);
        return new StoredMessage().addMessageString(databaseString).getStoredMessage();
    }

    private static void handleCreateError(String databaseString, Throwable t) {
        if (logger.isInfoEnabled() && t != null) {
            logger.info((Object)("Error creating a StoredMessage from String: " + databaseString + ". Creating default StoredMessage."), t);
        } else {
            logger.warn((Object)("Error creating a StoredMessage from String: " + databaseString + ". Creating default StoredMessage." + (t != null ? t.getMessage() : "")));
        }
    }

    /*
     * Exception decompiling
     */
    public static StoredMessage createFromSerializedReader(Reader rdr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static StoredMessage createFromSerializedStoredMessage(Reader rdr) throws ParserConfigurationException, SAXException, IOException {
        SAXParser p = null;
        try {
            p = SerializationHelper.getSAXParser();
            SerializationHelper.DeSerializationHandler<StoredMessage> handler = StoredMessage.getDefaultHandler();
            p.parse(new InputSource(rdr), (DefaultHandler)new SerializationHelper.DeserializationHandlerWrapper(handler));
            StoredMessage storedMessage = handler.getResult();
            return storedMessage;
        }
        finally {
            rdr.close();
            SerializationHelper.returnSAXParser(p);
        }
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    public class Message {
        private String nlsKey;
        private List<Object> values;
        private String bundleName;
        private String defaultValue;

        public Message(String nlsKey, List<?> values, String bundleName, String defaultValue) {
            this.nlsKey = nlsKey;
            this.bundleName = UtilitiesCommon.isEmptyString(bundleName) ? null : (!UtilitiesCommon.objectsEqual(bundleName, StoredMessage.this.getBundleName()) ? bundleName : null);
            this.defaultValue = defaultValue;
            if (values != null) {
                this.values = new ArrayList<Object>(values.size());
                for (Object value : values) {
                    this.values.add(this.getValue(value));
                }
            } else {
                this.values = new ArrayList<Object>(0);
            }
        }

        public Message(StoredMessage stm) {
            this(null, Collections.singletonList(stm), null, null);
        }

        private Object getValue(Object value) {
            if (value instanceof Throwable) {
                Throwable e = (Throwable)value;
                String msg = e.getLocalizedMessage();
                if (UtilitiesCommon.isEmptyString(msg) && UtilitiesCommon.isEmptyString(msg = e.getMessage())) {
                    msg = e.getClass().getName();
                }
                return msg;
            }
            if (value != null) {
                return value;
            }
            return "";
        }

        public Message(String nlsKey, List<?> values) {
            this(nlsKey, values, null, null);
        }

        public Message(String nlsKey, Object[] values, String bundleName, String defaultValue) {
            this(nlsKey, values != null ? Arrays.asList(values) : null, bundleName, defaultValue);
        }

        public Message(Class<? extends AbstractMessages> bundle, String nlsKey, String defaultValue, Object ... values) {
            this(nlsKey, values, bundle != null ? bundle.getName() : null, defaultValue);
        }

        public Message(String nlsKey, Object ... values) {
            this(nlsKey, values, null, null);
        }

        public Message(String msg, boolean dummy) {
            this(null, Collections.singletonList(msg), null, null);
        }

        public String getNlsKey() {
            return this.nlsKey;
        }

        public String getBundleName() {
            return this.bundleName;
        }

        String getRealizedBundleName() {
            if (UtilitiesCommon.isEmptyString(this.bundleName)) {
                return StoredMessage.this.getBundleName();
            }
            return this.bundleName;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public List<Object> getValues() {
            return this.values;
        }

        public void addValue(Object value) {
            this.values.add(this.getValue(value));
        }

        public Object setValue(int index, Object value) {
            return this.values.set(index, this.getValue(value));
        }

        public String setNlsKey(String newKey) {
            String originalKey = this.nlsKey;
            this.nlsKey = newKey;
            return originalKey;
        }

        public StoredMessage getStoredMessage() {
            return StoredMessage.this;
        }
    }

    private class MessageSource
    extends SerializationHelper.SerializeSource<StoredMessage> {
        private MessageSource() {
        }

        @Override
        public StoredMessage getSource() {
            return StoredMessage.this;
        }
    }

    private static class MessageXMLEncoder
    extends SerializationHelper.SerializeXMLEncoder<StoredMessage> {
        public MessageXMLEncoder() {
        }

        public MessageXMLEncoder(XMLReader xmlReader) {
            this.setXMLReader(xmlReader);
        }

        @Override
        public void encode(StoredMessage v) throws SAXException {
            AttributesImpl attrs = new AttributesImpl();
            if (!UtilitiesCommon.isEmptyString(v.getBundleName())) {
                attrs.addAttribute("", StoredMessage.CLASS_NAME_ATTR, StoredMessage.CLASS_NAME_ATTR, "CDATA", v.getBundleName());
            }
            this.getContentHandler().startElement("", StoredMessage.STORED_MESSAGE_TAGNAME, StoredMessage.STORED_MESSAGE_TAGNAME, attrs);
            for (Message m : v.messages) {
                this.encode(m, v);
            }
            this.getContentHandler().endElement("", StoredMessage.STORED_MESSAGE_TAGNAME, StoredMessage.STORED_MESSAGE_TAGNAME);
        }

        private void encode(Message msg, StoredMessage currentSTM) throws SAXException {
            AttributesImpl attrs = new AttributesImpl();
            if (!UtilitiesCommon.objectsEqual(currentSTM.getBundleName(), msg.getRealizedBundleName()) && !UtilitiesCommon.isEmptyString(msg.getRealizedBundleName())) {
                attrs.addAttribute("", StoredMessage.CLASS_NAME_ATTR, StoredMessage.CLASS_NAME_ATTR, "CDATA", msg.getRealizedBundleName());
            }
            if (msg.getDefaultValue() != null) {
                attrs.addAttribute("", StoredMessage.DEFAULT_VALUE, StoredMessage.DEFAULT_VALUE, "CDATA", msg.getDefaultValue());
            }
            if (!UtilitiesCommon.isEmptyString(msg.getNlsKey())) {
                attrs.addAttribute("", StoredMessage.NLS_KEY_ATTR, StoredMessage.NLS_KEY_ATTR, "CDATA", msg.getNlsKey());
            }
            this.getContentHandler().startElement("", StoredMessage.MESSAGE_TAGNAME, StoredMessage.MESSAGE_TAGNAME, attrs);
            for (Object v : msg.getValues()) {
                this.encodeVariable(v, currentSTM);
            }
            this.getContentHandler().endElement("", StoredMessage.MESSAGE_TAGNAME, StoredMessage.MESSAGE_TAGNAME);
        }

        private void encodeVariable(Object v, StoredMessage currentSTM) throws SAXException {
            this.getContentHandler().startElement("", StoredMessage.VARIABLE_TAGNAME, StoredMessage.VARIABLE_TAGNAME, new AttributesImpl());
            if (v instanceof Message) {
                this.encode((Message)v, currentSTM);
            } else if (v instanceof StoredMessage) {
                this.encode((StoredMessage)v);
            } else if (v instanceof Date) {
                this.encode((Date)v);
            } else {
                this.characters(String.valueOf(v));
            }
            this.getContentHandler().endElement("", StoredMessage.VARIABLE_TAGNAME, StoredMessage.VARIABLE_TAGNAME);
        }

        @Override
        private void encode(Date v) throws SAXException {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "date", "date", "CDATA", Long.toString(v.getTime()));
            this.getContentHandler().startElement("", "date", "date", attrs);
            this.getContentHandler().endElement("", "date", "date");
        }
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 194186022198849427L;
        private final String serializedSM;

        private SerializationProxy(StoredMessage sm) {
            this.serializedSM = sm.toString();
        }

        private Object readResolve() {
            return StoredMessage.createFromSerializedStoredMessage(this.serializedSM);
        }
    }
}

