/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import com.ibm.ram.common.util.InputStreamInformation;
import com.ibm.ram.common.util.RAMURLEncoder;

public class DownloadArtifactUtil {
    public static final int MAXIMUM_RANGE_SKIP_FAILURES = 3;
    public static final String INVALID_CHARACTERS = "\\/:*?\"<>|";

    public static String getContentDisposition(String fileName, String extension, String ua, InputStreamInformation isInfo, long skippedBytes, Boolean attachment) {
        boolean isMSIE = ua != null && ua.indexOf("MSIE") != -1;
        StringBuilder contentDisposition = new StringBuilder();
        if (attachment != null) {
            if (attachment.booleanValue()) {
                contentDisposition.append("attachment; ");
            } else {
                contentDisposition.append("inline; ");
            }
        }
        if (isInfo.isKnownSize()) {
            contentDisposition.append("size=");
            contentDisposition.append(isInfo.getSize());
            contentDisposition.append("; ");
        }
        contentDisposition.append("filename");
        if (fileName == null) {
            fileName = isInfo.getFilenameBase();
        }
        if (extension == null) {
            extension = isInfo.getFilenameExtension();
        }
        if (fileName != null) {
            if (DownloadArtifactUtil.containsNonAscii(fileName) && !isMSIE) {
                contentDisposition.append("*=UTF-8''");
                DownloadArtifactUtil.getFilename(contentDisposition, fileName);
                if (extension != null && extension.length() > 0) {
                    if (!extension.startsWith(".")) {
                        contentDisposition.append('.');
                    }
                    DownloadArtifactUtil.getFilename(contentDisposition, extension);
                }
            } else {
                contentDisposition.append("=\"");
                DownloadArtifactUtil.getFilename(contentDisposition, fileName);
                if (extension != null && extension.length() > 0) {
                    if (!extension.startsWith(".")) {
                        contentDisposition.append('.');
                    }
                    DownloadArtifactUtil.getFilename(contentDisposition, extension);
                }
                contentDisposition.append("\"");
            }
        }
        return contentDisposition.toString();
    }

    public static boolean includeContentLengthHeader(InputStreamInformation isInfo, boolean configurationManagerContentLengthOverTwoGBEnabled) {
        return DownloadArtifactUtil.includeContentLengthHeader(isInfo, isInfo.getSize(), configurationManagerContentLengthOverTwoGBEnabled);
    }

    public static boolean includeContentLengthHeader(InputStreamInformation isInfo, long size, boolean configurationManagerContentLengthOverTwoGBEnabled) {
        return !(isInfo != null && !isInfo.isExactSize() || !configurationManagerContentLengthOverTwoGBEnabled && size >= Integer.MAX_VALUE);
    }

    private static void getFilename(StringBuilder sb, String filename) {
        if (DownloadArtifactUtil.containsNonAscii(filename)) {
            String ret = RAMURLEncoder.encode(filename);
            sb.append(ret);
        } else {
            sb.append(filename);
        }
    }

    private static boolean containsNonAscii(String string) {
        boolean allASCII = true;
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if (ch > '\u007f' || INVALID_CHARACTERS.indexOf(ch) != -1) {
                allASCII = false;
            }
            ++i;
        }
        return !allASCII;
    }
}

