/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class JdkNeutralBase64Decoder {
    private static final String IBM_DECODER = "com.ibm.misc.BASE64Decoder";
    private static final String SUN_DECODER = "sun.misc.BASE64Decoder";

    public abstract byte[] decodeBuffer(String var1) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    public String decodeBufferAsString(String arg) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        try {
            return new String(this.decodeBuffer(arg), "UTF=8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(this.decodeBuffer(arg));
        }
    }

    public static JdkNeutralBase64Decoder newDecoder() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        try {
            Class<?> decoderClazz = Class.forName(IBM_DECODER);
            Object ibmDecoder = decoderClazz.newInstance();
            return new DecoderProxy(ibmDecoder);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> decoderClazz = Class.forName(SUN_DECODER);
            Object sunDecoder = decoderClazz.newInstance();
            return new DecoderProxy(sunDecoder);
        }
    }

    private static class DecoderProxy
    extends JdkNeutralBase64Decoder {
        private final Object ibmOrSunDecoder;
        private final Method decodeMethod;

        public DecoderProxy(Object decoder) throws SecurityException, NoSuchMethodException {
            this.ibmOrSunDecoder = decoder;
            this.decodeMethod = decoder.getClass().getMethod("decodeBuffer", String.class);
        }

        @Override
        public byte[] decodeBuffer(String arg) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return (byte[])this.decodeMethod.invoke(this.ibmOrSunDecoder, arg);
        }
    }
}

