/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import java.text.Collator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class SessionHandler
implements Cloneable {
    private static ThreadLocal<SessionHandler> threadSessionData = new ThreadLocal();
    private transient int threadUsageCnt;
    protected Locale locale;
    protected TimeZone timezone;
    protected Locale translatedLocale;
    protected List<Locale> requestLocales;

    public static SessionHandler getSessionHandler() {
        SessionHandler s = SessionHandler.primGetSessionHandler();
        if (s == null) {
            s = new SessionHandler();
            SessionHandler.setSessionHandler(s);
        }
        return s;
    }

    public boolean startForThread() {
        if (SessionHandler.primGetSessionHandler() == this) {
            return this.threadUsageCnt++ == 0;
        }
        return false;
    }

    public boolean endForThread() {
        if (SessionHandler.primGetSessionHandler() == this && --this.threadUsageCnt <= 0) {
            this.threadUsageCnt = 0;
            return this.removeSession();
        }
        return false;
    }

    protected static SessionHandler primGetSessionHandler() {
        return threadSessionData.get();
    }

    protected static void setSessionHandler(SessionHandler s) {
        threadSessionData.set(s);
    }

    protected SessionHandler() {
    }

    protected SessionHandler(SessionHandler fromHandler) {
        this.locale = fromHandler.locale;
    }

    public boolean removeSession() {
        if (SessionHandler.primGetSessionHandler() == this) {
            SessionHandler.setSessionHandler(null);
            return true;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        SessionHandler s = (SessionHandler)super.clone();
        s.threadUsageCnt = 0;
        return s;
    }

    public Locale setLocale(Locale locale) {
        Locale old = this.locale;
        this.locale = locale;
        return old;
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : Locale.getDefault();
    }

    public Collator getIgnoreCaseCollator() {
        Collator c = Collator.getInstance(this.getLocale());
        c.setStrength(0);
        return c;
    }

    public Locale resetLocale() {
        return this.setLocale(null);
    }

    public TimeZone setTimeZone(TimeZone timezone) {
        TimeZone old = this.timezone;
        this.timezone = timezone;
        return old;
    }

    public TimeZone getTimeZone() {
        return this.timezone != null ? this.timezone : TimeZone.getDefault();
    }

    public TimeZone resetTimeZone() {
        return this.setTimeZone(null);
    }

    public Locale getTranslatedLocale() {
        return this.translatedLocale;
    }

    public void setTranslatedLocale(Locale translatedLocale) {
        this.translatedLocale = translatedLocale;
    }

    public List<Locale> getRequestLocales() {
        return this.requestLocales;
    }

    public void setRequestLocales(List<Locale> locales) {
        this.requestLocales = locales;
    }
}

