/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.defaultprofile.Artifact;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class XmlParser {
    private Logger logger = Logger.getLogger(XmlParser.class);
    private static final String[] XML_EXTENSIONS = new String[]{".xml", ".wsdl", ".xsd", ".bpel", ".emx", ".rdf", ".xsl", ".xslt", ".xul", ".xhtml", ".ent", ".dtd", ".atom", ".owl", ".vxml", ".fo", ".rng", ".sch", ".svg", ".rss", ".plist", ".xht", ".mathml"};
    protected static final String WSDL_EXTENSION = ".wsdl";
    protected static final String XSD_EXTENSION = ".xsd";
    protected static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    protected static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    protected static final String DEFINITIONS_ELEMENT = "definitions";
    protected static final String SCHEMA_ELEMENT = "schema";
    protected static final String IMPORT_ELEMENT = "import";
    protected static final String INCLUDE_ELEMENT = "include";
    protected static final String NAMESPACE_ATTRIBUTE = "namespace";
    protected static final String LOCATION_ATTRIBUTE = "location";
    protected static final String SCHEMA_LOCATION_ATTRIBUTE = "schemaLocation";
    protected static final String TARGET_NAMESPACE_ATTRIBUTE = "targetNamespace";
    private Map<String, List<SuggestedRelationship>> filePathsMap = new HashMap<String, List<SuggestedRelationship>>();
    private String currentArtifactPath;
    private Map<String, SuggestedRelationship> suggestedRelationshipsMap = new HashMap<String, SuggestedRelationship>();

    protected void closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                this.logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected String extractFileName(String location) {
        int i;
        if (location != null && (i = location.lastIndexOf(47)) != -1) {
            return location.substring(i + 1);
        }
        return location;
    }

    protected abstract List<SuggestedRelationship> findSuggestions(String var1, String var2);

    protected abstract List<SuggestedRelationship> findSuggestions(String var1, String var2, String var3);

    protected String getCurrentArtifactPath() {
        return this.currentArtifactPath;
    }

    public List<SuggestedRelationship> getSuggestedRelationshipList() {
        return new ArrayList<SuggestedRelationship>(this.suggestedRelationshipsMap.values());
    }

    public static boolean isXml(String filename) {
        int dot = filename.lastIndexOf(46);
        if (dot > -1) {
            String ext = filename.substring(dot);
            int i = 0;
            while (i < XML_EXTENSIONS.length) {
                if (XML_EXTENSIONS[i].equals(ext)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void parseImport(Node node) {
        Attr schemaLocAttr;
        Attr locAttr;
        NamedNodeMap attributes = node.getAttributes();
        String namespace = null;
        String location = null;
        String elementPath = null;
        Attr nsAttr = (Attr)attributes.getNamedItem(NAMESPACE_ATTRIBUTE);
        if (nsAttr != null) {
            namespace = nsAttr.getNodeValue();
        }
        if ((locAttr = (Attr)attributes.getNamedItem(LOCATION_ATTRIBUTE)) != null) {
            location = locAttr.getNodeValue();
            elementPath = DEFINITIONS_ELEMENT;
        }
        if ((schemaLocAttr = (Attr)attributes.getNamedItem(SCHEMA_LOCATION_ATTRIBUTE)) != null) {
            location = schemaLocAttr.getNodeValue();
            elementPath = SCHEMA_ELEMENT;
        }
        this.addSuggestions(this.findSuggestions(namespace, location, elementPath));
    }

    private void parseInclude(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        String location = null;
        Attr schemaLocAttr = (Attr)attributes.getNamedItem(SCHEMA_LOCATION_ATTRIBUTE);
        if (schemaLocAttr != null) {
            location = schemaLocAttr.getNodeValue();
        }
        if (location != null) {
            this.addSuggestions(this.findSuggestions(null, location, null));
        }
    }

    protected void parseXML(InputStream in, String fileName) {
        if (in != null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setFeature("http://xml.org/sax/features/validation", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                DocumentBuilder documentBuilder = factory.newDocumentBuilder();
                Document document = documentBuilder.parse(in);
                String targetNamespace = document.getDocumentElement().getAttribute(TARGET_NAMESPACE_ATTRIBUTE);
                if (targetNamespace != null && targetNamespace.length() > 0) {
                    this.addSuggestions(this.findSuggestions(targetNamespace, fileName));
                }
                NodeList xsdImports = document.getElementsByTagNameNS(XSD_NAMESPACE, IMPORT_ELEMENT);
                int i = 0;
                while (i < xsdImports.getLength()) {
                    this.parseImport(xsdImports.item(i));
                    ++i;
                }
                NodeList xsdIncludes = document.getElementsByTagNameNS(XSD_NAMESPACE, INCLUDE_ELEMENT);
                int i2 = 0;
                while (i2 < xsdIncludes.getLength()) {
                    this.parseInclude(xsdIncludes.item(i2));
                    ++i2;
                }
                NodeList wsdlImports = document.getElementsByTagNameNS(WSDL_NAMESPACE, IMPORT_ELEMENT);
                int i3 = 0;
                while (i3 < wsdlImports.getLength()) {
                    this.parseImport(wsdlImports.item(i3));
                    ++i3;
                }
                NamedNodeMap attributes = document.getDocumentElement().getAttributes();
                int i4 = 0;
                while (i4 < attributes.getLength()) {
                    Attr attr = (Attr)attributes.item(i4);
                    if (attr.getName().startsWith("xmlns")) {
                        String namespace = attr.getValue();
                        this.addSuggestions(this.findSuggestions(namespace, null, SCHEMA_ELEMENT));
                    }
                    ++i4;
                }
            }
            catch (ParserConfigurationException e) {
                this.logger.info((Object)"XML Parse ignored", (Throwable)e);
            }
            catch (SAXException e) {
                this.logger.info((Object)"XML Parse ignored", (Throwable)e);
            }
            catch (IOException e) {
                this.logger.info((Object)"XML Parse ignored", (Throwable)e);
            }
        }
    }

    private void addSuggestions(List<SuggestedRelationship> suggestions) {
        if (suggestions != null && !suggestions.isEmpty()) {
            List<SuggestedRelationship> sugs = this.filePathsMap.get(this.currentArtifactPath);
            if (sugs == null) {
                sugs = new ArrayList<SuggestedRelationship>();
                this.filePathsMap.put(this.currentArtifactPath, sugs);
            }
            for (SuggestedRelationship sug : suggestions) {
                String key = String.valueOf(sug.getAssetGuid()) + "/" + sug.getAssetVersion();
                SuggestedRelationship suggestion = this.suggestedRelationshipsMap.get(key);
                if (suggestion == null) {
                    suggestion = sug;
                }
                this.suggestedRelationshipsMap.put(key, suggestion);
                suggestion.addArtifactPath(this.currentArtifactPath);
                sugs.add(suggestion);
            }
        }
    }

    public void remove(Artifact artifact, String path) {
        block4: {
            block3: {
                path = String.valueOf(path) + artifact.getName();
                if (!ManifestAccessor.isFolder(artifact)) break block3;
                Iterator<String> iter = this.filePathsMap.keySet().iterator();
                while (iter.hasNext()) {
                    String key = iter.next();
                    if (!key.startsWith(path)) continue;
                    for (SuggestedRelationship suggestion : this.filePathsMap.get(key)) {
                        suggestion.removeArtifactPath(key);
                        if (!suggestion.getArtifactPaths().isEmpty()) continue;
                        this.suggestedRelationshipsMap.remove(String.valueOf(suggestion.getAssetGuid()) + "/" + suggestion.getAssetVersion());
                    }
                    iter.remove();
                }
                break block4;
            }
            List<SuggestedRelationship> suggestionList = this.filePathsMap.remove(path);
            if (suggestionList == null) break block4;
            for (SuggestedRelationship suggestion : suggestionList) {
                suggestion.removeArtifactPath(path);
                if (!suggestion.getArtifactPaths().isEmpty()) continue;
                this.suggestedRelationshipsMap.remove(String.valueOf(suggestion.getAssetGuid()) + "/" + suggestion.getAssetVersion());
            }
        }
    }

    protected void setCurrentArtifactPath(String currentPath) {
        this.currentArtifactPath = currentPath;
    }

    public static class SuggestedRelationship {
        private String assetName;
        private String assetGuid;
        private String assetVersion;
        private String resourceUri;
        private List<String> artifactPaths = new ArrayList<String>();

        public SuggestedRelationship() {
        }

        public SuggestedRelationship(String assetName, String assetGuid, String assetVersion) {
            this(assetName, assetGuid, assetVersion, null);
        }

        public SuggestedRelationship(String assetName, String assetGuid, String assetVersion, String resourceURI) {
            this.setAssetName(assetName);
            this.setAssetGuid(assetGuid);
            this.setAssetVersion(assetVersion);
            this.setResourceUri(resourceURI);
        }

        public void addArtifactPath(String path) {
            if (!this.getArtifactPaths().contains(path)) {
                this.getArtifactPaths().add(path);
            }
        }

        public String getAssetGuid() {
            return this.assetGuid;
        }

        public String getAssetName() {
            return this.assetName;
        }

        public String getAssetVersion() {
            return this.assetVersion;
        }

        public void removeArtifactPath(String path) {
            this.getArtifactPaths().remove(path);
        }

        public void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        public void setAssetGuid(String assetGuid) {
            this.assetGuid = assetGuid;
        }

        public void setAssetVersion(String assetVersion) {
            this.assetVersion = assetVersion;
        }

        public void setArtifactPaths(List<String> artifactPaths) {
            this.artifactPaths = artifactPaths;
        }

        public List<String> getArtifactPaths() {
            return this.artifactPaths;
        }

        public void setResourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
        }

        public String getResourceUri() {
            return this.resourceUri;
        }
    }
}

