/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.jaxb.util;

import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.UserGroupInformation;
import com.ibm.ram.common.data.UserInformation;
import com.ibm.ram.common.util.RAMURLDecoder;
import com.ibm.ram.common.util.RAMURLEncoder;
import com.ibm.ram.internal.jaxb.Action;
import com.ibm.ram.internal.jaxb.Artifact;
import com.ibm.ram.internal.jaxb.Asset;
import com.ibm.ram.internal.jaxb.AssetAttribute;
import com.ibm.ram.internal.jaxb.AssetType;
import com.ibm.ram.internal.jaxb.CategorySchema;
import com.ibm.ram.internal.jaxb.Comment;
import com.ibm.ram.internal.jaxb.Community;
import com.ibm.ram.internal.jaxb.Error;
import com.ibm.ram.internal.jaxb.ExitCondition;
import com.ibm.ram.internal.jaxb.Lifecycle;
import com.ibm.ram.internal.jaxb.Link;
import com.ibm.ram.internal.jaxb.ObjectFactory;
import com.ibm.ram.internal.jaxb.Policy;
import com.ibm.ram.internal.jaxb.PolicyResult;
import com.ibm.ram.internal.jaxb.RelationshipLink;
import com.ibm.ram.internal.jaxb.SearchResult;
import com.ibm.ram.internal.jaxb.SearchResultEntry;
import com.ibm.ram.internal.jaxb.SimpleLiteral;
import com.ibm.ram.internal.jaxb.State;
import com.ibm.ram.internal.jaxb.StateConfiguration;
import com.ibm.ram.internal.jaxb.StateHistory;
import com.ibm.ram.internal.jaxb.User;
import com.ibm.ram.internal.jaxb.UserGroup;
import com.ibm.ram.internal.jaxb.Vote;
import com.ibm.ram.internal.jaxb.VoteChoice;
import com.ibm.ram.internal.jaxb.Workflow;
import com.ibm.ram.internal.jaxb.atom.ContentType;
import com.ibm.ram.internal.jaxb.atom.DateTimeType;
import com.ibm.ram.internal.jaxb.atom.EntryType;
import com.ibm.ram.internal.jaxb.atom.FeedType;
import com.ibm.ram.internal.jaxb.atom.GeneratorType;
import com.ibm.ram.internal.jaxb.atom.IdType;
import com.ibm.ram.internal.jaxb.atom.LinkType;
import com.ibm.ram.internal.jaxb.atom.PersonType;
import com.ibm.ram.internal.jaxb.atom.TextType;
import com.ibm.ram.internal.jaxb.util.ArtifactPropOptions;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import com.ibm.ram.internal.jaxb.util.RAMJaxbNameSpaceMapper;
import com.ibm.ram.internal.json.JsonUtil;
import com.ibm.ram.internal.rest.RestContext;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.oslc.asset.internal.Resource;
import org.oslc.asset.internal.ResourceRef;

public class JAXButil {
    public static final String RAMfeedID = "RAM 7.x";
    private static JAXBContext context = null;
    private static DatatypeFactory DATE_TYPE_FACTORY;

    private static synchronized DatatypeFactory getDateTypeFactory() throws DatatypeConfigurationException {
        if (DATE_TYPE_FACTORY == null) {
            DATE_TYPE_FACTORY = DatatypeFactory.newInstance();
        }
        return DATE_TYPE_FACTORY;
    }

    public static Marshaller getXMLMarshaller(String defaultNameSpace) throws JAXBException {
        JAXBContext jc = JAXButil.getJAXBContext();
        Marshaller xmlMarshaller = jc.createMarshaller();
        xmlMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        xmlMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        xmlMarshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new RAMJaxbNameSpaceMapper());
        return xmlMarshaller;
    }

    public static Marshaller getXMLMarshaller() throws JAXBException {
        JAXBContext jc = JAXButil.getJAXBContext();
        Marshaller xmlMarshaller = jc.createMarshaller();
        xmlMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        xmlMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        xmlMarshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new RAMJaxbNameSpaceMapper());
        return xmlMarshaller;
    }

    public static Marshaller getWMLMarshaller(String defaultNameSpace) throws JAXBException {
        JAXBContext jc = JAXButil.getJAXBContext();
        Marshaller xmlMarshaller = jc.createMarshaller();
        xmlMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        xmlMarshaller.setProperty("jaxb.encoding", (Object)"Cp1252");
        xmlMarshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new RAMJaxbNameSpaceMapper());
        return xmlMarshaller;
    }

    public static boolean isEmptyString(String teststring) {
        return teststring == null || teststring.length() == 0;
    }

    public static Unmarshaller getXMLunMarshaller() throws JAXBException {
        JAXBContext jc = JAXButil.getJAXBContext();
        Unmarshaller xmlUnMarshaller = jc.createUnmarshaller();
        return xmlUnMarshaller;
    }

    private static synchronized JAXBContext getJAXBContext() throws JAXBException {
        if (context == null) {
            JAXBContext ret;
            context = ret = JAXBContext.newInstance((String)"org.oslc.asset.internal:com.ibm.ram.internal.jaxb.atom:com.ibm.ram.internal.jaxb", (ClassLoader)JAXButil.class.getClassLoader());
        }
        return context;
    }

    private static IdType getFeedID(String feedURL, Calendar update) {
        SimpleDateFormat formatter = new SimpleDateFormat();
        IdType id = new IdType();
        id.setValue("RAM 7.x [" + feedURL + "] - " + formatter.format(update.getTime()));
        return id;
    }

    public static FeedType createAtomFeed(List<JAXBElement<Resource>> elements, String title, String about, String base, List<LinkType> otherLinks, Map<QName, String> otherAttributes) {
        EntryType[] aEntries = new EntryType[elements.size()];
        int i = 0;
        for (JAXBElement<Resource> element : elements) {
            aEntries[i++] = JAXButil.createAtomEntry(element);
        }
        return JAXButil.createAtomFeed(aEntries, title, about, base, null, otherLinks, otherAttributes);
    }

    public static FeedType createAtomFeed(StateHistory[] histories, String feedURL, String base) {
        EntryType[] aEntries = new EntryType[histories.length];
        int i = 0;
        while (i < histories.length) {
            StateHistory history = histories[i];
            Link<StateHistory> ref = JAXBLinksUtil.getLink(history);
            EntryType entry = new EntryType();
            entry.setBase(base);
            LinkType link = new LinkType();
            link.setHref(ref.getHref());
            link.setRel("alternate");
            link.setType("text/xml");
            entry.getLink().add(link);
            ContentType content = new ContentType();
            content.setBase(base);
            JAXBElement<StateHistory> historyElement = new ObjectFactory().createStateHistory(history);
            content.getContent().add(historyElement);
            entry.setContent(content);
            IdType id = new IdType();
            id.setValue(history.getIdentifier());
            entry.setId(id);
            TextType sum = new TextType();
            int approved = 0;
            int rejected = 0;
            int poliyResults = 0;
            for (Vote vote : history.getVotes()) {
                if (vote.isWithdrawn()) continue;
                if (VoteChoice.APPROVE.equals(vote.getChoice().getValue())) {
                    ++approved;
                    continue;
                }
                if (!VoteChoice.REJECT.equals(vote.getChoice().getValue())) continue;
                ++rejected;
            }
            for (PolicyResult pResult : history.getPolicyResults()) {
                if (pResult.isObsolete()) continue;
                ++poliyResults;
            }
            StringBuffer summary = new StringBuffer("<table border=\"0\"><tbody><tr><th>Approved (");
            summary.append(approved);
            summary.append(")</th><th>Rejected (");
            summary.append(rejected);
            summary.append(")</th><th>Policy Results (");
            summary.append(poliyResults);
            summary.append(")</th></tr></tbody></table>");
            sum.getContent().add(summary.toString());
            sum.setType("html");
            entry.setSummary(sum);
            TextType title = new TextType();
            title.getContent().add("History in state : " + history.getStateConfiguration().getState().getTitle().getContent() + " " + history.getStartDate());
            entry.setTitle(title);
            aEntries[i] = entry;
            ++i;
        }
        XMLGregorianCalendar l = JAXButil.getXMLCalendar(Calendar.getInstance().getTime());
        FeedType ft = JAXButil.createAtomFeed(aEntries, "Review Histories Feed", feedURL, base, l);
        return ft;
    }

    public static FeedType createCommentsAtomFeed(StateHistory history, String feedURL, String baseURI) {
        Link<StateHistory> link = JAXBLinksUtil.getLink(history);
        return JAXButil.createCommentsAtomFeed(link, feedURL, baseURI);
    }

    public static FeedType createCommentsAtomFeed(Link<StateHistory> historyRef, String feedURL, String baseURI) {
        List<Vote> votes;
        StateHistory history = historyRef.getValue();
        ArrayList<Object> allComments = new ArrayList<Object>();
        List<Link<Comment>> comments = history.getComments();
        if (comments != null && comments.size() > 0) {
            for (Link<Comment> link : comments) {
                Comment comment = link.getValue();
                allComments.add(comment);
            }
        }
        if ((votes = history.getVotes()) != null && votes.size() > 0) {
            for (Vote vote : votes) {
                if (vote.getComment() == null) continue;
                allComments.add(vote.getComment().getValue());
            }
        }
        EntryType[] aEntries = new EntryType[allComments.size()];
        int i = 0;
        while (i < allComments.size()) {
            Comment comment = (Comment)allComments.get(i);
            Link<Comment> ref = JAXBLinksUtil.getLink(historyRef, comment);
            EntryType entry = new EntryType();
            entry.setBase(baseURI);
            LinkType link = new LinkType();
            link.setHref(ref.getHref());
            link.setRel("alternate");
            link.setType("text/xml");
            entry.getLink().add(link);
            ContentType content = new ContentType();
            content.setBase(baseURI);
            JAXBElement<Comment> commentElement = new ObjectFactory().createComment(comment);
            content.getContent().add(commentElement);
            entry.setContent(content);
            IdType id = new IdType();
            id.setValue(comment.getIdentifier());
            entry.setId(id);
            TextType sum = new TextType();
            sum.getContent().add(comment.getBody());
            if (comment.isHTML()) {
                sum.setType("html");
            }
            entry.setSummary(sum);
            TextType title = new TextType();
            title.getContent().add("Comment from " + JAXButil.toString(comment.getSubmitter().getTitle()) + " at " + comment.getLastModified());
            entry.setTitle(title);
            aEntries[i] = entry;
            ++i;
        }
        ArrayList<LinkType> links = new ArrayList<LinkType>();
        LinkType link = new LinkType();
        link.setHref(historyRef.getHref());
        link.setRel("up");
        link.setTitle("State History");
        links.add(link);
        link = new LinkType();
        link.setHref(String.valueOf(baseURI) + "mobile/postComment.jsp?commentsUrl=../" + JAXBLinksUtil.getCommentsLink(historyRef).getHref());
        link.setRel("postForm");
        link.setTitle("Add Comment");
        links.add(link);
        XMLGregorianCalendar l = JAXButil.getXMLCalendar(Calendar.getInstance().getTime());
        FeedType ft = JAXButil.createAtomFeed(aEntries, "Comment Feed", feedURL, baseURI, l, links, Collections.EMPTY_MAP);
        return ft;
    }

    public static FeedType createAtomFeed(SearchResult sr, String feedName, String feedURL, Calendar lastUpdated, String base, RestContext.SerializationFormat sf) {
        FeedType feed = JAXButil.createFeedType(feedURL, feedName, JAXButil.getXMLCalendar(lastUpdated.getTime()), base);
        XMLGregorianCalendar d = null;
        int i = 0;
        while (i < sr.getAssetEntry().size()) {
            EntryType entry = JAXButil.createAtomEntry(sr.getAssetEntry().get(i), base, sf);
            if (entry.getUpdated() != null) {
                if (d == null) {
                    d = entry.getUpdated().getValue();
                } else if (entry.getUpdated().getValue().compare(d) > 0) {
                    d = entry.getUpdated().getValue();
                }
            }
            feed.getEntry().add(entry);
            ++i;
        }
        if (d == null) {
            d = JAXButil.getXMLCalendar(Calendar.getInstance().getTime());
        }
        feed.getUpdated().setValue(d);
        sr.getAssetEntry().clear();
        feed.getAny().add(new ObjectFactory().createSearchResult(sr));
        return feed;
    }

    public static String encodeURL(String url) {
        StringTokenizer st;
        StringBuffer s = new StringBuffer();
        try {
            URL u = new URL(url);
            String p = u.getPath();
            if (p.length() > 0) {
                int idx = url.indexOf(p);
                s.append(url.substring(0, idx));
            }
            st = new StringTokenizer(p, "/");
        }
        catch (MalformedURLException malformedURLException) {
            st = new StringTokenizer(url, "/");
        }
        while (st.hasMoreElements()) {
            s.append("/");
            s.append(RAMURLEncoder.encode(st.nextToken()));
        }
        return s.toString();
    }

    public static FeedType createAtomFeed(EntryType[] entries, String feedName, String feedURL, String base, XMLGregorianCalendar lastUpdated) {
        return JAXButil.createAtomFeed(entries, feedName, feedURL, base, lastUpdated, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
    }

    public static FeedType createAtomFeed(EntryType[] entries, String feedName, String feedURL, String base, XMLGregorianCalendar lastUpdated, List<LinkType> links, Map<QName, String> otherAttributes) {
        FeedType feed = JAXButil.createFeedType(feedURL, feedName, lastUpdated, base, links, otherAttributes);
        XMLGregorianCalendar d = null;
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getUpdated() != null && entries[i].getUpdated().getValue() != null) {
                if (d == null) {
                    d = entries[i].getUpdated().getValue();
                } else if (entries[i].getUpdated().getValue().compare(d) > 0) {
                    d = entries[i].getUpdated().getValue();
                }
            }
            ++i;
        }
        if (d == null) {
            d = JAXButil.getXMLCalendar(Calendar.getInstance().getTime());
        }
        if (feed.getUpdated() == null) {
            feed.setUpdated(new DateTimeType());
        }
        feed.getUpdated().setValue(d);
        i = 0;
        while (i < entries.length) {
            feed.getEntry().add(entries[i]);
            ++i;
        }
        return feed;
    }

    public static FeedType createFeedType(String url, String name, XMLGregorianCalendar update, String base) {
        return JAXButil.createFeedType(url, name, update, base, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
    }

    public static FeedType createFeedType(String url, String name, XMLGregorianCalendar update, String base, List<LinkType> otherLinks, Map<QName, String> otherAttributes) {
        LinkType link2;
        FeedType feed = new FeedType();
        String server = "";
        try {
            URL u = new URL(url);
            server = u.getHost();
        }
        catch (MalformedURLException malformedURLException) {}
        GeneratorType gen = new GeneratorType();
        gen.setValue("RAM 7.x:(" + server + ")");
        feed.setGenerator(gen);
        TextType tt = new TextType();
        tt.getContent().add(name);
        feed.setTitle(tt);
        url = JAXButil.encodeURL(url);
        if (update != null) {
            feed.setId(JAXButil.getFeedID(url, JAXButil.getCalendar(update)));
        }
        feed.setBase(base);
        if (url.endsWith(".wml")) {
            link2 = new LinkType();
            link2.setHref(url);
            link2.setRel("self");
            link2.setType("application/xhtml+xml");
            feed.getLink().add(link2);
            LinkType link = new LinkType();
            String xmlURL = String.valueOf(JAXBLinksUtil.removeExtension(url)) + ".xml";
            link.setHref(xmlURL);
            link.setRel("alternate");
            link.setType("text/xml");
            feed.getLink().add(link);
        } else {
            link2 = new LinkType();
            link2.setHref(url);
            link2.setRel("self");
            link2.setType("text/xml");
            feed.getLink().add(link2);
            LinkType link3 = new LinkType();
            String wapURL = String.valueOf(JAXBLinksUtil.removeExtension(url)) + ".wml";
            link3.setHref(wapURL);
            link3.setRel("alternate");
            link3.setType("application/xhtml+xml");
            feed.getLink().add(link3);
        }
        LinkType link4 = new LinkType();
        String jsonURL = String.valueOf(JAXBLinksUtil.removeExtension(url)) + ".json";
        link4.setHref(jsonURL);
        link4.setRel("alternate");
        link4.setType("application/json");
        feed.getLink().add(link4);
        if (otherLinks != null && !otherLinks.isEmpty()) {
            feed.getLink().addAll(otherLinks);
        }
        if (otherAttributes != null && !otherAttributes.isEmpty()) {
            feed.getOtherAttributes().putAll(otherAttributes);
        }
        if (update != null) {
            DateTimeType dt = new DateTimeType();
            dt.setValue(update);
            feed.setUpdated(dt);
        }
        return feed;
    }

    public static CommunityInformation getCommonCommunity(Community community) {
        CommunityInformation commonCommunity = new CommunityInformation();
        commonCommunity.setId(community.getDbid());
        commonCommunity.setName(community.getName());
        commonCommunity.setDescription(community.getDescription());
        return commonCommunity;
    }

    public static CommunityInformation getCommonCommunity(Link<Community> communityRef) {
        if (communityRef.getValue() == null) {
            CommunityInformation commonCommunity = new CommunityInformation();
            commonCommunity.setId(Integer.parseInt(JAXBLinksUtil.getCommunityIdentifier(communityRef)));
            commonCommunity.setName(JAXButil.toString(communityRef.getTitle()));
            return commonCommunity;
        }
        return JAXButil.getCommonCommunity(communityRef.getValue());
    }

    public static Community getCommunity(CommunityInformation commonCommunity) {
        Community community = new Community();
        community.setDbid(commonCommunity.getId());
        community.setIdentifier(Integer.toString(commonCommunity.getId()));
        community.setName(community.getName());
        community.setDescription(community.getDescription());
        return community;
    }

    public static User getUser(UserInformation iUser) {
        User user = new User();
        user.setAnonymous(iUser.isAnonymous());
        user.setEmail(iUser.getEmail());
        user.setIdentifier(iUser.getUid());
        if (iUser.getImageURL() != null && iUser.getImageURL().startsWith("/")) {
            user.setImageURL(iUser.getImageURL().substring(1));
        } else {
            user.setImageURL(iUser.getImageURL());
        }
        user.setName(iUser.getName());
        user.setPhone(iUser.getPhone());
        user.setRegistered(iUser.isRegistered());
        return user;
    }

    public static UserInformation getUser(User iUser) {
        UserInformation user = new UserInformation();
        user.setAnonymous(iUser.isAnonymous());
        user.setEmail(iUser.getEmail());
        user.setUid(iUser.getIdentifier());
        user.setImageURL(iUser.getImageURL());
        user.setName(iUser.getName());
        user.setPhone(iUser.getPhone());
        user.setRegistered(iUser.isRegistered());
        return user;
    }

    public static UserGroup getUserGroup(UserGroupInformation iUserGroup) {
        UserGroup userGroup = new UserGroup();
        userGroup.setName(iUserGroup.getName());
        userGroup.setIdentifier(Integer.toString(iUserGroup.getId()));
        Community community = new Community();
        community.setName(iUserGroup.getCommunity().getName());
        Link<Community> link = new Link<Community>();
        link.setValue(community);
        userGroup.setCommunity(link);
        return userGroup;
    }

    public static EntryType createAtomEntry(JAXBElement<Resource> element) {
        EntryType entry = new EntryType();
        Resource resource = (Resource)element.getValue();
        entry.setBase(resource.getBase());
        TextType t = new TextType();
        t.getContent().add(resource.getTitle());
        entry.setTitle(t);
        LinkType self = new LinkType();
        self.setHref(resource.getAbout());
        self.setRel("self");
        self.setType("application/xml");
        entry.getLink().add(self);
        LinkType alt = new LinkType();
        alt.setHref(resource.getAbout());
        alt.setRel("alternate");
        alt.setType("text/xml");
        entry.getLink().add(alt);
        ContentType content = new ContentType();
        content.setBase(resource.getBase());
        content.setType("application/xml");
        content.getContent().add(element);
        entry.setContent(content);
        return entry;
    }

    public static EntryType createAtomEntry(User user, String base) {
        EntryType entry = new EntryType();
        if (base != null) {
            entry.setBase(base);
        }
        Link<User> uLink = JAXBLinksUtil.getLink(user);
        LinkType link = new LinkType();
        link.setHref(uLink.getHref());
        link.setRel("alternate");
        link.setType("text/xml");
        entry.getLink().add(link);
        IdType id = new IdType();
        id.setValue(user.getIdentifier());
        entry.setId(id);
        TextType t = new TextType();
        t.getContent().add(user.getName());
        entry.setTitle(t);
        DateTimeType dt = new DateTimeType();
        dt.setValue(user.getLastModified());
        entry.setUpdated(dt);
        TextType summary = new TextType();
        summary.getContent().add("email: " + user.getEmail() + ", phone: " + user.getPhone());
        entry.setSummary(summary);
        ContentType content = new ContentType();
        content.setBase(base);
        content.setType("application/xml");
        content.getContent().add(new ObjectFactory().createUser(user));
        entry.setContent(content);
        return entry;
    }

    public static EntryType createAtomEntry(CategorySchema schema, String base) {
        EntryType entry = new EntryType();
        if (base != null) {
            entry.setBase(base);
        }
        Link<CategorySchema> sLink = JAXBLinksUtil.getLink(schema);
        LinkType link = new LinkType();
        link.setHref(sLink.getHref());
        link.setRel("alternate");
        link.setType("text/xml");
        entry.getLink().add(link);
        IdType id = new IdType();
        id.setValue(schema.getIdentifier());
        entry.setId(id);
        TextType t = new TextType();
        t.getContent().add(schema.getName());
        entry.setTitle(t);
        DateTimeType dt = new DateTimeType();
        dt.setValue(schema.getLastModified());
        entry.setUpdated(dt);
        TextType summary = new TextType();
        summary.getContent().add(schema.getDescription());
        entry.setSummary(summary);
        ContentType content = new ContentType();
        content.setBase(base);
        content.setType("application/xml");
        content.getContent().add(new ObjectFactory().createCategorySchema(schema));
        entry.setContent(content);
        return entry;
    }

    public static EntryType createAtomEntry(AssetAttribute attribute, String base) {
        EntryType entry = new EntryType();
        if (base != null) {
            entry.setBase(base);
        }
        Link<AssetAttribute> aLink = JAXBLinksUtil.getLink(attribute);
        LinkType link = new LinkType();
        link.setHref(aLink.getHref());
        link.setRel("alternate");
        link.setType("text/xml");
        entry.getLink().add(link);
        IdType id = new IdType();
        id.setValue(attribute.getIdentifier());
        entry.setId(id);
        TextType t = new TextType();
        t.getContent().add(attribute.getName());
        entry.setTitle(t);
        DateTimeType dt = new DateTimeType();
        dt.setValue(attribute.getLastModified());
        entry.setUpdated(dt);
        TextType summary = new TextType();
        summary.getContent().add(attribute.getDescription());
        entry.setSummary(summary);
        ContentType content = new ContentType();
        content.setBase(base);
        content.setType("application/xml");
        content.getContent().add(new ObjectFactory().createAssetAttribute(attribute));
        entry.setContent(content);
        return entry;
    }

    public static EntryType createAtomEntry(AssetType type, String base) {
        EntryType entry = new EntryType();
        if (base != null) {
            entry.setBase(base);
        }
        Link<AssetType> tLink = JAXBLinksUtil.getLink(type);
        LinkType link = new LinkType();
        link.setHref(tLink.getHref());
        link.setRel("alternate");
        link.setType("text/xml");
        entry.getLink().add(link);
        IdType id = new IdType();
        id.setValue(type.getIdentifier());
        entry.setId(id);
        TextType t = new TextType();
        t.getContent().add(type.getName());
        entry.setTitle(t);
        DateTimeType dt = new DateTimeType();
        dt.setValue(type.getLastModified());
        entry.setUpdated(dt);
        TextType summary = new TextType();
        summary.getContent().add(type.getDescription());
        entry.setSummary(summary);
        ContentType content = new ContentType();
        content.setBase(base);
        content.setType("application/xml");
        content.getContent().add(new ObjectFactory().createAssetType(type));
        entry.setContent(content);
        return entry;
    }

    public static EntryType createAtomEntry(Community community, String base) {
        EntryType entry = new EntryType();
        if (base != null) {
            entry.setBase(base);
        }
        Link<Community> cLink = JAXBLinksUtil.getLink(community);
        LinkType link = new LinkType();
        link.setHref(cLink.getHref());
        link.setRel("alternate");
        link.setType("text/xml");
        entry.getLink().add(link);
        IdType id = new IdType();
        id.setValue(community.getIdentifier());
        entry.setId(id);
        TextType t = new TextType();
        t.getContent().add(community.getName());
        entry.setTitle(t);
        DateTimeType dt = new DateTimeType();
        dt.setValue(community.getLastModified());
        entry.setUpdated(dt);
        TextType summary = new TextType();
        summary.getContent().add(community.getDescription());
        entry.setSummary(summary);
        ContentType content = new ContentType();
        content.setBase(base);
        content.setType("application/xml");
        content.getContent().add(new ObjectFactory().createCommunity(community));
        entry.setContent(content);
        return entry;
    }

    public static EntryType createAtomEntry(UserGroup userGroup, String base) {
        EntryType entry = new EntryType();
        if (base != null) {
            entry.setBase(base);
        }
        Link<UserGroup> uLink = JAXBLinksUtil.getLink(userGroup);
        LinkType link = new LinkType();
        link.setHref(uLink.getHref());
        link.setRel("alternate");
        link.setType("text/xml");
        entry.getLink().add(link);
        IdType id = new IdType();
        id.setValue(userGroup.getIdentifier());
        entry.setId(id);
        TextType t = new TextType();
        t.getContent().add(userGroup.getName());
        entry.setTitle(t);
        DateTimeType dt = new DateTimeType();
        dt.setValue(userGroup.getLastModified());
        entry.setUpdated(dt);
        TextType summary = new TextType();
        summary.getContent().add(userGroup.getDescription());
        entry.setSummary(summary);
        ContentType content = new ContentType();
        content.setBase(base);
        content.setType("application/xml");
        content.getContent().add(new ObjectFactory().createUserGroup(userGroup));
        entry.setContent(content);
        return entry;
    }

    public static EntryType createAtomEntry(Policy policy, String base) {
        EntryType entry = new EntryType();
        if (base != null) {
            entry.setBase(base);
        }
        Link<Policy> pLink = JAXBLinksUtil.getLink(policy);
        LinkType link = new LinkType();
        link.setHref(pLink.getHref());
        link.setRel("alternate");
        link.setType("text/xml");
        entry.getLink().add(link);
        IdType id = new IdType();
        id.setValue(policy.getIdentifier());
        entry.setId(id);
        TextType sum = new TextType();
        sum.getContent().add(policy.getDescription());
        entry.setSummary(sum);
        TextType t = new TextType();
        t.getContent().add(policy.getName());
        entry.setTitle(t);
        DateTimeType dt = new DateTimeType();
        dt.setValue(policy.getLastModified());
        entry.setUpdated(dt);
        ContentType content = new ContentType();
        content.setBase(base);
        content.setType("application/xml");
        content.getContent().add(new ObjectFactory().createPolicy(policy));
        entry.setContent(content);
        return entry;
    }

    public static EntryType createAtomEntry(Asset asset, Artifact artifact, String base, String extension) {
        EntryType entry = new EntryType();
        if (base != null) {
            entry.setBase(base);
        }
        Link<Asset> assetRef = JAXBLinksUtil.getLink(asset);
        Link<Artifact> aLink = JAXBLinksUtil.getLink(assetRef, artifact);
        LinkType link = new LinkType();
        link.setHref(aLink.getHref());
        link.setRel("alternate");
        link.setType("text/xml");
        entry.getLink().add(link);
        IdType id = new IdType();
        String idString = JAXButil.isEmptyString(artifact.getPath()) ? artifact.getName() : String.valueOf(artifact.getPath()) + "/" + artifact.getName();
        id.setValue(idString);
        entry.setId(id);
        TextType sum = new TextType();
        if (artifact.getLabel() != null) {
            sum.getContent().add(String.valueOf(artifact.getName()) + " - " + artifact.getLabel());
        } else {
            sum.getContent().add(artifact.getName());
        }
        entry.setSummary(sum);
        TextType t = new TextType();
        t.getContent().add(artifact.getPath());
        entry.setTitle(t);
        DateTimeType dt = new DateTimeType();
        dt.setValue(artifact.getLastModified());
        entry.setUpdated(dt);
        ContentType content = new ContentType();
        content.setBase(base);
        content.setType("application/xml");
        content.getContent().add(new ObjectFactory().createArtifact(artifact));
        entry.setContent(content);
        return entry;
    }

    public static EntryType createAtomEntry(Lifecycle lifecycle, String base) {
        Link<Lifecycle> jaxLink = JAXBLinksUtil.getLink(lifecycle.getCommunity(), lifecycle);
        return JAXButil.createAtomEntry(jaxLink, base);
    }

    public static EntryType createAtomEntry(Link<Lifecycle> jaxLink, String base) {
        EntryType entry = new EntryType();
        if (base != null) {
            entry.setBase(base);
        }
        LinkType link = new LinkType();
        link.setHref(jaxLink.getHref());
        link.setRel("alternate");
        link.setType("text/xml");
        entry.getLink().add(link);
        IdType id = new IdType();
        id.setValue(JAXBLinksUtil.getLifecycleIdentifier(jaxLink));
        entry.setId(id);
        TextType title = new TextType();
        title.getContent().add(jaxLink.getTitle().toString());
        entry.setTitle(title);
        Lifecycle lifecycle = jaxLink.getValue();
        if (lifecycle != null) {
            TextType sum = new TextType();
            sum.getContent().add(lifecycle.getDescription());
            entry.setSummary(sum);
            DateTimeType dt = new DateTimeType();
            dt.setValue(lifecycle.getLastModified());
            entry.setUpdated(dt);
            ContentType content = new ContentType();
            content.setBase(base);
            content.setType("application/xml");
            content.getContent().add(new ObjectFactory().createLifecyle(lifecycle));
            entry.setContent(content);
        }
        return entry;
    }

    public static EntryType createAtomEntry(Workflow workflow, String base) {
        EntryType entry = new EntryType();
        if (base != null) {
            entry.setBase(base);
        }
        LinkType link = new LinkType();
        link.setHref("/internal/workflows/" + workflow.getIdentifier());
        link.setRel("alternate");
        link.setType("text/xml");
        entry.getLink().add(link);
        IdType id = new IdType();
        id.setValue(workflow.getIdentifier());
        entry.setId(id);
        TextType sum = new TextType();
        sum.getContent().add(workflow.getDescription());
        entry.setSummary(sum);
        TextType t = new TextType();
        t.getContent().add(workflow.getName());
        entry.setTitle(t);
        ContentType content = new ContentType();
        content.setBase(base);
        content.setType("application/xml");
        JAXBElement<Workflow> workflowElement = new ObjectFactory().createWorkflow(workflow);
        content.getContent().add(workflowElement);
        entry.setContent(content);
        return entry;
    }

    public static EntryType createAtomEntry(SearchResultEntry re, String base, RestContext.SerializationFormat sf) {
        EntryType entry = new EntryType();
        if (base != null) {
            entry.setBase(base);
        }
        if (sf != RestContext.SerializationFormat.WML) {
            LinkType link = new LinkType();
            link.setHref(re.getAsset().getHtmlRef());
            link.setRel("self");
            link.setType("text/html");
            entry.getLink().add(link);
            LinkType link2 = new LinkType();
            link2.setHref(re.getAsset().getHref());
            link2.setRel("alternate");
            link2.setType("text/xml");
            entry.getLink().add(link2);
            LinkType link3 = new LinkType();
            String jsonURL = String.valueOf(JAXBLinksUtil.removeExtension(re.getAsset().getHref())) + ".json";
            link3.setHref(jsonURL);
            link3.setRel("alternate");
            link3.setType("application/json");
            entry.getLink().add(link3);
            LinkType wmlLink = new LinkType();
            String wapURL = String.valueOf(JAXBLinksUtil.removeExtension(re.getAsset().getHref())) + ".wml";
            wmlLink.setHref(wapURL);
            wmlLink.setRel("alternate");
            wmlLink.setType("application/xhtml+xml");
            entry.getLink().add(wmlLink);
        } else {
            LinkType wmlLink = new LinkType();
            String wapURL = String.valueOf(JAXBLinksUtil.removeExtension(re.getAsset().getHref())) + ".wml";
            wmlLink.setHref(wapURL);
            wmlLink.setRel("self");
            wmlLink.setType("application/xhtml+xml");
            entry.getLink().add(wmlLink);
            LinkType link = new LinkType();
            link.setHref(wapURL);
            link.setRel("alternate");
            link.setType("text/html");
            entry.getLink().add(link);
        }
        IdType id = new IdType();
        id.setValue(String.valueOf(re.getAsset().getId().getGUID()) + "/" + re.getAsset().getId().getVersion());
        entry.setId(id);
        TextType sum = new TextType();
        sum.getContent().add(JAXButil.toString(re.getAsset().getDescription()));
        entry.setSummary(sum);
        TextType t = new TextType();
        String title = String.valueOf(JAXButil.toString(re.getAsset().getTitle())) + " [" + re.getAsset().getId().getVersion() + "]";
        t.getContent().add(title);
        entry.setTitle(t);
        DateTimeType dt = new DateTimeType();
        dt.setValue(re.getAsset().getLastModified());
        entry.setUpdated(dt);
        ContentType content = new ContentType();
        content.setBase(base);
        content.setType("application/xml");
        content.getContent().add(new ObjectFactory().createSearchEntry(re));
        entry.setContent(content);
        PersonType p = new PersonType();
        Iterator<Link<User>> iterator = re.getAsset().getOwners().iterator();
        while (iterator.hasNext()) {
            p.getNameAndUriAndEmail().add(new com.ibm.ram.internal.jaxb.atom.ObjectFactory().createPersonTypeName(JAXButil.toString(iterator.next().getTitle())));
        }
        entry.getAuthor().add(p);
        return entry;
    }

    public static EntryType createOSLCAtomEntry(Asset a, String base) {
        EntryType entry = new EntryType();
        if (base != null) {
            entry.setBase(base);
        }
        LinkType link = new LinkType();
        link.setHref(base);
        link.setRel("alternate");
        link.setType("text/html");
        entry.getLink().add(link);
        IdType id = new IdType();
        id.setValue(String.valueOf(a.getId().getGUID()) + "/" + a.getId().getVersion());
        entry.setId(id);
        TextType sum = new TextType();
        sum.getContent().add(JAXButil.toString(a.getDescription()));
        entry.setSummary(sum);
        TextType t = new TextType();
        t.getContent().add(JAXButil.toString(a.getTitle()));
        entry.setTitle(t);
        DateTimeType dt = new DateTimeType();
        dt.setValue(a.getLastModified());
        entry.setUpdated(dt);
        ContentType content = new ContentType();
        content.setBase(base);
        content.setType("application/xml");
        content.getContent().add(new ObjectFactory().createAsset(a));
        entry.setContent(content);
        PersonType p = new PersonType();
        Iterator<Link<User>> iterator = a.getOwners().iterator();
        while (iterator.hasNext()) {
            p.getNameAndUriAndEmail().add(new com.ibm.ram.internal.jaxb.atom.ObjectFactory().createPersonTypeName(JAXButil.toString(iterator.next().getTitle())));
        }
        entry.getAuthor().add(p);
        return entry;
    }

    public static EntryType createAtomEntry(Asset a, String base) {
        EntryType entry = new EntryType();
        if (base != null) {
            entry.setBase(base);
        }
        IdType id = new IdType();
        id.setValue(String.valueOf(a.getId().getGUID()) + "/" + a.getId().getVersion());
        entry.setId(id);
        TextType sum = new TextType();
        sum.getContent().add(JAXButil.toString(a.getDescription()));
        entry.setSummary(sum);
        TextType t = new TextType();
        t.getContent().add(JAXButil.toString(a.getTitle()));
        entry.setTitle(t);
        DateTimeType dt = new DateTimeType();
        dt.setValue(a.getLastModified());
        entry.setUpdated(dt);
        ContentType content = new ContentType();
        content.setBase(a.getHref());
        content.setType("application/xml");
        content.getContent().add(new ObjectFactory().createAsset(a));
        entry.setContent(content);
        PersonType p = new PersonType();
        Iterator<Link<User>> iterator = a.getOwners().iterator();
        while (iterator.hasNext()) {
            p.getNameAndUriAndEmail().add(new com.ibm.ram.internal.jaxb.atom.ObjectFactory().createPersonTypeName(JAXButil.toString(iterator.next().getTitle())));
        }
        entry.getAuthor().add(p);
        return entry;
    }

    public static EntryType createAtomEntry(org.oslc.asset.internal.Asset a, List<LinkType> links, String base) {
        EntryType entry = new EntryType();
        if (base != null) {
            entry.setBase(base);
        }
        entry.getLink().addAll(links);
        IdType id = new IdType();
        id.setValue(String.valueOf(a.getId().getGUID()) + "/" + a.getId().getVersion());
        entry.setId(id);
        TextType sum = new TextType();
        sum.getContent().add(a.getSubject());
        entry.setSummary(sum);
        TextType t = new TextType();
        t.getContent().add(a.getTitle());
        entry.setTitle(t);
        DateTimeType dt = new DateTimeType();
        dt.setValue(JAXButil.getXMLCalendar(a.getModified()));
        entry.setUpdated(dt);
        ContentType content = new ContentType();
        content.setBase(base);
        content.setType("application/xml");
        content.getContent().add(new org.oslc.asset.internal.ObjectFactory().createAsset(a));
        entry.setContent(content);
        PersonType p = new PersonType();
        Iterator<ResourceRef> iterator = a.getContributors().iterator();
        while (iterator.hasNext()) {
            p.getNameAndUriAndEmail().add(new com.ibm.ram.internal.jaxb.atom.ObjectFactory().createPersonTypeName(iterator.next().getValue()));
        }
        entry.getAuthor().add(p);
        return entry;
    }

    public static EntryType createAtomEntry(RelationshipLink relationship, Asset a, String base) {
        EntryType entry = new EntryType();
        entry.setBase(base);
        LinkType link = new LinkType();
        link.setHref(base);
        link.setRel("alternate");
        link.setType("text/html");
        entry.getLink().add(link);
        IdType id = new IdType();
        id.setValue(base);
        entry.setId(id);
        TextType sum = new TextType();
        sum.getContent().add(a.getTitle() + "/" + relationship.getTitle() + "/" + relationship.getRelationship().getAssetName());
        entry.setSummary(sum);
        TextType t = new TextType();
        t.getContent().add(JAXButil.toString(relationship.getTitle()));
        entry.setTitle(t);
        DateTimeType dt = new DateTimeType();
        dt.setValue(a.getLastModified());
        entry.setUpdated(dt);
        ContentType content = new ContentType();
        content.setBase(base);
        content.setType("application/xml");
        content.getContent().add(relationship);
        entry.setContent(content);
        PersonType p = new PersonType();
        Iterator<Link<User>> iterator = a.getOwners().iterator();
        while (iterator.hasNext()) {
            p.getNameAndUriAndEmail().add(new com.ibm.ram.internal.jaxb.atom.ObjectFactory().createPersonTypeName(JAXButil.toString(iterator.next().getTitle())));
        }
        entry.getAuthor().add(p);
        return entry;
    }

    public static SimpleLiteral getSimpleLiteral(String value) {
        SimpleLiteral sl = new SimpleLiteral();
        if (value != null) {
            sl.getContent().add(value);
        }
        return sl;
    }

    public static String toString(SimpleLiteral l) {
        if (l != null && l.getContent() != null && l.getContent().size() > 0) {
            if (l.getContent().size() > 1) {
                StringBuffer s = new StringBuffer();
                int i = 0;
                while (i < l.getContent().size()) {
                    s.append(l.getContent().get(i).toString());
                    ++i;
                }
                return s.toString();
            }
            return l.getContent().get(0).toString();
        }
        return "";
    }

    public static void setWorkflow(Lifecycle lifecycle, Workflow workflow) {
        Link<Workflow> workflowRef = JAXBLinksUtil.getLink(workflow);
        lifecycle.setWorkflow(workflowRef);
        block0: for (StateConfiguration sConfig : lifecycle.getStateConfigurations()) {
            String id = JAXBLinksUtil.getStateIdentifier(sConfig.getState());
            for (State state : workflow.getStates()) {
                if (!id.equals(state.getIdentifier())) continue;
                Link<State> stateRef = JAXBLinksUtil.getLink(state);
                sConfig.setState(stateRef);
                block2: for (ExitCondition eCondition : sConfig.getExitConditions()) {
                    eCondition.setState(stateRef);
                    String aId = JAXBLinksUtil.getActionIdentifier(eCondition.getAction());
                    for (Action action : workflow.getActions()) {
                        if (!aId.equals(action.getIdentifier())) continue;
                        Link<Action> actionRef = JAXBLinksUtil.getLink(action);
                        eCondition.setAction(actionRef);
                        continue block2;
                    }
                }
                continue block0;
            }
        }
    }

    public static XMLGregorianCalendar getXMLCalendar(Date d) {
        GregorianCalendar calendar = new GregorianCalendar();
        if (d != null) {
            calendar.setTime(d);
        }
        XMLGregorianCalendar c = null;
        try {
            c = JAXButil.getDateTypeFactory().newXMLGregorianCalendar(calendar);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        return c;
    }

    public static Date getDate(XMLGregorianCalendar xc) {
        if (xc == null) {
            return null;
        }
        return xc.toGregorianCalendar().getTime();
    }

    public static Timestamp getTimestamp(XMLGregorianCalendar xc) {
        return new Timestamp(xc.toGregorianCalendar().getTimeInMillis());
    }

    public static Calendar getCalendar(XMLGregorianCalendar xc) {
        int gmtOffset = xc.getTimezone();
        int gmtOffsetMS = gmtOffset * 60 * 1000;
        GregorianCalendar c = xc.toGregorianCalendar(new SimpleTimeZone(gmtOffsetMS, ""), Locale.getDefault(), xc);
        return c;
    }

    public static String urlEncodePathSegments(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        StringBuffer result = new StringBuffer();
        String[] segments = path.split("/");
        int i = 0;
        while (i < segments.length) {
            result.append(RAMURLEncoder.encode(segments[i]));
            if (i < segments.length - 1) {
                result.append("/");
            }
            ++i;
        }
        return result.toString();
    }

    public static String urlDecodePathSegments(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        StringBuffer result = new StringBuffer();
        String[] segments = path.split("/");
        int i = 0;
        while (i < segments.length) {
            result.append(JAXButil.urlDecode(segments[i]));
            if (i < segments.length - 1) {
                result.append("/");
            }
            ++i;
        }
        return result.toString();
    }

    public static int getHashCode(Link link) {
        int result = 1;
        String normHref = JAXBLinksUtil.removeExtension(link.getHref());
        result = 31 * result + (normHref == null ? 0 : normHref.hashCode());
        return result;
    }

    public static boolean equals(Link link, Object link2) {
        if (link == link2) {
            return true;
        }
        if (link2 == null) {
            return false;
        }
        if (link.getClass() != link2.getClass()) {
            return false;
        }
        String normHref = JAXBLinksUtil.removeExtension(link.getHref());
        String otherNormHref = JAXBLinksUtil.removeExtension(((Link)link2).getHref());
        return !(normHref == null ? otherNormHref != null : !normHref.equals(otherNormHref));
    }

    public static int getHashCode(Lifecycle lifecycle) {
        int result = 1;
        result = 31 * result + (lifecycle.getHref() == null ? 0 : lifecycle.getHref().hashCode());
        return result;
    }

    public static boolean identifiersMatch(Lifecycle lifecycle, Object obj) {
        if (lifecycle == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (lifecycle.getClass() != obj.getClass()) {
            return false;
        }
        Lifecycle other = (Lifecycle)obj;
        return !(lifecycle.getHref() == null ? other.getHref() != null : !lifecycle.getIdentifier().equals(other.getIdentifier()));
    }

    public static boolean equals(Lifecycle lifecycle, Object obj) {
        if (lifecycle == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (lifecycle.getClass() != obj.getClass()) {
            return false;
        }
        Lifecycle other = (Lifecycle)obj;
        return !(lifecycle.getHref() == null ? other.getHref() != null : !JAXBLinksUtil.removeExtension(lifecycle.getHref()).equals(JAXBLinksUtil.removeExtension(other.getHref())));
    }

    public static int getHashCode(State state) {
        int result = 1;
        result = 31 * result + (state.getIdentifier() == null ? 0 : state.getIdentifier().hashCode());
        result = 31 * result + (state.getWorkflow() == null ? 0 : state.getWorkflow().hashCode());
        return result;
    }

    public static boolean equals(State state, Object obj) {
        if (state == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (state.getClass() != obj.getClass()) {
            return false;
        }
        State other = (State)obj;
        if (state.getIdentifier() == null ? other.getIdentifier() != null : !state.getIdentifier().equals(other.getIdentifier())) {
            return false;
        }
        return !(state.getWorkflow() == null ? other.getWorkflow() != null : !state.getWorkflow().equals(other.getWorkflow()));
    }

    public static int getHashCode(Workflow workflow) {
        int result = 1;
        result = 31 * result + (workflow.getIdentifier() == null ? 0 : workflow.getIdentifier().hashCode());
        return result;
    }

    public static boolean equals(Workflow workflow, Object obj) {
        if (workflow == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (workflow.getClass() != obj.getClass()) {
            return false;
        }
        Workflow other = (Workflow)obj;
        return !(workflow.getIdentifier() == null ? other.getIdentifier() != null : !workflow.getIdentifier().equals(other.getIdentifier()));
    }

    public static int getHashCode(Action action) {
        int result = 1;
        result = 31 * result + (action.getIdentifier() == null ? 0 : action.getIdentifier().hashCode());
        result = 31 * result + (action.getWorkflow() == null ? 0 : action.getWorkflow().hashCode());
        return result;
    }

    public static boolean equals(Action action, Object obj) {
        if (action == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (action.getClass() != obj.getClass()) {
            return false;
        }
        Action other = (Action)obj;
        if (action.getIdentifier() == null ? other.getIdentifier() != null : !action.getIdentifier().equals(other.getIdentifier())) {
            return false;
        }
        return !(action.getWorkflow() == null ? other.getWorkflow() != null : !action.getWorkflow().equals(other.getWorkflow()));
    }

    public static String urlDecode(String input) {
        return RAMURLDecoder.decode(input);
    }

    public static void partialUpdate(Artifact fullArtifact, Artifact partialArtifact, ArtifactPropOptions partalUpdate) {
        if (partalUpdate.shouldLoadContent()) {
            fullArtifact.setContent(partialArtifact.getContent());
        } else if (partalUpdate.shouldLoadMimeType()) {
            fullArtifact.setMimeType(partialArtifact.getMimeType());
        } else if (partalUpdate.shouldLoadReference()) {
            fullArtifact.setReference(partialArtifact.getReference());
        } else if (partalUpdate.shouldLoadSize()) {
            fullArtifact.setSize(partialArtifact.getSize());
        } else if (partalUpdate.shouldLoadSubject()) {
            fullArtifact.setLabel(partialArtifact.getLabel());
        } else if (partalUpdate.shouldLoadTitle()) {
            fullArtifact.setName(partialArtifact.getName());
        }
    }

    public static Error fillError(int statusCode, Throwable t) {
        Error error = new Error();
        error.setStatusCode(statusCode);
        error.setMessage(t.getLocalizedMessage());
        if (t.getCause() != null) {
            error.setExendedError(t.getCause().getLocalizedMessage());
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        StackTraceElement[] ste = t.getStackTrace();
        int i = 0;
        while (i < ste.length) {
            Error.ErrorTraceElement ete = new Error.ErrorTraceElement(ste[i].getClassName(), ste[i].getMethodName(), ste[i].getFileName(), ste[i].getLineNumber());
            error.getTrace().add(ete);
            ++i;
        }
        return error;
    }

    public static String serializeError(Error error, RestContext.SerializationFormat format) {
        String result;
        try {
            if (format == RestContext.SerializationFormat.JSON) {
                result = JsonUtil.getGson().toJson(error);
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Marshaller m = JAXButil.getXMLMarshaller("http://jazz.net/xmlns/ecalm/ram/internal/v7.2");
                m.marshal(new ObjectFactory().createError(error), (OutputStream)out);
                result = out.toString("UTF-8");
            }
        }
        catch (Throwable e) {
            result = "Error serializing real error (check the server log) " + e.getLocalizedMessage();
        }
        return result;
    }
}

