/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

public class JaxbDeserializer
implements JsonDeserializer<Object> {
    @Override
    public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Object retVal = null;
        Class clazz = (Class)typeOfT;
        if (clazz != null) {
            Field currentField = null;
            try {
                Object obj = clazz.newInstance();
                JsonObject jsonObj = (JsonObject)json;
                while (clazz != null) {
                    Field[] fields;
                    Field[] fieldArray = fields = clazz.getDeclaredFields();
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field field = fieldArray[n2];
                        field.setAccessible(true);
                        if (!Modifier.isTransient(field.getModifiers())) {
                            String prefix;
                            String fieldName = field.getName();
                            String annotationName = null;
                            String namespace = null;
                            if (field.isAnnotationPresent(XmlElement.class)) {
                                XmlElement xmlElement = field.getAnnotation(XmlElement.class);
                                annotationName = xmlElement.name();
                                namespace = xmlElement.namespace();
                            } else if (field.isAnnotationPresent(XmlAttribute.class)) {
                                XmlAttribute xmlAttribute = field.getAnnotation(XmlAttribute.class);
                                annotationName = xmlAttribute.name();
                                namespace = xmlAttribute.namespace();
                            }
                            JsonElement jsonElement = null;
                            if (annotationName != null && annotationName.length() > 0 && !"##default".equals(annotationName)) {
                                fieldName = annotationName;
                            }
                            if (namespace != null && namespace.length() > 0 && context.getPrefixMapper() != null && (prefix = context.getPrefixMapper().getPreferredPrefix(namespace, null, false)) != null && prefix.length() > 0) {
                                StringBuilder builder = new StringBuilder();
                                builder.append(prefix);
                                builder.append(":");
                                builder.append(fieldName);
                                fieldName = builder.toString();
                            }
                            jsonElement = jsonObj.get(fieldName);
                            if (field.getGenericType() != null) {
                                field.set(obj, context.deserialize(jsonElement, field.getGenericType()));
                            } else {
                                field.set(obj, context.deserialize(jsonElement, field.getType()));
                            }
                        }
                        ++n2;
                    }
                    clazz = clazz.getSuperclass();
                }
                retVal = obj;
            }
            catch (IllegalArgumentException e) {
                this.handleReflectionDeserializationError(clazz, currentField, e);
            }
            catch (IllegalAccessException e) {
                this.handleReflectionDeserializationError(clazz, currentField, e);
            }
            catch (InstantiationException e) {
                throw new JsonParseException("Error instantiating " + clazz.getName() + " during json deserialization", e);
            }
        } else {
            if (typeOfT != null) {
                throw new JsonParseException("Unable to deserialize null class for type " + typeOfT.toString());
            }
            throw new JsonParseException("Unable to deserialize null class for null type");
        }
        return retVal;
    }

    private void handleReflectionDeserializationError(Class<?> clazz, Field currentField, Exception e) throws JsonParseException {
        if (currentField != null) {
            throw new JsonParseException("Error deserializing " + clazz.getName() + ".  Current field was " + currentField.getName(), e);
        }
        throw new JsonParseException("Error deserializing " + clazz.getName() + ".  Current field was null", e);
    }
}

