/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.ibm.ram.common.data.RelationshipInfo;
import com.ibm.ram.internal.json.pojo.RelationshipEntry;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public class RelationshipEntrySerializer
implements JsonSerializer<RelationshipEntry> {
    @Override
    public JsonElement serialize(RelationshipEntry src, Type typeOfSrc, JsonSerializationContext context) {
        Class<?> clazz = src.getClass();
        JsonObject jsonObject = new JsonObject();
        while (clazz != null) {
            Field[] fields;
            Field[] fieldArray = fields = clazz.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                field.setAccessible(true);
                if (!Modifier.isTransient(field.getModifiers())) {
                    Object fieldValue = null;
                    try {
                        fieldValue = field.get(src);
                        String name = field.getName();
                        if (fieldValue == null) {
                            jsonObject.add(name, new JsonNull());
                        } else if (fieldValue instanceof String) {
                            jsonObject.addProperty(name, (String)fieldValue);
                        } else if (fieldValue instanceof Character) {
                            jsonObject.addProperty(name, (Character)fieldValue);
                        } else if (fieldValue instanceof Boolean) {
                            jsonObject.addProperty(name, (Boolean)fieldValue);
                        } else if (fieldValue instanceof Number) {
                            jsonObject.addProperty(name, (Number)fieldValue);
                        } else if (fieldValue instanceof RelationshipInfo) {
                            jsonObject.add(name, this.serializeForDojoDataStore(jsonObject, fieldValue, context));
                        } else {
                            jsonObject.add(name, context.serialize(fieldValue));
                        }
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return jsonObject;
    }

    private JsonObject serializeForDojoDataStore(JsonObject jsonObject, Object fieldValue, JsonSerializationContext context) {
        JsonObject specialTypeObj = new JsonObject();
        specialTypeObj.addProperty("_type", fieldValue.getClass().getName());
        specialTypeObj.add("_value", context.serialize(fieldValue));
        return specialTypeObj;
    }
}

