/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.rest;

import com.ibm.ram.internal.jaxb.Link;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import com.ibm.ram.internal.rest.RequestStatus;
import com.ibm.ram.internal.rest.RestContext;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class Request
extends RequestStatus.BasicRequestStatus {
    private Link<?> fLink;
    private RestContext fContext;
    private Map<String, String> fParameterMap;
    private Map<String, String> fHeadersMap;
    private Class<?> fRequestingClass;
    private Type fRespondingType = null;
    private long fIfModifiedSince = -1L;
    private String[] fIfNoneMatch;
    private long fIfUnmodifiedSince = -1L;
    private String[] fIfMatch;
    private RequestStatus.HTTPMethod method = RequestStatus.HTTPMethod.GET;

    public Request() {
        this.fContext = null;
    }

    public Request(String href) {
        this.fContext = null;
        this.setLink(JAXBLinksUtil.getLink(href));
    }

    public Request(RestContext context) {
        this.fContext = context;
    }

    public Request(RestContext context, Link link, Class<?> respondingClass) {
        this.fContext = context;
        this.setLink(link);
        this.fRequestingClass = respondingClass;
    }

    public <T> Link<T> getLink() {
        return this.fLink;
    }

    public void setLink(Link<?> requestLink) {
        String href = this.parseURL(requestLink.getHref());
        requestLink.setHref(href);
        this.fLink = requestLink;
    }

    public RestContext getContext() {
        return this.fContext;
    }

    public void setContext(RestContext context) {
        this.fContext = context;
    }

    public URI getRequestURI() throws URISyntaxException {
        if (this.getLink() == null || this.getLink().getHref() == null) {
            throw new URISyntaxException("null", "Link ref cannot be null");
        }
        return new URI(this.getLink().getHref());
    }

    public Map<String, String> getParameterMap() {
        if (this.fParameterMap == null) {
            this.fParameterMap = new HashMap<String, String>();
        }
        return this.fParameterMap;
    }

    public void setParameterMap(Map<String, String> paramMap) {
        this.fParameterMap = paramMap;
    }

    public Map<String, String> getHeadersMap() {
        if (this.fHeadersMap == null) {
            this.fHeadersMap = new HashMap<String, String>();
        }
        return this.fHeadersMap;
    }

    public void setHeadersMap(Map<String, String> headerMap) {
        this.fHeadersMap = headerMap;
    }

    @Override
    public long getIfModifiedSince() {
        return this.fIfModifiedSince;
    }

    public void setIfModifiedSince(long ifModifiedSince) {
        this.fIfModifiedSince = ifModifiedSince;
    }

    @Override
    public long getIfUnmodifiedSince() {
        return this.fIfUnmodifiedSince;
    }

    public void setIfUnmodifiedSince(long ifUnmodifiedSince) {
        this.fIfUnmodifiedSince = ifUnmodifiedSince;
    }

    @Override
    public String[] getIfNoneMatch() {
        return this.fIfNoneMatch;
    }

    public void setIfNoneMatch(String ifNoneMatch) {
        this.fIfNoneMatch = Request.parseIfETAG(ifNoneMatch);
    }

    @Override
    public String[] getIfMatch() {
        return this.fIfMatch;
    }

    public void setIfMatch(String ifMatch) {
        this.fIfMatch = Request.parseIfETAG(ifMatch);
    }

    public Class getRequestingClass() {
        return this.fRequestingClass;
    }

    public void setRequestingClass(Class requestingClass) {
        this.fRequestingClass = requestingClass;
    }

    public void setRespondingType(Type type) {
        this.fRespondingType = type;
    }

    public Type getRespondingType() {
        return this.fRespondingType;
    }

    @Override
    public RequestStatus.HTTPMethod getMethod() {
        return this.method;
    }

    public void setMethod(RequestStatus.HTTPMethod method) {
        this.method = method;
    }

    @Override
    public boolean isHead() {
        return this.method == RequestStatus.HTTPMethod.HEAD;
    }

    private String parseURL(String href) {
        if (href.contains("?")) {
            String url = href.substring(0, href.indexOf("?"));
            String query = href.substring(href.indexOf("?") + 1);
            this.parseParameters(query);
            href = url;
        }
        return href;
    }

    private void parseParameters(String query) {
        String[] params;
        String[] stringArray = params = query.split("&");
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String name = param.substring(0, param.indexOf("="));
            String value = param.substring(param.indexOf("=") + 1);
            this.getParameterMap().put(name, value);
            ++n2;
        }
    }

    @Override
    public boolean isGetOrHead() {
        switch (this.method) {
            case GET: 
            case HEAD: {
                return true;
            }
        }
        return false;
    }
}

