/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.ccvs;

import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.Reference;
import com.ibm.ram.defaultprofile.ReferenceKind;
import com.ibm.ram.internal.common.bundles.CommonMessages;
import com.ibm.ram.internal.scm.SCMReference;
import com.ibm.ram.internal.scm.Utilities;
import com.ibm.ram.internal.scm.ccvs.CVSRepositoryLocation;
import com.ibm.ram.internal.scm.ccvs.CVSTag;
import com.ibm.ram.scm.SCMException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;

public class CVSReference
extends SCMReference {
    public static final String REFERENCE_KIND_NAME = "cvs";
    protected static final String KEY_FILE_NAME = "FILE_NAME";
    protected static final String KEY_REPOSITORY_RELATIVE_PATH = "REPOSITORY_RELATIVE_PATH";
    protected static final String KEY_FILE_REVISION = "FILE_REVISION";
    protected static final String KEY_SERVER_HOST = "SERVER_HOST";
    protected static final String KEY_SERVER_PORT = "SERVER_PORT";
    protected static final String KEY_SERVER_CONNECTION_METHOD = "SERVER_CONNECTION_METHOD";
    protected static final String KEY_SERVER_REPOSITORY_PATH = "SERVER_REPOSITORY_PATH";
    protected static final String KEY_FILE_TAG_TYPE = "FILE_TAG_TYPE";
    protected static final String KEY_FILE_TAG_NAME = "FILE_TAG_NAME";
    protected static final String KEY_FILE_LABEL_NAME = "FILE_LABEL_NAME";
    private String name;
    private String repositoryRelativePath;
    private CVSTag tag = null;
    private String revision = null;
    private CVSRepositoryLocation repositoryLocation;
    private String label = null;

    public CVSReference(String name, String revision, String repositoryRelativePath, CVSTag tag, CVSRepositoryLocation repositoryLocation, boolean isFolder, String label, String artifactFileRelativePath) {
        super(isFolder, artifactFileRelativePath);
        this.setName(name);
        this.setRevision(revision);
        this.setRepositoryRelativePath(repositoryRelativePath);
        this.setTag(tag);
        this.setRepositoryLocation(repositoryLocation);
        this.setLabel(label);
    }

    public static CVSReference parseReferenceValue(Reference reference) throws SCMException {
        try {
            Properties coreProperties = Utilities.deSerializeProperties(Utilities.processCRLF(reference.getValue()));
            String serverHost = coreProperties.getProperty(KEY_SERVER_HOST);
            String serverPort = coreProperties.getProperty(KEY_SERVER_PORT);
            String connectionMethod = coreProperties.getProperty(KEY_SERVER_CONNECTION_METHOD);
            String repositoryDirectory = coreProperties.getProperty(KEY_SERVER_REPOSITORY_PATH);
            String repositoryRelativePath = coreProperties.getProperty(KEY_REPOSITORY_RELATIVE_PATH);
            String tagType = coreProperties.getProperty(KEY_FILE_TAG_TYPE);
            String tag = coreProperties.getProperty(KEY_FILE_TAG_NAME);
            String revision = coreProperties.getProperty(KEY_FILE_REVISION);
            String label = coreProperties.getProperty(KEY_FILE_LABEL_NAME);
            String name = coreProperties.getProperty(KEY_FILE_NAME);
            boolean isFolder = Boolean.valueOf(coreProperties.getProperty("IS_FOLDER"));
            String artifactFileRelativePath = coreProperties.getProperty("ARTIFACT_FILE_RELATIVE_PATH");
            CVSTag cvsTag = new CVSTag(tag, Integer.parseInt(tagType));
            CVSRepositoryLocation cvsRepositoryLocation = new CVSRepositoryLocation(serverHost, serverPort, connectionMethod, repositoryDirectory);
            CVSReference cvsReference = new CVSReference(name, revision, repositoryRelativePath, cvsTag, cvsRepositoryLocation, isFolder, label, artifactFileRelativePath);
            return cvsReference;
        }
        catch (IOException e) {
            throw new SCMException(MessageFormat.format(CommonMessages.getString("CVSReference_UnableToReconstructCVSReference"), reference.getValue()), e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CVSRepositoryLocation getRepositoryLocation() {
        return this.repositoryLocation;
    }

    public void setRepositoryLocation(CVSRepositoryLocation repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    public String getRepositoryRelativePath() {
        return this.repositoryRelativePath;
    }

    public void setRepositoryRelativePath(String repositoryRelativePath) {
        this.repositoryRelativePath = repositoryRelativePath;
    }

    public CVSTag getTag() {
        return this.tag;
    }

    public void setTag(CVSTag tag) {
        this.tag = tag;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    @Override
    public ReferenceKind getReferenceKind() {
        ReferenceKind refKind = DefaultprofileFactory.eINSTANCE.createReferenceKind();
        refKind.setName(REFERENCE_KIND_NAME);
        return refKind;
    }

    public static String getReferenceKindName() {
        return REFERENCE_KIND_NAME;
    }

    @Override
    public Properties getCoreProperties() {
        Properties props = super.getCoreProperties();
        props.setProperty(KEY_FILE_NAME, this.getName());
        props.setProperty(KEY_FILE_REVISION, this.getRevision());
        props.setProperty(KEY_FILE_TAG_NAME, this.getTag().getName());
        props.setProperty(KEY_FILE_TAG_TYPE, Integer.toString(this.getTag().getType()));
        props.setProperty(KEY_REPOSITORY_RELATIVE_PATH, this.getRepositoryRelativePath());
        props.setProperty(KEY_SERVER_CONNECTION_METHOD, this.getRepositoryLocation().getConnectionMethod());
        props.setProperty(KEY_SERVER_HOST, this.getRepositoryLocation().getHost());
        props.setProperty(KEY_SERVER_PORT, this.getRepositoryLocation().getPort());
        props.setProperty(KEY_SERVER_REPOSITORY_PATH, this.getRepositoryLocation().getRepositoryDirectory());
        props.setProperty(KEY_FILE_LABEL_NAME, this.getLabel());
        return props;
    }

    @Override
    public Properties getDescriptiveProperties() {
        Properties props = super.getDescriptiveProperties();
        props.setProperty(KEY_FILE_NAME, this.getName());
        props.setProperty(KEY_FILE_REVISION, this.getRevision());
        props.setProperty(KEY_FILE_TAG_NAME, this.getTag().getName());
        props.setProperty(KEY_FILE_TAG_TYPE, Integer.toString(this.getTag().getType()));
        props.setProperty(KEY_REPOSITORY_RELATIVE_PATH, this.getRepositoryRelativePath());
        props.setProperty(KEY_SERVER_CONNECTION_METHOD, this.getRepositoryLocation().getConnectionMethod());
        props.setProperty(KEY_SERVER_HOST, this.getRepositoryLocation().getHost());
        props.setProperty(KEY_SERVER_PORT, this.getRepositoryLocation().getPort());
        props.setProperty(KEY_SERVER_REPOSITORY_PATH, this.getRepositoryLocation().getRepositoryDirectory());
        props.setProperty(KEY_FILE_LABEL_NAME, this.getLabel());
        return props;
    }

    @Override
    public Properties getDisplayProperties() {
        Properties props = super.getDisplayProperties();
        props.setProperty(CommonMessages.getString("CVSReference_DisplayName"), this.getName());
        props.setProperty(CommonMessages.getString("CVSReference_DisplayPath"), this.getRepositoryRelativePath());
        props.setProperty(CommonMessages.getString("CVSReference_DisplayRevision"), this.getRevision());
        String tagType = this.getTag() == null ? "" : CVSTag.getTagTypeString(this.getTag());
        String tagName = this.getTag() == null ? "" : this.getTag().getName();
        props.setProperty(CommonMessages.getString("CVSReference_DisplayTagType"), tagType);
        props.setProperty(CommonMessages.getString("CVSReference_DisplayTagName"), tagName);
        CVSRepositoryLocation rr = this.getRepositoryLocation();
        props.setProperty(CommonMessages.getString("CVSReference_DisplayHost"), rr.getHost());
        props.setProperty(CommonMessages.getString("CVSReference_DisplayPort"), rr.getPort());
        props.setProperty(CommonMessages.getString("CVSReference_DisplayRepositoryDirectory"), rr.getRepositoryDirectory());
        props.setProperty(CommonMessages.getString("CVSReference_DisplayConnectionMethod"), rr.getConnectionMethod());
        return props;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

