/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands.ucm;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.ucm.Stream;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class GetStreamCommand
extends OutputCleartoolCommand {
    private String KEY_OWNER = CleartoolCommandConstants.LSSTREAM_OWNER;
    private String KEY_GROUP = CleartoolCommandConstants.LSSTREAM_GROUP;
    private String KEY_PROJECT = CleartoolCommandConstants.LSSTREAM_PROJECT;
    private String KEY_DEFAULT_STREAM = CleartoolCommandConstants.LSSTREAM_DEFAULT_DELIVER_STREAM;
    private String KEY_DEVELOPMENT_STREAMS = CleartoolCommandConstants.LSSTREAM_DEVELOPMENT_STREAMS;
    private String KEY_ACTIVITIES = CleartoolCommandConstants.LSSTREAM_CONTAINS_ACTIVITIES;
    private String KEY_FOUNDATION_BL = CleartoolCommandConstants.LSSTREAM_FOUNDATION_BASELINES;
    private String KEY_RECOMMENDED_BL = CleartoolCommandConstants.LSSTREAM_RECOMMENDED_BASELINES;
    private String KEY_VIEWS = CleartoolCommandConstants.LSSTREAM_VIEWS;
    private String KEY_POLICIES = CleartoolCommandConstants.LSSTREAM_POLICIES;
    private String KEY_EFFECTIVE = CleartoolCommandConstants.LSSTREAM_POLICIES_EFFECTIVE;
    private String KEY_NAMETEMPLATE = CleartoolCommandConstants.LSSTREAM_NAMING_TEMPLATE;
    private String selector;
    private String lastFoundToken;
    private boolean isView;
    private File viewFile;
    private boolean inProject = false;

    public GetStreamCommand(String projectSelector) {
        this.selector = projectSelector;
        this.isView = false;
        this.inProject = true;
    }

    public GetStreamCommand(File viewFile) {
        this.viewFile = viewFile;
    }

    public GetStreamCommand(String selector, boolean isView) {
        this.selector = selector;
        this.isView = isView;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String outputStream, String errorStream) {
        ArrayList<Stream> streams = new ArrayList<Stream>();
        if (outputStream != null && outputStream.length() > 0) {
            String[] streamsStrings = outputStream.split("\r\n");
            int i = 0;
            while (i < streamsStrings.length) {
                if (streamsStrings[i].trim().length() > 0 && streamsStrings[i].startsWith(CleartoolCommandConstants.STREAM)) {
                    String firstLine = streamsStrings[i].substring(CleartoolCommandConstants.STREAM.length()).trim();
                    String streamName = this.stripQuotes(firstLine);
                    String streamOwner = null;
                    String streamGroup = null;
                    String streamProject = null;
                    String defaultStream = null;
                    String[] devStreams = null;
                    String[] activities = null;
                    String[] foundationBaselines = null;
                    String[] recommendedBaselines = null;
                    String[] views = null;
                    String[] policies = null;
                    String[] effectivePolicies = null;
                    String baselineNamingTemplate = null;
                    boolean isIntegrationStream = false;
                    ++i;
                    String line = null;
                    boolean getNextLine = true;
                    while (i < streamsStrings.length && !streamsStrings[i].startsWith(CleartoolCommandConstants.STREAM)) {
                        line = getNextLine ? streamsStrings[i].trim() : this.lastFoundToken;
                        if (line.startsWith(this.KEY_OWNER)) {
                            streamOwner = line.substring(this.KEY_OWNER.length()).trim();
                        } else if (line.startsWith(this.KEY_GROUP)) {
                            streamGroup = line.substring(this.KEY_GROUP.length()).trim();
                        } else if (line.startsWith(this.KEY_PROJECT)) {
                            String streamLine = line.substring(this.KEY_PROJECT.length()).trim();
                            StringTokenizer tokenizer = new StringTokenizer(streamLine);
                            streamProject = tokenizer.nextToken();
                            String parenthesizedText = tokenizer.nextToken();
                            isIntegrationStream = parenthesizedText.indexOf(CleartoolCommandConstants.INTEGRATION) > -1;
                        } else if (line.startsWith(this.KEY_DEFAULT_STREAM)) {
                            defaultStream = line.substring(this.KEY_DEFAULT_STREAM.length()).trim();
                        } else {
                            if (line.startsWith(this.KEY_DEVELOPMENT_STREAMS)) {
                                devStreams = this.processValues(this.KEY_ACTIVITIES, streamsStrings, ++i);
                                i = this.advanceToToken(this.KEY_ACTIVITIES, streamsStrings, i);
                                continue;
                            }
                            if (line.startsWith(this.KEY_ACTIVITIES)) {
                                activities = this.processValues(this.KEY_FOUNDATION_BL, streamsStrings, ++i);
                                i = this.advanceToToken(this.KEY_FOUNDATION_BL, streamsStrings, i);
                                continue;
                            }
                            if (line.startsWith(this.KEY_FOUNDATION_BL)) {
                                foundationBaselines = this.processValues(this.KEY_RECOMMENDED_BL, streamsStrings, ++i);
                                foundationBaselines = this.parseBaselines(foundationBaselines);
                                i = this.advanceToToken(this.KEY_RECOMMENDED_BL, streamsStrings, i);
                                continue;
                            }
                            if (line.startsWith(this.KEY_RECOMMENDED_BL)) {
                                recommendedBaselines = this.processValues(this.KEY_VIEWS, streamsStrings, ++i);
                                i = this.advanceToToken(this.KEY_VIEWS, streamsStrings, i);
                                continue;
                            }
                            if (line.startsWith(this.KEY_VIEWS)) {
                                views = this.processValues(this.KEY_POLICIES, streamsStrings, ++i);
                                i = this.advanceToToken(this.KEY_POLICIES, streamsStrings, i);
                                continue;
                            }
                            if (line.startsWith(this.KEY_POLICIES)) {
                                policies = this.processValues(this.KEY_EFFECTIVE, streamsStrings, ++i);
                                i = this.advanceToToken(this.KEY_EFFECTIVE, streamsStrings, i);
                                continue;
                            }
                            if (line.startsWith(this.KEY_EFFECTIVE)) {
                                effectivePolicies = this.processValues(this.KEY_NAMETEMPLATE, streamsStrings, ++i);
                                i = this.advanceToToken(this.KEY_NAMETEMPLATE, streamsStrings, i);
                                getNextLine = false;
                                continue;
                            }
                        }
                        ++i;
                        getNextLine = true;
                    }
                    if (this.lastFoundToken.startsWith(this.KEY_NAMETEMPLATE)) {
                        baselineNamingTemplate = this.lastFoundToken.substring(this.KEY_NAMETEMPLATE.length()).trim();
                    }
                    Stream stream = new Stream();
                    stream.setStreamName(streamName);
                    stream.setStreamOwner(streamOwner);
                    stream.setStreamGroup(streamGroup);
                    stream.setStreamProject(streamProject);
                    stream.setIntegrationStream(isIntegrationStream);
                    stream.setDefaultDeliverStream(defaultStream);
                    stream.setDevelopmentStreams(devStreams);
                    stream.setContainsActivities(activities);
                    stream.setFoundationBaselines(foundationBaselines);
                    stream.setRecommendedBaselines(recommendedBaselines);
                    stream.setViews(views);
                    stream.setPolicies(policies);
                    stream.setEffectivePolicies(effectivePolicies);
                    stream.setBaselineNamingTemplate(baselineNamingTemplate);
                    streams.add(stream);
                    --i;
                }
                ++i;
            }
        }
        final Stream[] theStream = streams.toArray(new Stream[streams.size()]);
        return new GetStreamCommandOutput(){

            @Override
            public Stream[] getStreams() {
                return theStream;
            }
        };
    }

    private String[] parseBaselines(String[] foundationBaselines) {
        if (foundationBaselines != null && foundationBaselines.length > 0) {
            String[] parsedBaselines = new String[foundationBaselines.length];
            int i = 0;
            while (i < foundationBaselines.length) {
                parsedBaselines[i] = foundationBaselines[i].substring(0, foundationBaselines[i].indexOf(" "));
                ++i;
            }
            return parsedBaselines;
        }
        return null;
    }

    @Override
    protected String[] getArguments() {
        if (this.viewFile != null) {
            return new String[]{"lsstream", "-long"};
        }
        if (this.isView) {
            return new String[]{"lsstream", "-long", "-view", this.selector};
        }
        if (this.inProject) {
            return new String[]{"lsstream", "-long", "-in", this.selector};
        }
        return new String[]{"lsstream", "-long", this.selector};
    }

    private String[] processValues(String tokenToLookFor, String[] streamLines, int startIndex) {
        ArrayList<String> list = new ArrayList<String>();
        boolean foundToken = false;
        int currentIndex = startIndex;
        while (currentIndex < streamLines.length && !foundToken) {
            String line = streamLines[currentIndex].trim();
            if (line.startsWith(tokenToLookFor)) {
                foundToken = true;
                this.lastFoundToken = line;
            } else {
                list.add(line);
            }
            ++currentIndex;
        }
        return list.toArray(new String[list.size()]);
    }

    private int advanceToToken(String tokenToLookFor, String[] streamsLines, int startIndex) {
        int currentIndex = startIndex;
        while (currentIndex < streamsLines.length) {
            String line = streamsLines[currentIndex].trim();
            if (line.startsWith(tokenToLookFor)) break;
            ++currentIndex;
        }
        return currentIndex;
    }

    @Override
    protected File getFolderToRunIn() {
        if (this.viewFile != null) {
            if (this.viewFile.isDirectory()) {
                return this.viewFile;
            }
            return this.viewFile.getParentFile();
        }
        return null;
    }

    private String stripQuotes(String str) {
        String stripped = str.replace('\"', ' ');
        return stripped.trim();
    }

    public static interface GetStreamCommandOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public Stream[] getStreams();
    }
}

