/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands.ucm;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;

public class RebaseStreamCommand
extends OutputCleartoolCommand {
    private String viewTag;
    private String developmentStream;
    private String baselineName;

    public RebaseStreamCommand(String viewTag, String developmentStream, String baselineName) {
        this.viewTag = viewTag;
        this.developmentStream = developmentStream;
        this.baselineName = baselineName;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String outputStream, String errorStream) {
        boolean rebaseCompleted = false;
        if (outputStream != null && outputStream.length() > 0) {
            String[] lines = outputStream.split("\r\n");
            int i = 0;
            while (i < lines.length) {
                String line = lines[i];
                if (line.equals("Rebase completed.")) {
                    rebaseCompleted = true;
                }
                ++i;
            }
        }
        final boolean finalComplete = rebaseCompleted;
        return new RebaseStreamCommandOutput(){

            @Override
            public boolean rebaseComplete() {
                return finalComplete;
            }
        };
    }

    @Override
    protected String[] getArguments() {
        return new String[]{"rebase", "-view", this.viewTag, "-stream", this.developmentStream, "-baseline", this.baselineName, "-f", "-complete"};
    }

    public static interface RebaseStreamCommandOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public boolean rebaseComplete();
    }
}

