/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.ucm;

import com.ibm.ram.internal.scm.clearcase.ucm.BaseLine;
import com.ibm.ram.internal.scm.clearcase.ucm.ClearcaseUCMManager;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class BaseLineUtilities {
    public static BaseLine[] getNewerBaselinesThanInComposite(BaseLine[] compositeAndIndependantBLs) {
        ArrayList<BaseLine> matches = new ArrayList<BaseLine>();
        BaseLine[] compositeBaselines = BaseLineUtilities.getOnlyCompositeBaseLines(compositeAndIndependantBLs);
        BaseLine[] noncompositeBaselines = BaseLineUtilities.getOnlyNonCompositeBaseLines(compositeAndIndependantBLs);
        int i = 0;
        while (i < compositeBaselines.length) {
            ArrayList dependantComponents = BaseLineUtilities.getDependantComponentListFromCompositeBL(compositeBaselines[i]);
            int j = 0;
            while (j < noncompositeBaselines.length) {
                String component = noncompositeBaselines[j].getComponent();
                boolean componentsMatch = dependantComponents.contains(component);
                if (componentsMatch) {
                    String[] dependantSelectors = BaseLineUtilities.getDependantComponentSelectorsFromCompositeBL(compositeBaselines[i]);
                    boolean baselineInComposite = false;
                    int k = 0;
                    while (k < dependantSelectors.length) {
                        boolean foundMatch = BaseLineUtilities.selectorMatchesBaseLine(dependantSelectors[k], noncompositeBaselines[j]);
                        if (foundMatch) {
                            baselineInComposite = true;
                            break;
                        }
                        ++k;
                    }
                    if (!baselineInComposite) {
                        matches.add(noncompositeBaselines[j]);
                    }
                }
                ++j;
            }
            ++i;
        }
        return matches.toArray(new BaseLine[matches.size()]);
    }

    public static BaseLine[] getOnlyCompositeBaseLines(BaseLine[] baselines) {
        ArrayList<BaseLine> matches = new ArrayList<BaseLine>();
        int i = 0;
        while (i < baselines.length) {
            if (baselines[i] != null && baselines[i].isComposite()) {
                matches.add(baselines[i]);
            }
            ++i;
        }
        return matches.toArray(new BaseLine[matches.size()]);
    }

    public static BaseLine[] getCompositeAndIndependantBaseLines(BaseLine[] allBaselines) {
        ArrayList<BaseLine> matches = new ArrayList<BaseLine>();
        BaseLine[] compositeBLs = BaseLineUtilities.getOnlyCompositeBaseLines(allBaselines);
        String[] dependantBLSelectors = BaseLineUtilities.getDependantBaseLineSelectors(compositeBLs);
        int i = 0;
        while (i < allBaselines.length) {
            if (allBaselines[i] != null && (allBaselines[i].isComposite() || !BaseLineUtilities.isBaselinePartOfComposite(allBaselines[i], dependantBLSelectors))) {
                matches.add(allBaselines[i]);
            }
            ++i;
        }
        return matches.toArray(new BaseLine[matches.size()]);
    }

    public static BaseLine[] getOnlyNonCompositeBaseLines(BaseLine[] baselines) {
        ArrayList<BaseLine> matches = new ArrayList<BaseLine>();
        int i = 0;
        while (i < baselines.length) {
            if (baselines[i] != null && !baselines[i].isComposite()) {
                matches.add(baselines[i]);
            }
            ++i;
        }
        return matches.toArray(new BaseLine[matches.size()]);
    }

    public static String[] getDependantBaseLineSelectors(BaseLine[] compositeBLs) {
        ArrayList<String> matches = new ArrayList<String>();
        int i = 0;
        while (i < compositeBLs.length) {
            String[] depSelectors;
            if (compositeBLs[i] != null && compositeBLs[i].isComposite() && (depSelectors = compositeBLs[i].getDependsOn()) != null) {
                int j = 0;
                while (j < depSelectors.length) {
                    matches.add(depSelectors[j]);
                    ++j;
                }
            }
            ++i;
        }
        return matches.toArray(new String[matches.size()]);
    }

    public static boolean isBaselinePartOfComposite(BaseLine baseline, String[] dependantBLSelectors) {
        boolean isDependant = false;
        int j = 0;
        while (j < dependantBLSelectors.length) {
            if (BaseLineUtilities.selectorMatchesBaseLine(dependantBLSelectors[j], baseline)) {
                isDependant = true;
                break;
            }
            ++j;
        }
        return isDependant;
    }

    public static boolean selectorMatchesBaseLine(String selector, BaseLine baseline) {
        String baselineSelector;
        boolean match = false;
        if (selector != null && baseline != null && selector.indexOf(baselineSelector = BaseLineUtilities.constructBaselineSelector(baseline)) != -1) {
            match = true;
        }
        return match;
    }

    public static String constructBaselineSelector(BaseLine baseline) {
        if (baseline != null) {
            return String.valueOf(baseline.getBaselineName()) + "@" + ClearcaseUCMManager.parsePVOBNameFromSelector(baseline.getComponent());
        }
        return null;
    }

    public static String[] getDependantBLSelectorsFromCompositeBL(BaseLine compositeBL) {
        ArrayList<String> matches = new ArrayList<String>();
        if (compositeBL != null && compositeBL.isComposite()) {
            String[] dependsOn = compositeBL.getDependsOn();
            int i = 0;
            while (i < dependsOn.length) {
                String currentLine = dependsOn[i];
                StringTokenizer tokenizer = new StringTokenizer(currentLine);
                matches.add(tokenizer.nextToken());
                ++i;
            }
        }
        return matches.toArray(new String[matches.size()]);
    }

    public static String[] getDependantComponentSelectorsFromCompositeBL(BaseLine compositeBL) {
        ArrayList matches = BaseLineUtilities.getDependantComponentListFromCompositeBL(compositeBL);
        return matches.toArray(new String[matches.size()]);
    }

    public static ArrayList getDependantComponentListFromCompositeBL(BaseLine compositeBL) {
        ArrayList<String> matches = new ArrayList<String>();
        if (compositeBL != null && compositeBL.isComposite()) {
            String[] dependsOn = compositeBL.getDependsOn();
            int i = 0;
            while (i < dependsOn.length) {
                String currentLine = dependsOn[i];
                StringTokenizer tokenizer = new StringTokenizer(currentLine);
                tokenizer.nextToken();
                String parenthesizedComponent = tokenizer.nextToken();
                if (parenthesizedComponent.charAt(0) == '(' && parenthesizedComponent.charAt(parenthesizedComponent.length() - 1) == ')') {
                    String componentSelector = parenthesizedComponent.substring(1, parenthesizedComponent.length() - 1);
                    matches.add(componentSelector);
                }
                ++i;
            }
        }
        return matches;
    }
}

