/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.ucm;

import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.ReferenceKind;
import com.ibm.ram.internal.common.bundles.CommonMessages;
import com.ibm.ram.internal.scm.clearcase.ClearCaseException;
import com.ibm.ram.internal.scm.clearcase.ClearCaseReference;
import com.ibm.ram.internal.scm.clearcase.VOB;
import com.ibm.ram.internal.scm.clearcase.ucm.BaseLine;
import com.ibm.ram.internal.scm.clearcase.ucm.ClearcaseUCMManager;
import java.util.Properties;

public class ClearcaseUCMReference
extends ClearCaseReference {
    private String baselineSelector = null;
    public static final String REFERENCE_KIND_NAME = "com.ibm.ram.clearcase.ucm";
    public static final String BASELINE_NAME = "BASELINE_NAME";
    public static final String KEY_BASELINE = "BASELINE_UUIDS";

    public ClearcaseUCMReference(String baselineSelector, String versionUniversalSelector, String elementUniversalSelector, String label, String versionPath, String branchName, VOB vob, String registryHost, boolean isFolder, String artifactFileRelativePath) {
        super(versionUniversalSelector, elementUniversalSelector, label, versionPath, branchName == null ? ClearcaseUCMReference.getLastBranchName(versionPath) : branchName, vob, registryHost, isFolder, artifactFileRelativePath);
        this.baselineSelector = baselineSelector;
    }

    @Override
    protected ReferenceKind getReferenceKind() {
        ReferenceKind refKind = DefaultprofileFactory.eINSTANCE.createReferenceKind();
        refKind.setName(REFERENCE_KIND_NAME);
        return refKind;
    }

    public static String getReferenceKindName() {
        return REFERENCE_KIND_NAME;
    }

    public String getBaselineSelector() {
        return this.baselineSelector;
    }

    public void setBaselineSelector(String baselineSelector) {
        this.baselineSelector = baselineSelector;
    }

    @Override
    public Properties getDisplayProperties() {
        Properties props = super.getDisplayProperties();
        props.setProperty(CommonMessages.getString("ClearCaseUCMReference_DisplayBaseline"), this.getBaselineNames());
        return props;
    }

    @Override
    public Properties getDescriptiveProperties() {
        Properties p = super.getDescriptiveProperties();
        p.put(BASELINE_NAME, this.getBaselineSelector());
        return p;
    }

    @Override
    public Properties getCoreProperties() {
        Properties baseProps = super.getCoreProperties();
        if (baseProps != null) {
            baseProps.put(KEY_BASELINE, this.getBaselineSelector());
        }
        return baseProps;
    }

    private String getBaselineNames() {
        try {
            String baselinesSelector = this.getBaselineSelector();
            ClearcaseUCMManager manager = ClearcaseUCMManager.getInstance();
            String[] baselineUUIDs = baselinesSelector.split(",");
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < baselineUUIDs.length) {
                BaseLine currentBL = manager.getBaselineByUUID(baselineUUIDs[i]);
                if (currentBL != null) {
                    buffer.append(currentBL.getBaselineName());
                    buffer.append(",");
                }
                ++i;
            }
            String unFinishedBLs = buffer.toString();
            int index = unFinishedBLs.lastIndexOf(",");
            if (index != -1) {
                return unFinishedBLs.substring(0, index);
            }
            return unFinishedBLs;
        }
        catch (ClearCaseException clearCaseException) {
            return this.getBaselineSelector();
        }
    }
}

