/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.io.zip;

import com.ibm.ram.io.zip.DefaultExtraField;
import com.ibm.ram.io.zip.UShort;
import com.ibm.ram.io.zip.ZIP;
import java.util.HashMap;
import java.util.Map;

abstract class ExtraField {
    public static final int ZIP64_HEADER_ID = 1;
    private static final Map registry = new HashMap();

    ExtraField() {
    }

    public static void register(Class c) {
        ExtraField ef;
        try {
            ef = (ExtraField)c.newInstance();
        }
        catch (Exception ex) {
            IllegalArgumentException iae = new IllegalArgumentException();
            iae.initCause(ex);
            throw iae;
        }
        int headerID = ef.getHeaderID();
        UShort.check(headerID, "Header ID out of range", null);
        registry.put(new Integer(headerID), c);
    }

    public static ExtraField create(int headerID) {
        ExtraField ef;
        UShort.check(headerID, "Header ID out of range", null);
        Class c = (Class)registry.get(new Integer(headerID));
        try {
            ef = c != null ? (ExtraField)c.newInstance() : new DefaultExtraField(headerID);
        }
        catch (Exception ex) {
            IllegalArgumentException iae = new IllegalArgumentException();
            iae.initCause(ex);
            throw iae;
        }
        return ef;
    }

    public abstract int getHeaderID();

    abstract int getDataSize();

    final byte[] getDataBlock() {
        int size = this.getDataSize();
        UShort.check(size);
        if (size == 0) {
            return ZIP.EMPTY;
        }
        byte[] data = new byte[size];
        this.writeTo(data, 0);
        return data;
    }

    abstract void readFrom(byte[] var1, int var2, int var3);

    abstract void writeTo(byte[] var1, int var2);
}

