/*
 * Decompiled with CFR 0.152.
 */
package org.oslc.asset.internal.v2;

import com.ibm.ram.internal.jaxb.AssetAttribute;
import com.ibm.ram.internal.jaxb.AttributeType;
import com.ibm.ram.internal.jaxb.AttributeValue;
import com.ibm.ram.internal.json.JsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.oslc.asset.internal.Asset;
import org.oslc.asset.internal.v2.RelatedResource;
import org.oslc.asset.internal.v2.ResourceAttributeValue;

public class RelationshipUtil {
    public static final String TYPE_CHANGE_REQUEST = "http://open-services.net/ns/cm#ChangeRequest";
    public static final String TYPE_REQUIREMENT = "http://open-services.net/ns/rm#Requirement";
    public static final String TYPE_AUTOMATION_PLAN = "http://open-services.net/ns/auto#AutomationPlan";
    public static final String TYPE_AUTOMATION_RESULT = "http://open-services.net/ns/auto#AutomationResult";
    public static final String TYPE_AUTOMATION_REQUEST = "http://open-services.net/ns/auto#AutomationRequest";
    public static final String TYPE_TEST_PLAN = "http://open-services.net/ns/qm#TestPlan";
    public static final String TYPE_TEST_CASE = "http://open-services.net/ns/qm#TestCase";
    public static final String TYPE_TEST_RESULT = "http://open-services.net/ns/qm#TestResult";
    public static final String TYPE_TEST_EXECUTION_RECORD = "http://open-services.net/ns/qm#TestExecutionRecord";
    public static final String TYPE_TEST_SCRIPT = "http://open-services.net/ns/qm#TestScript";
    public static final String TYPE_ARCHITECTURE_MANAGEMENT_RESOURCE = "http://open-services.net/ns/am#Resource";
    public static final String TYPE_ANY = "any";

    public static List<RelatedResource> getRelatedResources(Asset asset) {
        return RelationshipUtil.getRelatedResources(RelationshipUtil.getResourceAttributes(asset), TYPE_ANY);
    }

    public static List<RelatedResource> getRelatedChangeRequests(Asset asset) {
        return RelationshipUtil.getRelatedResources(RelationshipUtil.getResourceAttributes(asset), TYPE_CHANGE_REQUEST);
    }

    public static List<RelatedResource> getRelatedRequirements(Asset asset) {
        return RelationshipUtil.getRelatedResources(RelationshipUtil.getResourceAttributes(asset), TYPE_REQUIREMENT);
    }

    public static List<RelatedResource> getRelatedAutomationPlans(Asset asset) {
        return RelationshipUtil.getRelatedResources(RelationshipUtil.getResourceAttributes(asset), TYPE_AUTOMATION_PLAN);
    }

    public static List<RelatedResource> getRelatedAutomationResults(Asset asset) {
        return RelationshipUtil.getRelatedResources(RelationshipUtil.getResourceAttributes(asset), TYPE_AUTOMATION_RESULT);
    }

    public static List<RelatedResource> getRelatedAutomationRequests(Asset asset) {
        return RelationshipUtil.getRelatedResources(RelationshipUtil.getResourceAttributes(asset), TYPE_AUTOMATION_REQUEST);
    }

    public static List<RelatedResource> getRelatedTestPlans(Asset asset) {
        return RelationshipUtil.getRelatedResources(RelationshipUtil.getResourceAttributes(asset), TYPE_TEST_PLAN);
    }

    public static List<RelatedResource> getRelatedTestCases(Asset asset) {
        return RelationshipUtil.getRelatedResources(RelationshipUtil.getResourceAttributes(asset), TYPE_TEST_CASE);
    }

    public static List<RelatedResource> getRelatedTestResults(Asset asset) {
        return RelationshipUtil.getRelatedResources(RelationshipUtil.getResourceAttributes(asset), TYPE_TEST_RESULT);
    }

    public static List<RelatedResource> getRelatedTestExecutionRecords(Asset asset) {
        return RelationshipUtil.getRelatedResources(RelationshipUtil.getResourceAttributes(asset), TYPE_TEST_EXECUTION_RECORD);
    }

    public static List<RelatedResource> getRelatedTestScripts(Asset asset) {
        return RelationshipUtil.getRelatedResources(RelationshipUtil.getResourceAttributes(asset), TYPE_TEST_SCRIPT);
    }

    public static List<RelatedResource> getRelatedArchitectureManagementResources(Asset asset) {
        return RelationshipUtil.getRelatedResources(RelationshipUtil.getResourceAttributes(asset), TYPE_ARCHITECTURE_MANAGEMENT_RESOURCE);
    }

    private static List<RelatedResource> getRelatedResources(List<AttributeValue> attributes, String type) {
        ArrayList<RelatedResource> resources = new ArrayList<RelatedResource>();
        for (AttributeValue attrValue : attributes) {
            List<String> values = attrValue.getValues();
            if (values.isEmpty()) continue;
            String value = values.get(0);
            ResourceAttributeValue resourceValue = JsonUtil.getGson().fromJson(value, ResourceAttributeValue.class);
            Set<RelatedResource> res = resourceValue.getLinks();
            boolean any = type.equals(TYPE_ANY);
            for (RelatedResource r : res) {
                if (!any && !type.equals(r.getType())) continue;
                r.setAttributeUri(attrValue.getAttribute().getHref());
                resources.add(r);
            }
        }
        return resources;
    }

    private static List<AttributeValue> getResourceAttributes(Asset asset) {
        ArrayList<AttributeValue> resourceAttributes = new ArrayList<AttributeValue>();
        List<AttributeValue> attrValues = asset.getRAMAttributeValues();
        for (AttributeValue attrValue : attrValues) {
            AssetAttribute attribute = attrValue.getAttribute().getValue();
            if (attribute == null || !AttributeType.RESOURCE.equals((Object)attribute.getType())) continue;
            resourceAttributes.add(attrValue);
        }
        return resourceAttributes;
    }

    private static AttributeValue getAttribute(Asset asset, String uri) {
        List<AttributeValue> attrValues = asset.getRAMAttributeValues();
        if (attrValues.isEmpty()) {
            return null;
        }
        if (uri == null || uri.length() == 0) {
            return attrValues.get(0);
        }
        for (AttributeValue attrValue : attrValues) {
            if (!attrValue.getAttribute().getHref().equals(uri)) continue;
            return attrValue;
        }
        return attrValues.get(0);
    }

    public static void setRelatedChangeRequests(Asset asset, List<RelatedResource> changeRequests) {
        RelationshipUtil.setRelatedResources(asset, changeRequests);
    }

    public static void setRelatedRequirements(Asset asset, List<RelatedResource> requirements) {
        RelationshipUtil.setRelatedResources(asset, requirements);
    }

    public static void setRelatedAutomationPlans(Asset asset, List<RelatedResource> automationPlans) {
        RelationshipUtil.setRelatedResources(asset, automationPlans);
    }

    public static void setRelatedAutomationRequests(Asset asset, List<RelatedResource> automationRequests) {
        RelationshipUtil.setRelatedResources(asset, automationRequests);
    }

    public static void setRelatedAutomationResults(Asset asset, List<RelatedResource> automationResults) {
        RelationshipUtil.setRelatedResources(asset, automationResults);
    }

    public static void setRelatedTestPlans(Asset asset, List<RelatedResource> testPlans) {
        RelationshipUtil.setRelatedResources(asset, testPlans);
    }

    public static void setRelatedTestCases(Asset asset, List<RelatedResource> testCases) {
        RelationshipUtil.setRelatedResources(asset, testCases);
    }

    public static void setRelatedTestResults(Asset asset, List<RelatedResource> testResults) {
        RelationshipUtil.setRelatedResources(asset, testResults);
    }

    public static void setRelatedTestScripts(Asset asset, List<RelatedResource> testScripts) {
        RelationshipUtil.setRelatedResources(asset, testScripts);
    }

    public static void setRelatedTestExecutionRecords(Asset asset, List<RelatedResource> testExecutionRecords) {
        RelationshipUtil.setRelatedResources(asset, testExecutionRecords);
    }

    public static void setRelatedArchitectureManagementResources(Asset asset, List<RelatedResource> architectureManagementResources) {
        RelationshipUtil.setRelatedResources(asset, architectureManagementResources);
    }

    private static Map<String, AttributeValue> getAttributes(Asset asset, List<RelatedResource> resources) {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        List<AttributeValue> attributes = asset.getRAMAttributeValues();
        block0: for (RelatedResource resource : resources) {
            if (resource.getAttributeUri() == null) continue;
            for (AttributeValue attribute : attributes) {
                if (!attribute.getAttribute().getHref().equals(resource.getAttributeUri())) continue;
                map.put(resource.getAttributeUri(), attribute);
                continue block0;
            }
        }
        return map;
    }

    public static void setRelatedResources(Asset asset, List<RelatedResource> resources) {
        if (resources != null) {
            Map<String, AttributeValue> attributes = RelationshipUtil.getAttributes(asset, resources);
            for (AttributeValue attribute : attributes.values()) {
                attribute.getValues().clear();
            }
            for (RelatedResource resource : resources) {
                if (resource.getAttributeUri() == null) {
                    throw new IllegalArgumentException("Attribute URI is null for related resource: " + resource.getUrl());
                }
                AttributeValue attribute = RelationshipUtil.getAttribute(asset, resource.getAttributeUri());
                if (attribute == null) {
                    throw new IllegalArgumentException("Attribute not found: " + resource.getAttributeUri());
                }
                List<String> values = attribute.getValues();
                ResourceAttributeValue resourceValue = null;
                resourceValue = values != null && !values.isEmpty() ? JsonUtil.getGson().fromJson(values.get(0), ResourceAttributeValue.class) : new ResourceAttributeValue();
                resourceValue.getLinks().add(resource);
                attribute.getValues().clear();
                attribute.getValues().add(JsonUtil.getGson().toJson(resourceValue));
            }
        }
    }
}

