/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client;

import com.ibm.ram.internal.client.RAMClientUtilities;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class HttpclientSecureProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static String className = HttpclientSecureProtocolSocketFactory.class.getName();
    private static final Logger logger = Logger.getLogger((String)className);
    private List contextOrder = null;
    private SSLContext currentContext = null;

    public HttpclientSecureProtocolSocketFactory() {
        if (this.contextOrder == null) {
            this.contextOrder = RAMClientUtilities.getSSLContexts();
        }
        this.currentContext = RAMClientUtilities.getNextAvailableContext(this.currentContext, null, this.contextOrder);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        Socket s = null;
        SSLContext firstContext = this.currentContext;
        while (true) {
            try {
                s = this.currentContext.getSocketFactory().createSocket(socket, host, port, autoClose);
                if (!(s instanceof SSLSocket)) break;
                SSLSocket sslSocket = (SSLSocket)s;
                sslSocket.startHandshake();
            }
            catch (SSLHandshakeException e) {
                logger.log((Priority)Level.DEBUG, (Object)("Creating socket failed with SSL protocol: " + (this.currentContext == null ? "?" : this.currentContext.getProtocol())));
                logger.log((Priority)Level.DEBUG, (Object)"Creating socket failed. Trying next SSL protocol", (Throwable)e);
                this.currentContext = RAMClientUtilities.getNextAvailableContext(this.currentContext, firstContext, this.contextOrder);
                if (this.currentContext != null) continue;
            }
            break;
        }
        return s;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket s = null;
        SSLContext firstContext = this.currentContext;
        while (true) {
            try {
                s = this.currentContext.getSocketFactory().createSocket(host, port);
                if (!(s instanceof SSLSocket)) break;
                SSLSocket sslSocket = (SSLSocket)s;
                sslSocket.startHandshake();
            }
            catch (SSLHandshakeException e) {
                logger.log((Priority)Level.DEBUG, (Object)("Creating socket failed with SSL protocol: " + (this.currentContext == null ? "?" : this.currentContext.getProtocol())));
                logger.log((Priority)Level.DEBUG, (Object)"Creating socket failed. Trying next SSL protocol", (Throwable)e);
                this.currentContext = RAMClientUtilities.getNextAvailableContext(this.currentContext, firstContext, this.contextOrder);
                if (this.currentContext != null) continue;
            }
            break;
        }
        return s;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        Socket s = null;
        SSLContext firstContext = this.currentContext;
        while (true) {
            try {
                s = this.currentContext.getSocketFactory().createSocket(host, port, localAddress, localPort);
                if (!(s instanceof SSLSocket)) break;
                SSLSocket sslSocket = (SSLSocket)s;
                sslSocket.startHandshake();
            }
            catch (SSLHandshakeException e) {
                logger.log((Priority)Level.DEBUG, (Object)("Creating socket failed with SSL protocol: " + (this.currentContext == null ? "?" : this.currentContext.getProtocol())));
                logger.log((Priority)Level.DEBUG, (Object)"Creating socket failed. Trying next SSL protocol", (Throwable)e);
                this.currentContext = RAMClientUtilities.getNextAvailableContext(this.currentContext, firstContext, this.contextOrder);
                if (this.currentContext != null) continue;
            }
            break;
        }
        return s;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        return this.createSocket(host, port, localAddress, localPort);
    }
}

